/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.wizards.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class NewFolderDialog
extends SelectionStatusDialog {
    private Text fFolderName;
    private final IFolder fParentFolder;

    public NewFolderDialog(Shell shell, TmfTraceFolder parent) {
        super(shell);
        this.fParentFolder = parent.getResource();
        this.setTitle(Messages.NewFolderDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createFolderNameGroup(composite);
        return composite;
    }

    private void createFolderNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label folderLabel = new Label(folderGroup, 0);
        folderLabel.setFont(font);
        folderLabel.setText(Messages.NewFolderDialog_FolderName);
        this.fFolderName = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fFolderName.setLayoutData((Object)data);
        this.fFolderName.setFont(font);
        this.fFolderName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewFolderDialog.this.validateNewFolderName();
            }
        });
    }

    private void validateNewFolderName() {
        String name = this.fFolderName.getText();
        IWorkspace workspace = this.fParentFolder.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 2);
        if ("".equals(name)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        if (this.fParentFolder.findMember(name) != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.tracecompass.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        IFolder folder = this.createNewFolder(this.fFolderName.getText());
        if (folder == null) {
            return;
        }
        this.setSelectionResult(new IFolder[]{folder});
        super.okPressed();
    }

    private IFolder createNewFolder(String folderName) {
        final IFolder folder = this.fParentFolder.getFolder((IPath)new Path(folderName));
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 1000);
                    folder.create(false, true, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException | RuntimeException exception) {
            return null;
        }
        catch (InvocationTargetException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"", (String)NLS.bind((String)"", (Object)exception.getTargetException().getMessage()));
            return null;
        }
        return folder;
    }
}

