/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.callstack;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.callstack.FunctionNameMapper;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.callstack.AbstractCallStackAnalysis;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEntry;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEvent;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphCombo;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphSelection;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

public class CallStackView
extends TmfView
implements ITmfTimeAligned {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.callstack";
    private static final String[] COLUMN_TIMES = new String[]{Messages.CallStackView_FunctionColumn, Messages.CallStackView_DepthColumn, Messages.CallStackView_EntryTimeColumn, Messages.CallStackView_ExitTimeColumn, Messages.CallStackView_DurationColumn};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 50, 120, 120, 120};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final double SPACING_RATIO = 0.01;
    private static final Image THREAD_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/thread_obj.gif");
    private static final Image STACKFRAME_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/stckframe_obj.gif");
    private static final String IMPORT_MAPPING_ICON_PATH = "icons/etool16/import.gif";
    private static final String IMPORT_BINARY_ICON_PATH = "icons/obj16/binaries_obj.gif";
    private static final ImageDescriptor SORT_BY_NAME_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha.gif");
    private static final ImageDescriptor SORT_BY_NAME_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha_rev.gif");
    private static final ImageDescriptor SORT_BY_ID_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num.gif");
    private static final ImageDescriptor SORT_BY_ID_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num_rev.gif");
    private static final ImageDescriptor SORT_BY_TIME_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_time.gif");
    private static final ImageDescriptor SORT_BY_TIME_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_time_rev.gif");
    private static final String SORT_OPTION_KEY = "sort.option";
    private SortOption fSortOption;
    private Comparator<ITimeGraphEntry> fThreadComparator = null;
    private Action fSortByNameAction;
    private Action fSortByIdAction;
    private Action fSortByTimeAction;
    private TimeGraphCombo fTimeGraphCombo;
    private ITmfTrace fTrace;
    private final Map<ITmfTrace, String> fSelectedThreadMap = new HashMap<ITmfTrace, String>();
    private List<TraceEntry> fEntryList;
    private final Map<ITmfTrace, List<TraceEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TraceEntry>>();
    private final Map<ITmfTrace, BuildThread> fBuildThreadMap = new HashMap<ITmfTrace, BuildThread>();
    private Map<String, String> fNameMapping;
    private long fStartTime;
    private long fEndTime;
    private int fDisplayWidth;
    private Action fNextEventAction;
    private Action fPrevEventAction;
    private Action fNextItemAction;
    private Action fPreviousItemAction;
    private Action fImportMappingAction;
    private Action fImportBinaryFileMappingAction;
    private ZoomThread fZoomThread;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private TmfSelectionRangeUpdatedSignal fSavedTimeSyncSignal;
    private TmfWindowRangeUpdatedSignal fSavedRangeSyncSignal;

    public CallStackView() {
        super(ID);
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    @Override
    public void createPartControl(Composite parent) {
        ITmfTrace trace;
        super.createPartControl(parent);
        this.fTimeGraphCombo = new TimeGraphCombo(parent, 0);
        this.fTimeGraphCombo.setTreeContentProvider(new TimeGraphContentProvider());
        this.fTimeGraphCombo.setTreeLabelProvider(new TreeLabelProvider());
        this.fTimeGraphCombo.setTreeColumns(COLUMN_TIMES);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(0).setWidth(COLUMN_WIDTHS[0]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(1).setWidth(COLUMN_WIDTHS[1]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(2).setWidth(COLUMN_WIDTHS[2]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(3).setWidth(COLUMN_WIDTHS[3]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(4).setWidth(COLUMN_WIDTHS[4]);
        this.fTimeGraphCombo.setTimeGraphContentProvider(new TimeGraphContentProvider());
        this.fTimeGraphCombo.setTimeGraphProvider(new CallStackPresentationProvider(this));
        this.fTimeGraphCombo.getTimeGraphViewer().setTimeFormat(Utils.TimeFormat.CALENDAR);
        this.fTimeGraphCombo.getTimeGraphViewer().addRangeListener(new ITimeGraphRangeListener(){

            @Override
            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(startTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime));
                CallStackView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)CallStackView.this, range));
                CallStackView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().addTimeListener(new ITimeGraphTimeListener(){

            @Override
            public void timeSelected(TimeGraphTimeEvent event) {
                long beginTime = event.getBeginTime();
                long endTime = event.getEndTime();
                CallStackView.this.synchingToTime(beginTime);
                CallStackView.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)CallStackView.this, (ITmfTimestamp)new TmfNanoTimestamp(beginTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime)));
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CallStackView.this.fDisplayWidth = ((CallStackView)CallStackView.this).fTimeGraphCombo.getTimeGraphViewer().getControl().getSize().x;
                if (CallStackView.this.fEntryList != null) {
                    CallStackView.this.startZoomThread(CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime0(), CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime1());
                }
            }
        });
        this.fTimeGraphCombo.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CallStackEntry entry;
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof CallStackEntry && (entry = (CallStackEntry)selection).getFunctionName().length() > 0) {
                    long entryTime = entry.getFunctionEntryTime();
                    long exitTime = entry.getFunctionExitTime();
                    long spacingTime = (long)((double)(exitTime - entryTime) * 0.01);
                    TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(entryTime -= spacingTime), (ITmfTimestamp)new TmfNanoTimestamp(exitTime += spacingTime));
                    CallStackView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)CallStackView.this, range));
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(entryTime, exitTime);
                    CallStackView.this.startZoomThread(entryTime, exitTime);
                }
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object o;
                TimeGraphControl timeGraphControl = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTimeGraphControl();
                ISelection selection = timeGraphControl.getSelection();
                if (selection instanceof TimeGraphSelection && (o = ((TimeGraphSelection)selection).getFirstElement()) instanceof CallStackEvent) {
                    CallStackEvent event = (CallStackEvent)o;
                    long startTime = event.getTime();
                    long endTime = startTime + event.getDuration();
                    long spacingTime = (long)((double)(endTime - startTime) * 0.01);
                    TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(startTime -= spacingTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime += spacingTime));
                    CallStackView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)CallStackView.this, range));
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                    CallStackView.this.startZoomThread(startTime, endTime);
                }
            }
        });
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fTimeGraphCombo.getTimeGraphViewer().getTimeGraphControl().setStatusLineManager(statusLineManager);
        this.makeActions();
        this.contributeToActionBars();
        this.createContextMenu();
        this.loadSortOption();
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    public void setFocus() {
        this.fTimeGraphCombo.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        Map<ITmfTrace, Object> map = this.fBuildThreadMap;
        synchronized (map) {
            for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)signal.getTrace())) {
                BuildThread buildThread = this.fBuildThreadMap.remove(trace);
                if (buildThread == null) continue;
                buildThread.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(signal.getTrace());
        }
        this.fSelectedThreadMap.remove(signal.getTrace());
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fStartTime = 0L;
            this.fEndTime = 0L;
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        TmfSelectionRangeUpdatedSignal tmfSelectionRangeUpdatedSignal = this.fSavedTimeSyncSignal = this.isPinned() ? new TmfSelectionRangeUpdatedSignal(signal.getSource(), signal.getBeginTime(), signal.getEndTime()) : null;
        if (signal.getSource() == this || this.fTrace == null || this.isPinned()) {
            return;
        }
        final long beginTime = signal.getBeginTime().normalize(0L, -9).getValue();
        final long endTime = signal.getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                if (beginTime == endTime) {
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectedTime(beginTime, true);
                } else {
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectionRange(beginTime, endTime);
                }
                CallStackView.this.synchingToTime(beginTime);
                CallStackView.this.startZoomThread(CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime0(), CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime1());
                if (CallStackView.this.fEntryList == null) {
                    return;
                }
                TimeGraphViewer viewer = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer();
                block2: for (TraceEntry traceEntry : CallStackView.this.fEntryList) {
                    for (ITimeGraphEntry iTimeGraphEntry : traceEntry.getChildren()) {
                        ThreadEntry threadEntry = (ThreadEntry)iTimeGraphEntry;
                        ITmfStateSystem ss = threadEntry.getStateSystem();
                        if (ss == null || beginTime < ss.getStartTime() || beginTime > ss.getCurrentEndTime()) continue;
                        try {
                            int quark = threadEntry.getCallStackQuark();
                            ITmfStateInterval stackInterval = ss.querySingleState(beginTime, quark);
                            if (beginTime != stackInterval.getStartTime()) continue;
                            int stackLevel = stackInterval.getStateValue().unboxInt();
                            ITimeGraphEntry selectedEntry = threadEntry.getChildren().get(Math.max(0, stackLevel - 1));
                            CallStackView.this.fTimeGraphCombo.setSelection(selectedEntry);
                            viewer.getTimeGraphControl().fireSelectionChanged();
                            continue block2;
                        }
                        catch (AttributeNotFoundException | StateSystemDisposedException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                    }
                }
            }
        });
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (this.isPinned()) {
            this.fSavedRangeSyncSignal = new TmfWindowRangeUpdatedSignal(signal.getSource(), new TmfTimeRange(signal.getCurrentRange().getStartTime(), signal.getCurrentRange().getEndTime()));
            this.fSavedTimeSyncSignal = null;
        }
        if (signal.getSource() == this || this.fTrace == null || this.isPinned()) {
            return;
        }
        if (signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange()) == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                CallStackView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace() {
        Map<ITmfTrace, List<TraceEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            if (this.fEntryList == null) {
                this.fStartTime = Long.MAX_VALUE;
                this.fEndTime = Long.MIN_VALUE;
                this.refresh();
                Map<ITmfTrace, BuildThread> map2 = this.fBuildThreadMap;
                synchronized (map2) {
                    for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace)) {
                        trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)trace);
                        BuildThread buildThread = new BuildThread(trace, this.fTrace);
                        this.fBuildThreadMap.put(trace, buildThread);
                        buildThread.start();
                    }
                }
            } else {
                this.fStartTime = this.fTrace.getStartTime().normalize(0L, -9).getValue();
                this.fEndTime = this.fTrace.getEndTime().normalize(0L, -9).getValue();
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private void buildThreadList(@NonNull ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        AbstractCallStackAnalysis module = CallStackView.getCallStackModule(trace);
        if (module == null) {
            this.addUnavailableEntry(trace, parentTrace);
            return;
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            this.addUnavailableEntry(trace, parentTrace);
            return;
        }
        HashMap<ITmfTrace, TraceEntry> traceEntryMap = new HashMap<ITmfTrace, TraceEntry>();
        HashMap<Integer, ThreadEntry> threadEntryMap = new HashMap<Integer, ThreadEntry>();
        String[] threadPaths = module.getThreadsPattern();
        long start = ss.getStartTime();
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ss.waitUntilBuilt(500L);
            if (ss.isCancelled()) {
                return;
            }
            long end = ss.getCurrentEndTime();
            if (start == end && !complete) continue;
            List threadQuarks = ss.getQuarks(threadPaths);
            TraceEntry traceEntry = (TraceEntry)traceEntryMap.get(trace);
            if (traceEntry == null) {
                traceEntry = new TraceEntry(trace.getName(), start, end + 1L);
                traceEntryMap.put(trace, traceEntry);
                traceEntry.sortChildren(this.fThreadComparator);
                this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
            } else {
                traceEntry.updateEndTime(end);
            }
            int i2 = 0;
            while (i2 < threadQuarks.size()) {
                if (monitor.isCanceled()) {
                    return;
                }
                int threadQuark = (Integer)threadQuarks.get(i2);
                try {
                    ThreadEntry threadEntry;
                    String[] callStackPath = module.getCallStackPath();
                    int callStackQuark = ss.getQuarkRelative(threadQuark, callStackPath);
                    String threadName = ss.getAttributeName(threadQuark);
                    long threadEnd = end + 1L;
                    ITmfStateInterval endInterval = ss.querySingleState(ss.getCurrentEndTime(), callStackQuark);
                    if (endInterval.getStateValue().isNull() && endInterval.getStartTime() != ss.getStartTime()) {
                        threadEnd = endInterval.getStartTime();
                    }
                    if ((threadEntry = (ThreadEntry)threadEntryMap.get(threadQuark)) == null) {
                        long threadId = ss.querySingleState(ss.getCurrentEndTime(), threadQuark).getStateValue().unboxLong();
                        long threadStart = start;
                        ITmfStateInterval startInterval = ss.querySingleState(start, callStackQuark);
                        if (startInterval.getStateValue().isNull()) {
                            threadStart = Math.min(startInterval.getEndTime() + 1L, end + 1L);
                        }
                        threadEntry = new ThreadEntry(ss, threadName, threadId, callStackQuark, threadStart, threadEnd);
                        threadEntryMap.put(threadQuark, threadEntry);
                        traceEntry.addChild(threadEntry);
                    } else {
                        threadEntry.updateEndTime(threadEnd);
                    }
                    int level = 1;
                    Iterator iterator = ss.getSubAttributes(callStackQuark, false).iterator();
                    while (iterator.hasNext()) {
                        int stackLevelQuark = (Integer)iterator.next();
                        if (level > threadEntry.getChildren().size()) {
                            CallStackEntry callStackEntry = new CallStackEntry(threadName, stackLevelQuark, level, trace, ss);
                            threadEntry.addChild(callStackEntry);
                        }
                        ++level;
                    }
                }
                catch (AttributeNotFoundException e) {
                    Activator.getDefault().logError("Error querying state system", e);
                }
                catch (StateSystemDisposedException e) {
                    // empty catch block
                }
                ++i2;
            }
            if (parentTrace == this.fTrace) {
                Map<ITmfTrace, List<TraceEntry>> i2 = this.fEntryListMap;
                synchronized (i2) {
                    this.fStartTime = Math.min(this.fStartTime, start);
                    this.fEndTime = Math.max(this.fEndTime, end + 1L);
                }
                this.refresh();
            }
            for (ITimeGraphEntry threadEntry : traceEntry.getChildren()) {
                for (ITimeGraphEntry callStackEntry : threadEntry.getChildren()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.buildStatusEvents(parentTrace, (CallStackEntry)callStackEntry, monitor, start, end);
                }
            }
            start = end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToEntryList(ITmfTrace trace, List<TraceEntry> list) {
        Map<ITmfTrace, List<TraceEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TraceEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList == null) {
                this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TraceEntry>(list));
            } else {
                entryList.addAll(list);
            }
        }
    }

    private void addUnavailableEntry(ITmfTrace trace, ITmfTrace parentTrace) {
        String name = String.valueOf(Messages.CallStackView_StackInfoNotAvailable) + ' ' + '(' + trace.getName() + ')';
        TraceEntry unavailableEntry = new TraceEntry(name, 0L, 0L);
        this.addToEntryList(parentTrace, Collections.singletonList(unavailableEntry));
        if (parentTrace == this.fTrace) {
            this.refresh();
        }
    }

    private void buildStatusEvents(ITmfTrace trace, CallStackEntry entry, IProgressMonitor monitor, long start, long end) {
        ITmfStateSystem ss = entry.getStateSystem();
        long resolution = Math.max(1L, (end - ss.getStartTime()) / (long)this.fDisplayWidth);
        List<ITimeEvent> eventList = CallStackView.getEventList(entry, start, end + 1L, resolution, monitor);
        if (eventList != null) {
            for (ITimeEvent event : eventList) {
                entry.addEvent(event);
            }
        }
        if (trace == this.fTrace) {
            this.redraw();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<ITimeEvent> getEventList(CallStackEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ITmfStateSystem ss = entry.getStateSystem();
        long start = Math.max(startTime, ss.getStartTime());
        long end = Math.min(endTime, ss.getCurrentEndTime() + 1L);
        if (end <= start) {
            return null;
        }
        ArrayList<TimeEvent> eventList = null;
        try {
            List stackIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)entry.getQuark(), (long)start, (long)(end - 1L), (long)resolution, (IProgressMonitor)monitor);
            eventList = new ArrayList<TimeEvent>(stackIntervals.size());
            long lastEndTime = -1L;
            boolean lastIsNull = true;
            Iterator iterator = stackIntervals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return eventList;
                }
                ITmfStateInterval statusInterval = (ITmfStateInterval)iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                long time = statusInterval.getStartTime();
                long duration = statusInterval.getEndTime() - time + 1L;
                if (!statusInterval.getStateValue().isNull()) {
                    int modulo = 180;
                    int value = statusInterval.getStateValue().toString().hashCode() % 180 + 180;
                    eventList.add(new CallStackEvent(entry, time, duration, value));
                    lastIsNull = false;
                } else {
                    if (lastEndTime == -1L) {
                        eventList.add(new NullTimeEvent(entry, time, duration));
                    } else {
                        if (lastEndTime != time && lastIsNull) {
                            eventList.add(new TimeEvent(entry, lastEndTime, time - lastEndTime));
                        }
                        if (time + duration >= endTime) {
                            eventList.add(new NullTimeEvent(entry, time, duration));
                        }
                    }
                    lastIsNull = true;
                }
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getDefault().logError("Error querying state system", e);
            return eventList;
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error querying state system", e);
            return eventList;
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return eventList;
    }

    private void synchingToTime(long time) {
        if (this.fEntryList == null) {
            return;
        }
        for (TraceEntry traceEntry : this.fEntryList) {
            for (ITimeGraphEntry iTimeGraphEntry : traceEntry.getChildren()) {
                ITmfStateSystem ss = ((ThreadEntry)iTimeGraphEntry).getStateSystem();
                if (ss == null || ss.isCancelled() || time < ss.getStartTime() || time > ss.getCurrentEndTime()) continue;
                for (ITimeGraphEntry iTimeGraphEntry2 : iTimeGraphEntry.getChildren()) {
                    CallStackEntry callStackEntry = (CallStackEntry)iTimeGraphEntry2;
                    try {
                        ITmfStateInterval stackLevelInterval = ss.querySingleState(time, callStackEntry.getQuark());
                        ITmfStateValue nameValue = stackLevelInterval.getStateValue();
                        String name = "";
                        try {
                            if (nameValue.getType() == ITmfStateValue.Type.STRING) {
                                String address = nameValue.unboxStr();
                                name = this.getFunctionName(address);
                            } else if (nameValue.getType() == ITmfStateValue.Type.INTEGER) {
                                name = "0x" + Integer.toHexString(nameValue.unboxInt());
                            } else if (nameValue.getType() == ITmfStateValue.Type.LONG) {
                                name = "0x" + Long.toHexString(nameValue.unboxLong());
                            }
                        }
                        catch (StateValueTypeException stateValueTypeException) {
                            // empty catch block
                        }
                        callStackEntry.setFunctionName(name);
                        if (name.length() <= 0) continue;
                        callStackEntry.setFunctionEntryTime(stackLevelInterval.getStartTime());
                        callStackEntry.setFunctionExitTime(stackLevelInterval.getEndTime() + 1L);
                    }
                    catch (AttributeNotFoundException e) {
                        Activator.getDefault().logError("Error querying state system", e);
                    }
                    catch (StateSystemDisposedException stateSystemDisposedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.fTimeGraphCombo.refresh();
    }

    private void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                Map map = CallStackView.this.fEntryListMap;
                synchronized (map) {
                    CallStackView.this.fEntryList = (List)CallStackView.this.fEntryListMap.get(CallStackView.this.fTrace);
                    if (CallStackView.this.fEntryList == null) {
                        CallStackView.this.fEntryList = new ArrayList();
                    }
                    for (TraceEntry traceEntry : CallStackView.this.fEntryList) {
                        traceEntry.sortChildren(CallStackView.this.fThreadComparator);
                    }
                }
                if (CallStackView.this.fEntryList != CallStackView.this.fTimeGraphCombo.getInput()) {
                    CallStackView.this.fTimeGraphCombo.setInput(CallStackView.this.fEntryList);
                } else {
                    CallStackView.this.fTimeGraphCombo.refresh();
                }
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setTimeBounds(CallStackView.this.fStartTime, CallStackView.this.fEndTime);
                TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
                long selectionBeginTime = CallStackView.this.fTrace == null ? 0L : ctx.getSelectionRange().getStartTime().normalize(0L, -9).getValue();
                long selectionEndTime = CallStackView.this.fTrace == null ? 0L : ctx.getSelectionRange().getEndTime().normalize(0L, -9).getValue();
                long startTime = CallStackView.this.fTrace == null ? 0L : ctx.getWindowRange().getStartTime().normalize(0L, -9).getValue();
                long endTime = CallStackView.this.fTrace == null ? 0L : ctx.getWindowRange().getEndTime().normalize(0L, -9).getValue();
                startTime = Math.max(startTime, CallStackView.this.fStartTime);
                endTime = Math.min(endTime, CallStackView.this.fEndTime);
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectionRange(selectionBeginTime, selectionEndTime);
                CallStackView.this.synchingToTime(selectionBeginTime);
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                CallStackView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                CallStackView.this.fTimeGraphCombo.redraw();
                CallStackView.this.fTimeGraphCombo.update();
                Object object = CallStackView.this.fSyncObj;
                synchronized (object) {
                    if (CallStackView.this.fRedrawState == State.PENDING) {
                        CallStackView.this.fRedrawState = State.IDLE;
                        CallStackView.this.redraw();
                    } else {
                        CallStackView.this.fRedrawState = State.IDLE;
                    }
                }
            }
        });
    }

    private void startZoomThread(long startTime, long endTime) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.fZoomThread = new ZoomThread(this.fEntryList, startTime, endTime);
        this.fZoomThread.start();
    }

    private void makeActions() {
        this.fPreviousItemAction = this.fTimeGraphCombo.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousItemAction.setText(Messages.TmfTimeGraphViewer_PreviousItemActionNameText);
        this.fPreviousItemAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousItemActionToolTipText);
        this.fNextItemAction = this.fTimeGraphCombo.getTimeGraphViewer().getNextItemAction();
        this.fNextItemAction.setText(Messages.TmfTimeGraphViewer_NextItemActionNameText);
        this.fNextItemAction.setToolTipText(Messages.TmfTimeGraphViewer_NextItemActionToolTipText);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.contributePinActionToToolBar();
        this.fPinAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty()) && !CallStackView.this.isPinned()) {
                    if (CallStackView.this.fSavedRangeSyncSignal != null) {
                        CallStackView.this.windowRangeUpdated(CallStackView.this.fSavedRangeSyncSignal);
                        CallStackView.this.fSavedRangeSyncSignal = null;
                    }
                    if (CallStackView.this.fSavedTimeSyncSignal != null) {
                        CallStackView.this.selectionRangeUpdated(CallStackView.this.fSavedTimeSyncSignal);
                        CallStackView.this.fSavedTimeSyncSignal = null;
                    }
                }
            }
        });
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.getImportBinaryAction());
        manager.add((IAction)this.getImportMappingAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getSortByNameAction());
        manager.add((IAction)this.getSortByIdAction());
        manager.add((IAction)this.getSortByTimeAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getResetScaleAction());
        manager.add((IAction)this.getPreviousEventAction());
        manager.add((IAction)this.getNextEventAction());
        manager.add((IAction)this.fPreviousItemAction);
        manager.add((IAction)this.fNextItemAction);
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getZoomInAction());
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    private void createContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.add((IAction)this.getSortByNameAction());
        contextMenu.add((IAction)this.getSortByIdAction());
        contextMenu.add((IAction)this.getSortByTimeAction());
        Tree tree = this.fTimeGraphCombo.getTreeViewer().getTree();
        Menu menu = contextMenu.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private Action getNextEventAction() {
        if (this.fNextEventAction == null) {
            this.fNextEventAction = new Action(){

                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof CallStackEntry) {
                        try {
                            CallStackEntry callStackEntry = (CallStackEntry)entry;
                            ITmfStateSystem ss = callStackEntry.getStateSystem();
                            long time = Math.max(ss.getStartTime(), Math.min(ss.getCurrentEndTime(), viewer.getSelectionBegin()));
                            ThreadEntry threadEntry = (ThreadEntry)callStackEntry.getParent();
                            int quark = ss.getParentAttributeQuark(callStackEntry.getQuark());
                            ITmfStateInterval stackInterval = ss.querySingleState(time, quark);
                            long newTime = stackInterval.getEndTime() + 1L;
                            viewer.setSelectedTimeNotify(newTime, true);
                            stackInterval = ss.querySingleState(Math.min(ss.getCurrentEndTime(), newTime), quark);
                            int stackLevel = stackInterval.getStateValue().unboxInt();
                            ITimeGraphEntry selectedEntry = threadEntry.getChildren().get(Math.max(0, stackLevel - 1));
                            CallStackView.this.fTimeGraphCombo.setSelection(selectedEntry);
                            viewer.getTimeGraphControl().fireSelectionChanged();
                            CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                        }
                        catch (AttributeNotFoundException | StateSystemDisposedException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                    }
                }
            };
            this.fNextEventAction.setText(Messages.TmfTimeGraphViewer_NextEventActionNameText);
            this.fNextEventAction.setToolTipText(Messages.TmfTimeGraphViewer_NextEventActionToolTipText);
            this.fNextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_event.gif"));
        }
        return this.fNextEventAction;
    }

    private Action getPreviousEventAction() {
        if (this.fPrevEventAction == null) {
            this.fPrevEventAction = new Action(){

                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof CallStackEntry) {
                        try {
                            CallStackEntry callStackEntry = (CallStackEntry)entry;
                            ITmfStateSystem ss = callStackEntry.getStateSystem();
                            long time = Math.max(ss.getStartTime(), Math.min(ss.getCurrentEndTime(), viewer.getSelectionBegin()));
                            ThreadEntry threadEntry = (ThreadEntry)callStackEntry.getParent();
                            int quark = ss.getParentAttributeQuark(callStackEntry.getQuark());
                            ITmfStateInterval stackInterval = ss.querySingleState(time, quark);
                            if (stackInterval.getStartTime() == time && time > ss.getStartTime()) {
                                stackInterval = ss.querySingleState(time - 1L, quark);
                            }
                            viewer.setSelectedTimeNotify(stackInterval.getStartTime(), true);
                            int stackLevel = stackInterval.getStateValue().unboxInt();
                            ITimeGraphEntry selectedEntry = threadEntry.getChildren().get(Math.max(0, stackLevel - 1));
                            CallStackView.this.fTimeGraphCombo.setSelection(selectedEntry);
                            viewer.getTimeGraphControl().fireSelectionChanged();
                            CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                        }
                        catch (AttributeNotFoundException | StateSystemDisposedException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                    }
                }
            };
            this.fPrevEventAction.setText(Messages.TmfTimeGraphViewer_PreviousEventActionNameText);
            this.fPrevEventAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousEventActionToolTipText);
            this.fPrevEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_event.gif"));
        }
        return this.fPrevEventAction;
    }

    @Nullable
    private static AbstractCallStackAnalysis getCallStackModule(@NonNull ITmfTrace trace) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, AbstractCallStackAnalysis.class);
        Iterator it = modules.iterator();
        if (!it.hasNext()) {
            return null;
        }
        AbstractCallStackAnalysis module = (AbstractCallStackAnalysis)((Object)it.next());
        module.schedule();
        module.waitForInitialization();
        return module;
    }

    private Action getImportMappingAction() {
        if (this.fImportMappingAction != null) {
            return this.fImportMappingAction;
        }
        this.fImportMappingAction = new AbstractImportFileMappingAction(this, Messages.CallStackView_ImportMappingDialogTitle){

            @Override
            Map<String, String> doMapping(File file) {
                return FunctionNameMapper.mapFromNmTextFile((File)file);
            }
        };
        this.fImportMappingAction.setText(Messages.CallStackView_ImportMappingButtonText);
        this.fImportMappingAction.setToolTipText(Messages.CallStackView_ImportMappingButtonTooltip);
        this.fImportMappingAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(IMPORT_MAPPING_ICON_PATH));
        return this.fImportMappingAction;
    }

    private Action getSortByNameAction() {
        if (this.fSortByNameAction == null) {
            this.fSortByNameAction = new Action(Messages.CallStackView_SortByThreadName, 2){

                public void run() {
                    if (CallStackView.this.fSortOption == SortOption.BY_NAME) {
                        CallStackView.this.saveSortOption(SortOption.BY_NAME_REV);
                    } else {
                        CallStackView.this.saveSortOption(SortOption.BY_NAME);
                    }
                }
            };
            this.fSortByNameAction.setToolTipText(Messages.CallStackView_SortByThreadName);
            this.fSortByNameAction.setImageDescriptor(SORT_BY_NAME_ICON);
        }
        return this.fSortByNameAction;
    }

    private Action getSortByIdAction() {
        if (this.fSortByIdAction == null) {
            this.fSortByIdAction = new Action(Messages.CallStackView_SortByThreadId, 2){

                public void run() {
                    if (CallStackView.this.fSortOption == SortOption.BY_ID) {
                        CallStackView.this.saveSortOption(SortOption.BY_ID_REV);
                    } else {
                        CallStackView.this.saveSortOption(SortOption.BY_ID);
                    }
                }
            };
            this.fSortByIdAction.setToolTipText(Messages.CallStackView_SortByThreadId);
            this.fSortByIdAction.setImageDescriptor(SORT_BY_ID_ICON);
        }
        return this.fSortByIdAction;
    }

    private Action getSortByTimeAction() {
        if (this.fSortByTimeAction == null) {
            this.fSortByTimeAction = new Action(Messages.CallStackView_SortByThreadTime, 2){

                public void run() {
                    if (CallStackView.this.fSortOption == SortOption.BY_TIME) {
                        CallStackView.this.saveSortOption(SortOption.BY_TIME_REV);
                    } else {
                        CallStackView.this.saveSortOption(SortOption.BY_TIME);
                    }
                }
            };
            this.fSortByTimeAction.setToolTipText(Messages.CallStackView_SortByThreadTime);
            this.fSortByTimeAction.setImageDescriptor(SORT_BY_TIME_ICON);
        }
        return this.fSortByTimeAction;
    }

    private void loadSortOption() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getClass().getName());
        if (section == null) {
            return;
        }
        String sortOption = section.get(SORT_OPTION_KEY);
        if (sortOption == null) {
            return;
        }
        this.getSortByNameAction().setChecked(false);
        this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_ICON);
        this.getSortByIdAction().setChecked(false);
        this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_ICON);
        this.getSortByTimeAction().setChecked(false);
        this.getSortByTimeAction().setImageDescriptor(SORT_BY_TIME_ICON);
        if (sortOption.equals(SortOption.BY_NAME.name())) {
            this.fSortOption = SortOption.BY_NAME;
            this.fThreadComparator = new ThreadNameComparator(false);
            this.getSortByNameAction().setChecked(true);
        } else if (sortOption.equals(SortOption.BY_NAME_REV.name())) {
            this.fSortOption = SortOption.BY_NAME_REV;
            this.fThreadComparator = new ThreadNameComparator(true);
            this.getSortByNameAction().setChecked(true);
            this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_REV_ICON);
        } else if (sortOption.equals(SortOption.BY_ID.name())) {
            this.fSortOption = SortOption.BY_ID;
            this.fThreadComparator = new ThreadIdComparator(false);
            this.getSortByIdAction().setChecked(true);
        } else if (sortOption.equals(SortOption.BY_ID_REV.name())) {
            this.fSortOption = SortOption.BY_ID_REV;
            this.fThreadComparator = new ThreadIdComparator(true);
            this.getSortByIdAction().setChecked(true);
            this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_REV_ICON);
        } else if (sortOption.equals(SortOption.BY_TIME.name())) {
            this.fSortOption = SortOption.BY_TIME;
            this.fThreadComparator = new ThreadTimeComparator(false);
            this.getSortByTimeAction().setChecked(true);
        } else if (sortOption.equals(SortOption.BY_TIME_REV.name())) {
            this.fSortOption = SortOption.BY_TIME_REV;
            this.fThreadComparator = new ThreadTimeComparator(true);
            this.getSortByTimeAction().setChecked(true);
            this.getSortByTimeAction().setImageDescriptor(SORT_BY_TIME_REV_ICON);
        }
    }

    private void saveSortOption(SortOption sortOption) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getClass().getName());
        if (section == null) {
            section = settings.addNewSection(this.getClass().getName());
        }
        section.put(SORT_OPTION_KEY, sortOption.name());
        this.loadSortOption();
        if (this.fEntryList == null) {
            return;
        }
        for (TraceEntry traceEntry : this.fEntryList) {
            traceEntry.sortChildren(this.fThreadComparator);
        }
        this.refresh();
    }

    private Action getImportBinaryAction() {
        if (this.fImportBinaryFileMappingAction != null) {
            return this.fImportBinaryFileMappingAction;
        }
        this.fImportBinaryFileMappingAction = new AbstractImportFileMappingAction(this, Messages.CallStackView_ImportBinaryFileDialogTitle){

            @Override
            Map<String, String> doMapping(File file) {
                return FunctionNameMapper.mapFromBinaryFile((File)file);
            }
        };
        this.fImportBinaryFileMappingAction.setText(Messages.CallStackView_ImportBinaryFileButtonText);
        this.fImportBinaryFileMappingAction.setToolTipText(Messages.CallStackView_ImportBinaryFileButtonTooltip);
        this.fImportBinaryFileMappingAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(IMPORT_BINARY_ICON_PATH));
        return this.fImportBinaryFileMappingAction;
    }

    String getFunctionName(String address) {
        if (this.fNameMapping == null) {
            return address;
        }
        String ret = this.fNameMapping.get(address);
        if (ret == null) {
            return address;
        }
        return ret;
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fTimeGraphCombo == null) {
            return null;
        }
        return this.fTimeGraphCombo.getTimeViewAlignmentInfo();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        if (this.fTimeGraphCombo == null) {
            return 0;
        }
        return this.fTimeGraphCombo.getAvailableWidth(requestedOffset);
    }

    @Override
    public void performAlign(int offset, int width) {
        this.fTimeGraphCombo.performAlign(offset, width);
    }

    private abstract class AbstractImportFileMappingAction
    extends Action {
        private final String fDialogTitle;

        private AbstractImportFileMappingAction(String dialogTitle) {
            this.fDialogTitle = dialogTitle;
        }

        public void run() {
            FileDialog dialog = new FileDialog(CallStackView.this.getViewSite().getShell());
            dialog.setText(this.fDialogTitle);
            final String filePath = dialog.open();
            if (filePath == null) {
                return;
            }
            Job job = new Job(Messages.CallStackView_ImportMappingJobName){

                public IStatus run(IProgressMonitor monitor) {
                    CallStackView.this.fNameMapping = AbstractImportFileMappingAction.this.doMapping(new File(filePath));
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CallStackView.this.synchingToTime(CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getSelectionBegin());
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }

        abstract Map<String, String> doMapping(File var1);
    }

    private class BuildThread
    extends Thread {
        @NonNull
        private final ITmfTrace fBuildTrace;
        private final ITmfTrace fParentTrace;
        private final IProgressMonitor fMonitor;

        public BuildThread(ITmfTrace trace, ITmfTrace parentTrace) {
            super("CallStackView build");
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fMonitor = new NullProgressMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CallStackView.this.buildThreadList(this.fBuildTrace, this.fParentTrace, this.fMonitor);
            Map map = CallStackView.this.fBuildThreadMap;
            synchronized (map) {
                CallStackView.this.fBuildThreadMap.remove(this.fBuildTrace);
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }

    private static enum SortOption {
        BY_NAME,
        BY_NAME_REV,
        BY_ID,
        BY_ID_REV,
        BY_TIME,
        BY_TIME_REV;

    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    private class ThreadEntry
    extends TimeGraphEntry {
        private final int fCallStackQuark;
        private final ITmfStateSystem fSS;
        private final long fThreadId;

        public ThreadEntry(ITmfStateSystem ss, String name, long threadId, int callStackQuark, long startTime, long endTime) {
            super(name, startTime, endTime);
            this.fCallStackQuark = callStackQuark;
            this.fThreadId = threadId;
            this.fSS = ss;
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }

        public int getCallStackQuark() {
            return this.fCallStackQuark;
        }

        public long getThreadId() {
            return this.fThreadId;
        }

        @Nullable
        public ITmfStateSystem getStateSystem() {
            return this.fSS;
        }
    }

    private class ThreadIdComparator
    implements Comparator<ITimeGraphEntry> {
        private boolean reverse;

        public ThreadIdComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            ThreadEntry t1 = (ThreadEntry)o1;
            ThreadEntry t2 = (ThreadEntry)o2;
            return this.reverse ? Long.compare(t2.getThreadId(), t1.getThreadId()) : Long.compare(t1.getThreadId(), t2.getThreadId());
        }
    }

    private class ThreadNameComparator
    implements Comparator<ITimeGraphEntry> {
        private boolean reverse;

        public ThreadNameComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            return this.reverse ? o2.getName().compareTo(o1.getName()) : o1.getName().compareTo(o2.getName());
        }
    }

    private class ThreadTimeComparator
    implements Comparator<ITimeGraphEntry> {
        private boolean reverse;

        public ThreadTimeComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            return this.reverse ? Long.compare(o2.getStartTime(), o1.getStartTime()) : Long.compare(o1.getStartTime(), o2.getStartTime());
        }
    }

    private class TraceEntry
    extends TimeGraphEntry {
        public TraceEntry(String name, long startTime, long endTime) {
            super(name, startTime, endTime);
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }
    }

    private class TreeLabelProvider
    implements ITableLabelProvider {
        private TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                CallStackEntry entry;
                if (element instanceof ThreadEntry) {
                    return THREAD_IMAGE;
                }
                if (element instanceof CallStackEntry && (entry = (CallStackEntry)element).getFunctionName().length() > 0) {
                    return STACKFRAME_IMAGE;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CallStackEntry) {
                CallStackEntry entry = (CallStackEntry)element;
                if (columnIndex == 0) {
                    return entry.getFunctionName();
                }
                if (columnIndex == 1 && entry.getFunctionName().length() > 0) {
                    int depth = entry.getStackLevel();
                    return Integer.toString(depth);
                }
                if (columnIndex == 2 && entry.getFunctionName().length() > 0) {
                    TmfTimestamp ts = new TmfTimestamp(entry.getFunctionEntryTime(), -9);
                    return ts.toString();
                }
                if (columnIndex == 3 && entry.getFunctionName().length() > 0) {
                    TmfTimestamp ts = new TmfTimestamp(entry.getFunctionExitTime(), -9);
                    return ts.toString();
                }
                if (columnIndex == 4 && entry.getFunctionName().length() > 0) {
                    TmfTimestampDelta ts = new TmfTimestampDelta(entry.getFunctionExitTime() - entry.getFunctionEntryTime(), -9);
                    return ts.toString();
                }
            } else if (element instanceof ITimeGraphEntry && columnIndex == 0) {
                return ((ITimeGraphEntry)element).getName();
            }
            return "";
        }
    }

    private class ZoomThread
    extends Thread {
        private final List<TraceEntry> fZoomEntryList;
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final IProgressMonitor fMonitor;

        public ZoomThread(List<TraceEntry> entryList, long startTime, long endTime) {
            super("CallStackView zoom");
            this.fZoomEntryList = entryList;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fMonitor = new NullProgressMonitor();
        }

        @Override
        public void run() {
            if (this.fZoomEntryList == null) {
                return;
            }
            long resolution = Math.max(1L, (this.fZoomEndTime - this.fZoomStartTime) / (long)CallStackView.this.fDisplayWidth);
            for (TraceEntry traceEntry : this.fZoomEntryList) {
                block1: for (ITimeGraphEntry iTimeGraphEntry : traceEntry.getChildren()) {
                    ITmfStateSystem ss = ((ThreadEntry)iTimeGraphEntry).getStateSystem();
                    if (ss == null) continue;
                    ss.waitUntilBuilt();
                    if (ss.isCancelled()) continue;
                    for (ITimeGraphEntry iTimeGraphEntry2 : iTimeGraphEntry.getChildren()) {
                        if (this.fMonitor.isCanceled()) continue block1;
                        CallStackEntry entry = (CallStackEntry)iTimeGraphEntry2;
                        if (this.fZoomStartTime <= CallStackView.this.fStartTime && this.fZoomEndTime >= CallStackView.this.fEndTime) {
                            entry.setZoomedEventList(null);
                        } else {
                            List zoomedEventList = CallStackView.getEventList(entry, this.fZoomStartTime, this.fZoomEndTime, resolution, this.fMonitor);
                            if (zoomedEventList != null) {
                                entry.setZoomedEventList(zoomedEventList);
                            }
                        }
                        CallStackView.this.redraw();
                    }
                }
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }
}

