/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableKernelEvents;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlContentProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlLabelProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class EnableKernelEventComposite
extends Composite
implements IEnableKernelEvents {
    private Button fTracepointsActivateButton;
    private CheckboxTreeViewer fTracepointsViewer;
    private Button fSysCallsActivateButton;
    private Button fProbeActivateButton;
    private Text fProbeEventNameText;
    private Text fProbeText;
    private Button fFunctionActivateButton;
    private Text fFunctionEventNameText;
    private Text fFunctionText;
    private final TraceProviderGroup fProviderGroup;
    private boolean fIsTracepoints;
    private boolean fIsAllTracepoints;
    private boolean fIsSysCalls;
    private List<String> fSelectedEvents;
    private boolean fIsDynamicProbe;
    private String fProbeEventName;
    private String fProbeString;
    private boolean fIsDynamicFunctionProbe;
    private String fFunctionEventName;
    private String fFunctionString;

    public EnableKernelEventComposite(Composite parent, int style, TraceProviderGroup providerGroup) {
        super(parent, style);
        this.fProviderGroup = providerGroup;
    }

    @Override
    public boolean isTracepoints() {
        return this.fIsTracepoints;
    }

    @Override
    public boolean isAllTracePoints() {
        return this.fIsAllTracepoints;
    }

    @Override
    public boolean isSysCalls() {
        return this.fIsSysCalls;
    }

    @Override
    public boolean isAllSysCalls() {
        return this.fIsSysCalls;
    }

    @Override
    public List<String> getEventNames() {
        return new ArrayList<String>(this.fSelectedEvents);
    }

    @Override
    public boolean isDynamicProbe() {
        return this.fIsDynamicProbe;
    }

    @Override
    public String getProbeName() {
        return this.fProbeString;
    }

    @Override
    public String getProbeEventName() {
        return this.fProbeEventName;
    }

    @Override
    public boolean isDynamicFunctionProbe() {
        return this.fIsDynamicFunctionProbe;
    }

    @Override
    public String getFunctionEventName() {
        return this.fFunctionEventName;
    }

    @Override
    public String getFunction() {
        return this.fFunctionString;
    }

    public void createContent() {
        this.createTracepointsGroup();
        this.createSysCallsGroup();
        this.createDynamicProbeGroup();
        this.createDynamicFunctionPropeGroup();
        this.setKernelEnablements(KernelGroupEnum.TRACEPOINTS);
    }

    public boolean isValid() {
        this.fIsTracepoints = this.fTracepointsActivateButton.getSelection();
        this.fIsSysCalls = this.fSysCallsActivateButton.getSelection();
        this.fIsDynamicProbe = this.fProbeActivateButton.getSelection();
        this.fIsDynamicFunctionProbe = this.fFunctionActivateButton.getSelection();
        this.fIsAllTracepoints = false;
        this.fSelectedEvents = new ArrayList<String>();
        if (this.fIsTracepoints) {
            Object[] checkedElements = this.fTracepointsViewer.getCheckedElements();
            int i = 0;
            while (i < checkedElements.length) {
                ITraceControlComponent component = (ITraceControlComponent)checkedElements[i];
                if (component instanceof BaseEventComponent) {
                    this.fSelectedEvents.add(component.getName());
                }
                ++i;
            }
            int nbEvents = 0;
            List<ITraceControlComponent> comps = this.fProviderGroup.getChildren(KernelProviderComponent.class);
            for (ITraceControlComponent comp : comps) {
                nbEvents += comp.getChildren().length;
            }
            boolean bl = this.fIsAllTracepoints = nbEvents == this.fSelectedEvents.size();
        }
        if (this.fIsDynamicProbe) {
            String temp = this.fProbeEventNameText.getText();
            if (temp.isEmpty() || this.fProbeText.getText().matches("\\s*") || !temp.matches("^[\\s]{0,}$") && !temp.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidProbeNameError) + " (" + temp + ") \n"));
                return false;
            }
            this.fProbeEventName = temp;
            this.fProbeString = this.fProbeText.getText();
        }
        this.fFunctionEventName = null;
        this.fFunctionString = null;
        if (this.fIsDynamicFunctionProbe) {
            String functionTemp = this.fFunctionEventNameText.getText();
            if (functionTemp.isEmpty() || functionTemp.matches("\\s*") || !functionTemp.matches("^[\\s]{0,}$") && !functionTemp.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidProbeNameError) + " (" + functionTemp + ") \n"));
                return false;
            }
            this.fFunctionEventName = functionTemp;
            this.fFunctionString = this.fFunctionText.getText();
        }
        return true;
    }

    private void createTracepointsGroup() {
        Group tpMainGroup = new Group((Composite)this, 32);
        tpMainGroup.setText(Messages.TraceControl_EnableEventsTracepointGroupName);
        GridLayout layout = new GridLayout(2, false);
        tpMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        tpMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)tpMainGroup, 0);
        layout = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fTracepointsActivateButton = new Button(buttonComposite, 16);
        this.fTracepointsActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        data = new GridData(768);
        this.fTracepointsActivateButton.setLayoutData((Object)data);
        this.fTracepointsActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.TRACEPOINTS);
            }
        });
        Group tracepointsGroup = new Group((Composite)tpMainGroup, 32);
        layout = new GridLayout(1, true);
        tracepointsGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        tracepointsGroup.setLayoutData((Object)data);
        new FilteredTree((Composite)tracepointsGroup, 2818, new PatternFilter(), true){

            protected TreeViewer doCreateTreeViewer(Composite aparent, int style) {
                EnableKernelEventComposite.this.fTracepointsViewer = new CheckboxTreeViewer(aparent, 770);
                EnableKernelEventComposite.this.fTracepointsViewer.getTree().setToolTipText(Messages.TraceControl_EnableEventsTracepointTreeTooltip);
                EnableKernelEventComposite.this.fTracepointsViewer.setContentProvider((IContentProvider)new KernelContentProvider());
                EnableKernelEventComposite.this.fTracepointsViewer.setLabelProvider((IBaseLabelProvider)new KernelLabelProvider());
                EnableKernelEventComposite.this.fTracepointsViewer.addCheckStateListener((ICheckStateListener)new KernelCheckListener());
                EnableKernelEventComposite.this.fTracepointsViewer.setInput((Object)EnableKernelEventComposite.this.fProviderGroup);
                EnableKernelEventComposite.this.fTracepointsViewer.getTree().setLayoutData((Object)new GridData(1808));
                return EnableKernelEventComposite.this.fTracepointsViewer;
            }
        };
    }

    private void createSysCallsGroup() {
        Group sysCallsMainGroup = new Group((Composite)this, 32);
        sysCallsMainGroup.setText(Messages.TraceControl_EnableEventsSyscallName);
        sysCallsMainGroup.setToolTipText(Messages.TraceControl_EnableEventsSyscallTooltip);
        GridLayout layout = new GridLayout(2, false);
        sysCallsMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        sysCallsMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)sysCallsMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fSysCallsActivateButton = new Button(buttonComposite, 16);
        this.fSysCallsActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fSysCallsActivateButton.setToolTipText(Messages.TraceControl_EnableEventsSyscallTooltip);
        this.fSysCallsActivateButton.setSelection(false);
        data = new GridData(768);
        this.fSysCallsActivateButton.setLayoutData((Object)data);
        this.fSysCallsActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.SYSCALLS);
            }
        });
    }

    private void createDynamicProbeGroup() {
        Group probeMainGroup = new Group((Composite)this, 32);
        probeMainGroup.setText(Messages.TraceControl_EnableEventsProbeGroupName);
        GridLayout layout = new GridLayout(2, false);
        probeMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        probeMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)probeMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fProbeActivateButton = new Button(buttonComposite, 16);
        this.fProbeActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fProbeActivateButton.setSelection(false);
        data = new GridData(768);
        this.fProbeActivateButton.setLayoutData((Object)data);
        this.fProbeActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.PROBE);
            }
        });
        Group probeGroup = new Group((Composite)probeMainGroup, 32);
        layout = new GridLayout(4, true);
        probeGroup.setLayout((Layout)layout);
        probeGroup.setLayoutData((Object)new GridData(768));
        Label probeNameLabel = new Label((Composite)probeGroup, 16384);
        probeNameLabel.setText(Messages.TraceControl_EnableEventsEventNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        probeNameLabel.setLayoutData((Object)data);
        this.fProbeEventNameText = new Text((Composite)probeGroup, 16384);
        this.fProbeEventNameText.setToolTipText(Messages.TraceControl_EnableEventsProbeEventNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fProbeEventNameText.setLayoutData((Object)data);
        Label probeLabel = new Label((Composite)probeGroup, 16384);
        probeLabel.setText(Messages.TraceControl_EnableEventsProbeNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        probeLabel.setLayoutData((Object)data);
        this.fProbeText = new Text((Composite)probeGroup, 16384);
        this.fProbeText.setToolTipText(Messages.TraceControl_EnableEventsProbeNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fProbeText.setLayoutData((Object)data);
    }

    private void createDynamicFunctionPropeGroup() {
        Group functionMainGroup = new Group((Composite)this, 32);
        functionMainGroup.setText(Messages.TraceControl_EnableEventsFucntionGroupName);
        GridLayout layout = new GridLayout(2, false);
        functionMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        functionMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)functionMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fFunctionActivateButton = new Button(buttonComposite, 16);
        this.fFunctionActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fFunctionActivateButton.setSelection(false);
        data = new GridData(768);
        this.fFunctionActivateButton.setLayoutData((Object)data);
        this.fFunctionActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.FUNCTION);
            }
        });
        Group functionGroup = new Group((Composite)functionMainGroup, 32);
        layout = new GridLayout(4, true);
        functionGroup.setLayout((Layout)layout);
        functionGroup.setLayoutData((Object)new GridData(768));
        Label functionNameLabel = new Label((Composite)functionGroup, 16384);
        functionNameLabel.setText(Messages.TraceControl_EnableEventsEventNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        functionNameLabel.setLayoutData((Object)data);
        this.fFunctionEventNameText = new Text((Composite)functionGroup, 16384);
        this.fFunctionEventNameText.setToolTipText(Messages.TraceControl_EnableEventsFunctionEventNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fFunctionEventNameText.setLayoutData((Object)data);
        Label functionLabel = new Label((Composite)functionGroup, 16384);
        functionLabel.setText(Messages.TraceControl_EnableEventsFunctionNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        functionLabel.setLayoutData((Object)data);
        this.fFunctionText = new Text((Composite)functionGroup, 16384);
        this.fFunctionText.setToolTipText(Messages.TraceControl_EnableEventsProbeNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fFunctionText.setLayoutData((Object)data);
    }

    private void setKernelEnablements(KernelGroupEnum group) {
        this.fTracepointsActivateButton.setSelection(group == KernelGroupEnum.TRACEPOINTS);
        this.fTracepointsViewer.getTree().setEnabled(group == KernelGroupEnum.TRACEPOINTS);
        this.fSysCallsActivateButton.setSelection(group == KernelGroupEnum.SYSCALLS);
        this.fProbeActivateButton.setSelection(group == KernelGroupEnum.PROBE);
        this.fProbeEventNameText.setEnabled(group == KernelGroupEnum.PROBE);
        this.fProbeText.setEnabled(group == KernelGroupEnum.PROBE);
        this.fFunctionActivateButton.setSelection(group == KernelGroupEnum.FUNCTION);
        this.fFunctionEventNameText.setEnabled(group == KernelGroupEnum.FUNCTION);
        this.fFunctionText.setEnabled(group == KernelGroupEnum.FUNCTION);
    }

    public final class KernelCheckListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                if (event.getElement() instanceof KernelProviderComponent) {
                    EnableKernelEventComposite.this.fTracepointsViewer.setSubtreeChecked(event.getElement(), true);
                }
            } else if (event.getElement() instanceof KernelProviderComponent) {
                EnableKernelEventComposite.this.fTracepointsViewer.setSubtreeChecked(event.getElement(), false);
            } else {
                ITraceControlComponent component = (ITraceControlComponent)event.getElement();
                EnableKernelEventComposite.this.fTracepointsViewer.setChecked((Object)component.getParent(), false);
            }
        }
    }

    public static final class KernelContentProvider
    extends TraceControlContentProvider {
        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TraceProviderGroup) {
                List<ITraceControlComponent> children = ((ITraceControlComponent)parentElement).getChildren(KernelProviderComponent.class);
                return children.toArray(new ITraceControlComponent[children.size()]);
            }
            if (parentElement instanceof ITraceControlComponent) {
                return ((ITraceControlComponent)parentElement).getChildren();
            }
            return new Object[0];
        }
    }

    private static enum KernelGroupEnum {
        TRACEPOINTS,
        SYSCALLS,
        PROBE,
        FUNCTION;

    }

    public static final class KernelLabelProvider
    extends TraceControlLabelProvider {
        @Override
        public Image getImage(Object element) {
            return null;
        }

        @Override
        public String getText(Object element) {
            if (element != null && element instanceof KernelProviderComponent) {
                return Messages.TraceControl_EnableEventsTracepointTreeAllLabel;
            }
            return super.getText(element);
        }
    }
}

