/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IImportConfirmationDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IImportDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ImportFileInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.PlatformUI;

public class ImportDialog
extends Dialog
implements IImportDialog {
    public static final String IMPORT_ICON_FILE = "icons/elcl16/import_trace.gif";
    public static final String UST_PARENT_DIRECTORY = "ust";
    public static final String METADATA_FILE_NAME = "metadata";
    private Composite fDialogComposite = null;
    private CheckboxTreeViewer fFolderViewer;
    private CCombo fCombo;
    private Button fOverwriteButton;
    private List<IProject> fProjects;
    private TraceSessionComponent fSession = null;
    private String fDefaultProjectName = null;
    private final List<ImportFileInfo> fTraces = new ArrayList<ImportFileInfo>();
    private int fProjectIndex;
    private boolean fIsError = false;
    private Object[] fFolderChildren = null;

    public ImportDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public List<ImportFileInfo> getTracePathes() {
        ArrayList<ImportFileInfo> retList = new ArrayList<ImportFileInfo>();
        retList.addAll(this.fTraces);
        return retList;
    }

    @Override
    public IProject getProject() {
        return this.fProjects.get(this.fProjectIndex);
    }

    @Override
    public void setSession(TraceSessionComponent session) {
        this.fSession = session;
    }

    @Override
    public void setDefaultProject(String defaultProject) {
        this.fDefaultProjectName = defaultProject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_ImportDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(IMPORT_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        try {
            this.createRemoteComposite();
        }
        catch (CoreException e) {
            this.createErrorComposite(parent, e.fillInStackTrace());
            return this.fDialogComposite;
        }
        return this.fDialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button selectAllButton = this.createButton(parent, 18, Messages.TraceControl_ImportDialog_SelectAll, true);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog.this.setFolderChildrenChecked(true);
            }
        });
        Button deselectAllButton = this.createButton(parent, 19, Messages.TraceControl_ImportDialog_DeselectAll, true);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog.this.setFolderChildrenChecked(false);
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.updateOKButtonEnablement();
    }

    protected void okPressed() {
        if (!this.fIsError) {
            this.fTraces.clear();
            this.fProjectIndex = this.fCombo.getSelectionIndex();
            if (this.fProjectIndex < 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_ImportDialogTitle, (String)Messages.TraceControl_ImportDialogNoProjectSelectedError);
                return;
            }
            IProject project = this.fProjects.get(this.fProjectIndex);
            IFolder traceFolder = project.getFolder("Traces");
            if (!traceFolder.exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_ImportDialogTitle, (String)(String.valueOf(Messages.TraceControl_ImportDialogInvalidTracingProject) + " (" + "Traces" + ")"));
                return;
            }
            boolean overwriteAll = this.fOverwriteButton.getSelection();
            Object[] checked = this.fFolderViewer.getCheckedElements();
            int i = 0;
            while (i < checked.length) {
                IFileStore file = (IFileStore)checked[i];
                if (!file.fetchInfo().isDirectory() && file.getName().equals(METADATA_FILE_NAME)) {
                    IFileStore trace = file.getParent();
                    IFileStore parent = trace.getParent();
                    String path = this.fSession.isSnapshotSession() ? this.fSession.getSnapshotInfo().getSnapshotPath() : this.fSession.getSessionPath();
                    path = ImportDialog.getUnifiedPath(path);
                    IPath sessionParentPath = new Path(path).removeLastSegments(1);
                    Path traceParentPath = new Path(parent.toURI().getPath());
                    IPath relativeTracePath = traceParentPath.makeRelativeTo(sessionParentPath);
                    IFolder destinationFolder = traceFolder.getFolder((IPath)new Path(relativeTracePath.toOSString()));
                    ImportFileInfo info = new ImportFileInfo(trace, trace.getName(), destinationFolder, overwriteAll);
                    IFolder folder = destinationFolder.getFolder(trace.getName());
                    if (folder.exists() && !overwriteAll) {
                        IImportConfirmationDialog conf = TraceControlDialogFactory.getInstance().getImportConfirmationDialog();
                        conf.setTraceName(trace.getName());
                        if (conf.open() == 0) {
                            info.setOverwrite(conf.isOverwrite());
                            if (!conf.isOverwrite()) {
                                info.setLocalTraceName(conf.getNewTraceName());
                            }
                            this.fTraces.add(info);
                        }
                    } else {
                        this.fTraces.add(info);
                    }
                }
                ++i;
            }
            if (this.fTraces.isEmpty()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_ImportDialogTitle, (String)Messages.TraceControl_ImportDialogNoTraceSelectedError);
                return;
            }
        }
        super.okPressed();
    }

    private void createErrorComposite(Composite parent, Throwable e) {
        this.fIsError = true;
        this.fDialogComposite.dispose();
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Text errorText = new Text(this.fDialogComposite, 2);
        StringBuffer error = new StringBuffer();
        error.append(Messages.TraceControl_ImportDialogCreationError);
        error.append(System.getProperty("line.separator"));
        error.append(System.getProperty("line.separator"));
        error.append(e.toString());
        errorText.setText(error.toString());
        errorText.setLayoutData((Object)new GridData(1808));
    }

    private void createRemoteComposite() throws CoreException {
        Group contextGroup = new Group(this.fDialogComposite, 32);
        contextGroup.setText(Messages.TraceControl_ImportDialogTracesGroupName);
        GridLayout layout = new GridLayout(1, true);
        contextGroup.setLayout((Layout)layout);
        contextGroup.setLayoutData((Object)new GridData(1808));
        RemoteSystemProxy proxy = this.fSession.getTargetNode().getRemoteSystemProxy();
        IRemoteFileService fsss = (IRemoteFileService)proxy.getRemoteConnection().getService(IRemoteFileService.class);
        if (fsss == null) {
            return;
        }
        String path = this.fSession.isSnapshotSession() ? this.fSession.getSnapshotInfo().getSnapshotPath() : this.fSession.getSessionPath();
        IFileStore remoteFolder = fsss.getResource(path);
        this.fFolderViewer = new CheckboxTreeViewer((Composite)contextGroup, 2816);
        GridData data = new GridData(1808);
        Tree tree = this.fFolderViewer.getTree();
        tree.setLayoutData((Object)data);
        tree.setFont(this.fDialogComposite.getFont());
        tree.setToolTipText(Messages.TraceControl_ImportDialogTracesTooltip);
        this.fFolderViewer.setContentProvider((IContentProvider)new FolderContentProvider());
        this.fFolderViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IFileStore)element).getName();
            }

            public Image getImage(Object element) {
                if (((IFileStore)element).fetchInfo().isDirectory()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
        });
        this.fFolderViewer.addCheckStateListener((ICheckStateListener)new FolderCheckStateListener());
        this.fFolderViewer.setInput((Object)remoteFolder);
        this.fFolderChildren = remoteFolder.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        this.setFolderChildrenChecked(true);
        Group projectGroup = new Group(this.fDialogComposite, 32);
        projectGroup.setText(Messages.TraceControl_ImportDialogProjectsGroupName);
        layout = new GridLayout(1, true);
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.fProjects = new ArrayList<IProject>();
        ArrayList<String> projectNames = new ArrayList<String>();
        for (IProject project : TraceUtils.getOpenedTmfProjects()) {
            this.fProjects.add(project);
            projectNames.add(project.getName());
        }
        this.fCombo = new CCombo((Composite)projectGroup, 8);
        this.fCombo.setToolTipText(Messages.TraceControl_ImportDialogProjectsTooltip);
        this.fCombo.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.fCombo.setItems(projectNames.toArray(new String[projectNames.size()]));
        if (this.fDefaultProjectName != null) {
            int select = projectNames.indexOf(this.fDefaultProjectName);
            this.fCombo.select(select);
        }
        Group overrideGroup = new Group(this.fDialogComposite, 32);
        layout = new GridLayout(1, true);
        overrideGroup.setLayout((Layout)layout);
        overrideGroup.setLayoutData((Object)new GridData(768));
        this.fOverwriteButton = new Button((Composite)overrideGroup, 32);
        this.fOverwriteButton.setText(Messages.TraceControl_ImportDialogOverwriteButtonText);
        this.getShell().setMinimumSize(new Point(500, 400));
    }

    private void setFolderChildrenChecked(boolean isChecked) {
        if (this.fFolderChildren != null) {
            Object[] objectArray = this.fFolderChildren;
            int n = this.fFolderChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.fFolderViewer.setSubtreeChecked(child, isChecked);
                ++n2;
            }
        }
        this.updateOKButtonEnablement();
    }

    private void updateOKButtonEnablement() {
        Object[] checked = this.fFolderViewer.getCheckedElements();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(checked.length > 0);
        }
    }

    private static String getUnifiedPath(String path) {
        return new Path(path).removeTrailingSeparator().toString();
    }

    private final class FolderCheckStateListener
    implements ICheckStateListener {
        private FolderCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object elem = event.getElement();
            if (elem instanceof IFileStore) {
                IFileStore element = (IFileStore)elem;
                IFileInfo info = element.fetchInfo();
                if (!info.isDirectory()) {
                    boolean p = ImportDialog.this.fFolderViewer.getChecked((Object)element.getParent());
                    ImportDialog.this.fFolderViewer.setChecked((Object)element, p);
                } else {
                    ImportDialog.this.fFolderViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                    if (!event.getChecked()) {
                        ImportDialog.this.fFolderViewer.setChecked((Object)element.getParent(), false);
                    }
                }
                ImportDialog.this.updateOKButtonEnablement();
            }
        }
    }

    public static class FolderContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object o) {
            try {
                IFileStore store = (IFileStore)o;
                if (store.fetchInfo().isDirectory()) {
                    return store.childStores(0, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return ((IFileStore)element).getParent();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object element) {
            return ((IFileStore)element).fetchInfo().isDirectory();
        }
    }
}

