/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConnectionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConnectionManager;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConsumer;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IImportDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ImportFileInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ctf.core.CtfConstants;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportHandler
extends BaseControlViewHandler {
    private static final int BUFFER_IN_KB = 16;
    private static final int BYTES_PER_KB = 1024;
    public static final String DEFAULT_REMOTE_PROJECT_NAME = "Remote";
    private static final String NOTIFY_IMPORT_STREAMED_PREF_KEY = "NOTIFY_IMPORT_STREAMED";
    protected CommandParameter fParam;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            CommandParameter param = this.fParam.clone();
            IProject project = TmfProjectRegistry.createProject((String)DEFAULT_REMOTE_PROJECT_NAME, null, null);
            if (param.getSession().isLiveTrace()) {
                ImportHandler.importLiveTrace(new LttngRelaydConnectionInfo(param.getSession().getLiveUrl(), param.getSession().getLivePort(), param.getSession().getName()), project);
                return null;
            }
            if (param.getSession().isStreamedTrace()) {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                String notify = store.getString(NOTIFY_IMPORT_STREAMED_PREF_KEY);
                if (!"always".equals(notify)) {
                    MessageDialogWithToggle.openInformation((Shell)window.getShell(), null, (String)org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportDialogStreamedTraceNotification, (String)org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportDialogStreamedTraceNotificationToggle, (boolean)false, (IPreferenceStore)store, (String)NOTIFY_IMPORT_STREAMED_PREF_KEY);
                }
                TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
                TmfTraceFolder traceFolder = projectElement.getTracesFolder();
                ImportTraceWizard wizard = new ImportTraceWizard();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)traceFolder));
                WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                dialog.open();
                return null;
            }
            final IImportDialog dialog = TraceControlDialogFactory.getInstance().getImportDialog();
            dialog.setSession(param.getSession());
            dialog.setDefaultProject(DEFAULT_REMOTE_PROJECT_NAME);
            if (dialog.open() != 0) {
                return null;
            }
            Job job = new Job(org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportJob){

                protected IStatus run(IProgressMonitor monitor) {
                    MultiStatus status = new MultiStatus("org.eclipse.tracecompass.lttng2.control.ui", 0, org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportFailure, null);
                    List<ImportFileInfo> traces = dialog.getTracePathes();
                    IProject selectedProject = dialog.getProject();
                    Iterator<ImportFileInfo> iterator = traces.iterator();
                    while (iterator.hasNext()) {
                        try {
                            if (monitor.isCanceled()) {
                                status.add(Status.CANCEL_STATUS);
                                break;
                            }
                            ImportFileInfo remoteFile = iterator.next();
                            ImportHandler.downloadTrace(remoteFile, selectedProject, monitor);
                            IFolder traceFolder = remoteFile.getDestinationFolder();
                            IResource file = traceFolder.findMember(remoteFile.getLocalTraceName());
                            if (file == null) continue;
                            TraceTypeHelper helper = null;
                            try {
                                helper = TmfTraceTypeUIUtils.selectTraceType((String)file.getLocation().toOSString(), null, null);
                            }
                            catch (TmfTraceImportException tmfTraceImportException) {
                                // empty catch block
                            }
                            if (helper != null) {
                                status.add(TmfTraceTypeUIUtils.setTraceType((IResource)file, (TraceTypeHelper)helper));
                            }
                            URI uri = remoteFile.getImportFile().toURI();
                            String sourceLocation = URIUtil.toUnencodedString((URI)uri);
                            file.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
                        }
                        catch (ExecutionException e) {
                            status.add((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportFailure, (Throwable)e));
                        }
                        catch (CoreException e) {
                            status.add((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportFailure, (Throwable)e));
                        }
                    }
                    return status;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        TraceSessionComponent session = null;
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent tmpSession;
                if (!(element instanceof TraceSessionComponent) || !(tmpSession = (TraceSessionComponent)element).isSnapshotSession() && !tmpSession.isLiveTrace() && tmpSession.getSessionState() != TraceSessionState.INACTIVE || tmpSession.isDestroyed()) continue;
                session = tmpSession;
            }
        }
        boolean isEnabled = session != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new CommandParameter(session);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    private static void downloadTrace(ImportFileInfo trace, IProject project, IProgressMonitor monitor) throws ExecutionException {
        try {
            IFileStore importRoot = trace.getImportFile();
            IFolder traceFolder = project.getFolder("Traces");
            if (!traceFolder.exists()) {
                throw new ExecutionException(String.valueOf(org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportDialogInvalidTracingProject) + " (" + "Traces" + ")");
            }
            IFolder destinationFolder = trace.getDestinationFolder();
            TraceUtils.createFolder((IFolder)destinationFolder, (IProgressMonitor)monitor);
            String traceName = trace.getLocalTraceName();
            IFolder folder = destinationFolder.getFolder(traceName);
            if (folder.exists()) {
                if (!trace.isOverwrite()) {
                    throw new ExecutionException(String.valueOf(org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportDialogTraceAlreadyExistError) + ": " + traceName);
                }
            } else {
                folder.create(true, true, null);
            }
            IFileStore[] sources = importRoot.childStores(0, (IProgressMonitor)new NullProgressMonitor());
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sources.length);
            subMonitor.beginTask(org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_DownloadTask, sources.length);
            IFileStore[] iFileStoreArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore source = iFileStoreArray[n2];
                if (subMonitor.isCanceled()) {
                    monitor.setCanceled(true);
                    return;
                }
                SubMonitor childMonitor = subMonitor.newChild(1);
                IFileInfo info = source.fetchInfo();
                if (!info.isDirectory()) {
                    IPath destination = folder.getLocation().addTrailingSeparator().append(source.getName());
                    subMonitor.setTaskName(String.valueOf(org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_DownloadTask) + ' ' + traceName + '/' + source.getName());
                    Throwable throwable = null;
                    Object var18_21 = null;
                    try (InputStream in = source.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());){
                        ImportHandler.copy(in, destination, childMonitor, info.getLength());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e.toString(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.toString(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copy(InputStream in, IPath destination, SubMonitor monitor, long length) throws IOException {
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            FileOutputStream out = new FileOutputStream(destination.toFile());
            try {
                monitor.setWorkRemaining((int)(length / 1024L));
                byte[] buf = new byte[16384];
                int counter = 0;
                while (true) {
                    int n;
                    if ((n = in.read(buf)) <= 0) {
                        return;
                    }
                    ((OutputStream)out).write(buf, 0, n);
                    counter = counter % 1024 + n;
                    monitor.worked(counter / 1024);
                }
            }
            finally {
                if (out == null) return;
                ((OutputStream)out).close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static void importLiveTrace(final LttngRelaydConnectionInfo connectionInfo, final IProject project) {
        Job job = new Job(org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LttngRelaydConsumer lttngRelaydConsumer = LttngRelaydConnectionManager.getInstance().getConsumer(connectionInfo);
                    try {
                        lttngRelaydConsumer.connect();
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.LttngRelaydConnectionManager_ConnectionError, (Throwable)e);
                    }
                    ImportHandler.initializeTraceResource(connectionInfo, lttngRelaydConsumer.getTracePath(), project);
                    return Status.OK_STATUS;
                }
                catch (CoreException | TmfTraceImportException e) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.ImportHandler_LiveTraceInitError, e);
                }
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private static void initializeTraceResource(LttngRelaydConnectionInfo connectionInfo, String tracePath, IProject project) throws CoreException, TmfTraceImportException {
        IFolder folder = project.getFolder("Traces");
        IFolder traceFolder = folder.getFolder(connectionInfo.getSessionName());
        Path location = new Path(tracePath);
        IStatus result = ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)folder, (IPath)location);
        if (!result.isOK()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", result.getMessage()));
        }
        traceFolder.createLink((IPath)location, 256, (IProgressMonitor)new NullProgressMonitor());
        TraceTypeHelper selectedTraceType = TmfTraceTypeUIUtils.selectTraceType((String)location.toOSString(), null, null);
        TmfTraceTypeUIUtils.setTraceType((IResource)traceFolder, (TraceTypeHelper)selectedTraceType);
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        TmfTraceFolder tracesFolder = projectElement.getTracesFolder();
        List traces = tracesFolder.getTraces();
        TmfTraceElement found = null;
        for (TmfTraceElement candidate : traces) {
            if (!candidate.getName().equals(connectionInfo.getSessionName())) continue;
            found = candidate;
        }
        if (found == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.ImportHandler_LiveTraceElementError));
        }
        traceFolder.setPersistentProperty(CtfConstants.LIVE_HOST, connectionInfo.getHost());
        traceFolder.setPersistentProperty(CtfConstants.LIVE_PORT, Integer.toString(connectionInfo.getPort()));
        traceFolder.setPersistentProperty(CtfConstants.LIVE_SESSION_NAME, connectionInfo.getSessionName());
        final TmfTraceElement finalTrace = found;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)finalTrace);
            }
        });
    }
}

