/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.event;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStateStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsEventTypesModule;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsTotalsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class CtfTmfLostEventStatisticsTest {
    @Rule
    public TestRule globalTimeout = new Timeout(30L, TimeUnit.SECONDS);
    private static final CtfTmfTestTrace lostEventsTrace = CtfTmfTestTrace.HELLO_LOST;
    private ITmfTrace fTrace;
    private ITmfStatistics fStats;
    private TmfStatisticsTotalsModule fTotalsMod;
    private TmfStatisticsEventTypesModule fEventTypesMod;
    private static final long rangeStart = 1376592664900000000L;
    private static final long rangeEnd = 1376592665000000000L;

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((boolean)lostEventsTrace.exists());
    }

    @Before
    public void setUp() {
        CtfTmfTrace trace = lostEventsTrace.getTrace();
        this.fTrace = trace;
        this.fTotalsMod = new TmfStatisticsTotalsModule();
        this.fEventTypesMod = new TmfStatisticsEventTypesModule();
        try {
            this.fTotalsMod.setTrace((ITmfTrace)trace);
            this.fEventTypesMod.setTrace((ITmfTrace)trace);
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        this.fTotalsMod.schedule();
        this.fEventTypesMod.schedule();
        Assert.assertTrue((boolean)this.fTotalsMod.waitForCompletion());
        Assert.assertTrue((boolean)this.fEventTypesMod.waitForCompletion());
        ITmfStateSystem totalsSS = this.fTotalsMod.getStateSystem();
        ITmfStateSystem eventTypesSS = this.fEventTypesMod.getStateSystem();
        Assert.assertNotNull((Object)totalsSS);
        Assert.assertNotNull((Object)eventTypesSS);
        this.fStats = new TmfStateStatistics(totalsSS, eventTypesSS);
    }

    @After
    public void tearDown() {
        this.fStats.dispose();
        this.fTotalsMod.dispose();
        this.fEventTypesMod.dispose();
        this.fTrace.dispose();
    }

    @Test
    public void testLostEventsTotals() {
        long realEvents = this.fStats.getEventsTotal();
        Assert.assertEquals((long)32300L, (long)realEvents);
    }

    @Test
    public void testLostEventsTotalInRange() {
        long realEventsInRange = this.fStats.getEventsInRange(1376592664900000000L, 1376592665000000000L);
        Assert.assertEquals((long)11209L, (long)realEventsInRange);
    }

    @Test
    public void testLostEventsTypes() {
        Map events = this.fStats.getEventTypesTotal();
        Long lostEvents = (Long)events.get("Lost event");
        Assert.assertEquals((Object)967700L, (Object)lostEvents);
    }

    @Test
    public void testLostEventsTypesInRange() {
        Map eventsInRange = this.fStats.getEventTypesInRange(1376592664900000000L, 1376592665000000000L);
        long lostEventsInRange = (Long)eventsInRange.get("Lost event");
        Assert.assertEquals((long)365752L, (long)lostEventsInRange);
    }
}

