/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.request;

import java.io.PrintWriter;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class TmfSchedulerBenchmark {
    private static final int NUM_LOOPS = 10;
    private static final int NANOSECONDS_IN_MILLISECONDS = 1000000;
    private static final int NANOSECONDS_IN_SECONDS = 1000000000;
    private static CtfTmfTrace trace = CtfTmfTestTrace.KERNEL.getTrace();
    private static ForegroundRequest lastForegroundRequest = null;
    private static BackgroundRequest lastBackgroundRequest = null;
    private static PrintWriter pw = new PrintWriter(System.out, true);

    public static void main(String[] args) {
        trace.indexTrace(true);
        pw.println("---------- Benchmark started ----------");
        TmfSchedulerBenchmark.latencyBenchmark();
        TmfSchedulerBenchmark.averageWaitingTime();
        TmfSchedulerBenchmark.completedTime();
        TmfSchedulerBenchmark.benchmarkResults();
        trace.dispose();
    }

    private static void latencyBenchmark() {
        long averageLatency = 0L;
        pw.println("----- Latency -----");
        int i = 0;
        while (i < 10) {
            try {
                ForegroundRequest foreground1 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                trace.sendRequest((ITmfEventRequest)foreground1);
                foreground1.waitForCompletion();
                averageLatency += foreground1.getLatency();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        pw.println(String.valueOf(averageLatency / 10L / 1000000L) + " ms");
    }

    private static void averageWaitingTime() {
        long averageWaitingBackground = 0L;
        long averageWaitingForeground1 = 0L;
        long averageWaitingForeground2 = 0L;
        pw.println("----- Average waiting time with 3 requests -----");
        int i = 0;
        while (i < 10) {
            ForegroundRequest foreground1 = new ForegroundRequest(TmfTimeRange.ETERNITY);
            ForegroundRequest foreground2 = new ForegroundRequest(TmfTimeRange.ETERNITY);
            BackgroundRequest background1 = new BackgroundRequest(TmfTimeRange.ETERNITY);
            trace.sendRequest((ITmfEventRequest)background1);
            trace.sendRequest((ITmfEventRequest)foreground1);
            trace.sendRequest((ITmfEventRequest)foreground2);
            try {
                foreground1.waitForCompletion();
                foreground2.waitForCompletion();
                background1.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            averageWaitingBackground += background1.getAverageWaitingTime();
            averageWaitingForeground1 += foreground1.getAverageWaitingTime();
            averageWaitingForeground2 += foreground2.getAverageWaitingTime();
            ++i;
        }
        pw.print("-- Background : ");
        pw.println(String.valueOf(averageWaitingBackground / 10L / 1000000L) + " ms");
        pw.print("-- First foreground : ");
        pw.println(String.valueOf(averageWaitingForeground1 / 10L / 1000000L) + " ms");
        pw.print("-- Second foreground : ");
        pw.println(String.valueOf(averageWaitingForeground2 / 10L / 1000000L) + " ms");
    }

    private static void completedTime() {
        long averageCompletedTime1 = 0L;
        long averageCompletedTime2 = 0L;
        long averageCompletedTime3 = 0L;
        long averageCompletedTime4 = 0L;
        long averageCompletedTime5 = 0L;
        long averageCompletedTime6 = 0L;
        pw.println("----- Time to complete request -----");
        int i = 0;
        while (i < 10) {
            try {
                ForegroundRequest foreground1 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                trace.sendRequest((ITmfEventRequest)foreground1);
                foreground1.waitForCompletion();
                averageCompletedTime1 += foreground1.getCompletedTime();
                ForegroundRequest foreground2 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                ForegroundRequest foreground3 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                trace.sendRequest((ITmfEventRequest)foreground2);
                trace.sendRequest((ITmfEventRequest)foreground3);
                foreground2.waitForCompletion();
                foreground3.waitForCompletion();
                averageCompletedTime2 += foreground2.getCompletedTime() + foreground3.getCompletedTime();
                ForegroundRequest foreground4 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                BackgroundRequest background1 = new BackgroundRequest(TmfTimeRange.ETERNITY);
                trace.sendRequest((ITmfEventRequest)foreground4);
                trace.sendRequest((ITmfEventRequest)background1);
                foreground4.waitForCompletion();
                background1.waitForCompletion();
                averageCompletedTime3 += foreground4.getCompletedTime() + background1.getCompletedTime();
                ForegroundRequest foreground5 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                ForegroundRequest foreground6 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                BackgroundRequest background2 = new BackgroundRequest(TmfTimeRange.ETERNITY);
                trace.sendRequest((ITmfEventRequest)foreground5);
                trace.sendRequest((ITmfEventRequest)foreground6);
                trace.sendRequest((ITmfEventRequest)background2);
                foreground5.waitForCompletion();
                foreground6.waitForCompletion();
                background2.waitForCompletion();
                averageCompletedTime4 += foreground5.getCompletedTime() + foreground6.getCompletedTime() + background2.getCompletedTime();
                ForegroundRequest foreground7 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                ForegroundRequest foreground8 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                ForegroundRequest foreground9 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                BackgroundRequest background3 = new BackgroundRequest(TmfTimeRange.ETERNITY);
                trace.sendRequest((ITmfEventRequest)foreground7);
                trace.sendRequest((ITmfEventRequest)foreground8);
                trace.sendRequest((ITmfEventRequest)foreground9);
                trace.sendRequest((ITmfEventRequest)background3);
                foreground7.waitForCompletion();
                foreground8.waitForCompletion();
                foreground9.waitForCompletion();
                background3.waitForCompletion();
                averageCompletedTime5 += foreground7.getCompletedTime() + foreground8.getCompletedTime() + foreground9.getCompletedTime() + background3.getCompletedTime();
                ForegroundRequest foreground10 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                ForegroundRequest foreground11 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                ForegroundRequest foreground12 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                ForegroundRequest foreground13 = new ForegroundRequest(TmfTimeRange.ETERNITY);
                BackgroundRequest background4 = new BackgroundRequest(TmfTimeRange.ETERNITY);
                trace.sendRequest((ITmfEventRequest)foreground10);
                trace.sendRequest((ITmfEventRequest)foreground11);
                trace.sendRequest((ITmfEventRequest)foreground12);
                trace.sendRequest((ITmfEventRequest)foreground13);
                trace.sendRequest((ITmfEventRequest)background4);
                foreground10.waitForCompletion();
                foreground11.waitForCompletion();
                foreground12.waitForCompletion();
                foreground13.waitForCompletion();
                background4.waitForCompletion();
                averageCompletedTime6 += foreground10.getCompletedTime() + foreground11.getCompletedTime() + foreground12.getCompletedTime() + foreground13.getCompletedTime() + background4.getCompletedTime();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        pw.print("-- Time to complete one request : ");
        pw.println(String.valueOf(averageCompletedTime1 / 10L / 1000000000L) + " s");
        pw.print("-- Time to complete 2 requests (2 foreground) : ");
        pw.println(String.valueOf(averageCompletedTime2 / 10L / 1000000000L) + " s");
        pw.print("-- Time to complete 2 requests (1 foreground, 1 background) : ");
        pw.println(String.valueOf(averageCompletedTime3 / 10L / 1000000000L) + " s");
        pw.print("-- Time to complete 3 requests (2 foreground, 1 background) : ");
        pw.println(String.valueOf(averageCompletedTime4 / 10L / 1000000000L) + " s");
        pw.print("-- Time to complete 4 requests (3 foreground, 1 background) : ");
        pw.println(String.valueOf(averageCompletedTime5 / 10L / 1000000000L) + " s");
        pw.print("-- Time to complete 5 requests (4 foreground, 1 background) : ");
        pw.println(String.valueOf(averageCompletedTime6 / 10L / 1000000000L) + " s");
    }

    public static void benchmarkResults() {
        pw.println("---------- Benchmark completed ----------");
    }

    private static class BackgroundRequest
    extends TmfEventRequest {
        private long startTime = System.nanoTime();
        private long endTimeLatency = -1L;
        private long completedTime = 0L;
        private long waitingTimeStart = 0L;
        private long waitingTimeEnd = 0L;
        private long waitingTime = 0L;
        private int waitingCounter = 0;
        private boolean isWaiting = false;

        BackgroundRequest(TmfTimeRange timeRange) {
            super(trace.getEventType(), timeRange, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        }

        public void handleData(ITmfEvent event) {
            if (this.endTimeLatency == -1L) {
                this.endTimeLatency = System.nanoTime();
            }
            super.handleData(event);
            if (lastForegroundRequest == null && lastBackgroundRequest == null) {
                lastBackgroundRequest = this;
            }
            if (this.isWaiting) {
                this.waitingTimeEnd = System.nanoTime();
                this.waitingTime += this.waitingTimeEnd - this.waitingTimeStart;
                ++this.waitingCounter;
                this.isWaiting = false;
            }
            if (lastForegroundRequest != null) {
                lastForegroundRequest.waitingTimeStart = System.nanoTime();
                lastForegroundRequest.isWaiting = true;
                lastForegroundRequest = null;
                lastBackgroundRequest = this;
            }
            if (lastBackgroundRequest != this) {
                lastBackgroundRequest.waitingTimeStart = System.nanoTime();
                lastBackgroundRequest.isWaiting = true;
                lastBackgroundRequest = this;
            }
        }

        public void handleCompleted() {
            this.completedTime = System.nanoTime();
            super.handleCompleted();
        }

        public long getCompletedTime() {
            return this.completedTime - this.startTime;
        }

        public long getAverageWaitingTime() {
            if (this.waitingCounter == 0) {
                return 0L;
            }
            return this.waitingTime / (long)this.waitingCounter;
        }
    }

    private static class ForegroundRequest
    extends TmfEventRequest {
        private long startTime = System.nanoTime();
        private long endTimeLatency = -1L;
        private long completedTime = 0L;
        private long waitingTimeStart = 0L;
        private long waitingTimeEnd = 0L;
        private long waitingTime = 0L;
        private int waitingCounter = 0;
        private boolean isWaiting = false;

        ForegroundRequest(TmfTimeRange timeRange) {
            super(trace.getEventType(), timeRange, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        }

        public void handleData(ITmfEvent event) {
            if (this.endTimeLatency == -1L) {
                this.endTimeLatency = System.nanoTime();
            }
            super.handleData(event);
            if (lastBackgroundRequest == null && lastForegroundRequest == null) {
                lastForegroundRequest = this;
            }
            if (this.isWaiting) {
                this.waitingTimeEnd = System.nanoTime();
                this.waitingTime += this.waitingTimeEnd - this.waitingTimeStart;
                ++this.waitingCounter;
                this.isWaiting = false;
            }
            if (lastBackgroundRequest != null) {
                lastBackgroundRequest.waitingTimeStart = System.nanoTime();
                lastBackgroundRequest.isWaiting = true;
                lastBackgroundRequest = null;
                lastForegroundRequest = this;
            }
            if (lastForegroundRequest != this) {
                lastForegroundRequest.waitingTimeStart = System.nanoTime();
                lastForegroundRequest.isWaiting = true;
                lastForegroundRequest = this;
            }
        }

        public void handleCompleted() {
            this.completedTime = System.nanoTime();
            super.handleCompleted();
        }

        public long getLatency() {
            return this.endTimeLatency - this.startTime;
        }

        public long getCompletedTime() {
            return this.completedTime - this.startTime;
        }

        public long getAverageWaitingTime() {
            if (this.waitingCounter == 0) {
                return 0L;
            }
            return this.waitingTime / (long)this.waitingCounter;
        }
    }
}

