/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.statistics;

import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStateStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsEventTypesModule;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsTotalsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.temp.statistics.TmfStatisticsTest;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

public class TmfStateStatisticsTest
extends TmfStatisticsTest {
    private ITmfTrace fTrace;
    private TmfStatisticsTotalsModule fTotalsMod;
    private TmfStatisticsEventTypesModule fEventTypesMod;

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((boolean)testTrace.exists());
    }

    @Before
    public void setUp() {
        CtfTmfTrace trace = testTrace.getTrace();
        this.fTrace = trace;
        this.fTotalsMod = new TmfStatisticsTotalsModule();
        this.fEventTypesMod = new TmfStatisticsEventTypesModule();
        try {
            this.fTotalsMod.setTrace((ITmfTrace)trace);
            this.fEventTypesMod.setTrace((ITmfTrace)trace);
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        this.fTotalsMod.schedule();
        this.fEventTypesMod.schedule();
        Assert.assertTrue((boolean)this.fTotalsMod.waitForCompletion());
        Assert.assertTrue((boolean)this.fEventTypesMod.waitForCompletion());
        ITmfStateSystem totalsSS = this.fTotalsMod.getStateSystem();
        ITmfStateSystem eventTypesSS = this.fEventTypesMod.getStateSystem();
        Assert.assertNotNull((Object)totalsSS);
        Assert.assertNotNull((Object)eventTypesSS);
        backend = new TmfStateStatistics(totalsSS, eventTypesSS);
    }

    @After
    public void tearDown() {
        this.fTotalsMod.dispose();
        this.fEventTypesMod.dispose();
        this.fTrace.dispose();
    }
}

