/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.trace;

import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ctf.core.CtfEnumPair;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class FunkyTraceTest {
    @Rule
    public TestRule globalTimeout = new Timeout(20L, TimeUnit.SECONDS);
    private static final CtfTmfTestTrace testTrace = CtfTmfTestTrace.FUNKY_TRACE;
    private static final double DELTA = 1.0E-7;
    private CtfTmfTrace fTrace;

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.fTrace = testTrace.getTrace();
        this.fTrace.indexTrace(true);
    }

    @After
    public void tearDown() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
        }
    }

    @Test
    public void testFirstEvent() {
        CtfTmfEvent event = this.getEvent(0L);
        Assert.assertEquals((Object)"Simple Event", (Object)event.getType().getName());
        Assert.assertEquals((long)1234567L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((long)42L, (long)((Long)event.getContent().getField(new String[]{"integer_field"}).getValue()).intValue());
        Assert.assertEquals((double)3.1415, (double)((Double)event.getContent().getField(new String[]{"float_field"}).getValue()), (double)1.0E-7);
    }

    @Test
    public void testSecondEvent() {
        CtfTmfEvent event = this.getEvent(1L);
        Assert.assertEquals((Object)"Spammy_Event", (Object)event.getType().getName());
        Assert.assertEquals((long)1234568L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((long)0L, (long)((Long)event.getContent().getField(new String[]{"field_1"}).getValue()).intValue());
        Assert.assertEquals((Object)"This is a test", (Object)event.getContent().getField(new String[]{"a_string"}).getValue());
    }

    @Test
    public void testSecondToLastEvent() {
        CtfTmfEvent event = this.getEvent(100000L);
        Assert.assertEquals((Object)"Spammy_Event", (Object)event.getType().getName());
        Assert.assertEquals((long)1334567L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((long)99999L, (long)((Long)event.getContent().getField(new String[]{"field_1"}).getValue()).intValue());
        Assert.assertEquals((Object)"This is a test", (Object)event.getContent().getField(new String[]{"a_string"}).getValue());
    }

    @Test
    public void testLastEvent() {
        CtfTmfEvent event = this.getEvent(100001L);
        Assert.assertEquals((Object)"Complex Test Event", (Object)event.getType().getName());
        Assert.assertEquals((long)1334568L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((long)0xDDF00DL, (long)((Long)event.getContent().getField(new String[]{"uint_35"}).getValue()).intValue());
        Assert.assertEquals((long)-12345L, (long)((Long)event.getContent().getField(new String[]{"int_16"}).getValue()).intValue());
        ITmfEventField[] complexStruct = (ITmfEventField[])event.getContent().getField(new String[]{"complex_structure"}).getValue();
        Assert.assertEquals((Object)"variant_selector", (Object)complexStruct[0].getName());
        CtfEnumPair variant1 = (CtfEnumPair)complexStruct[0].getValue();
        Assert.assertEquals((Object)"INT16_TYPE", (Object)variant1.getStringValue());
        Assert.assertEquals((Object)1L, (Object)variant1.getLongValue());
        Assert.assertEquals((Object)"a_string", (Object)complexStruct[1].getName());
        Assert.assertEquals((Object)"Test string", (Object)complexStruct[1].getValue());
        Assert.assertEquals((Object)"variant_value", (Object)complexStruct[2].getName());
        ITmfEventField variantField = (ITmfEventField)complexStruct[2].getValue();
        Assert.assertEquals((Object)"INT16_TYPE", (Object)variantField.getName());
        Assert.assertEquals((Object)-200L, (Object)variantField.getValue());
        ITmfEventField[] innerStruct = (ITmfEventField[])complexStruct[3].getValue();
        Assert.assertEquals((Object)"seq_len", (Object)innerStruct[0].getName());
        Assert.assertEquals((Object)10L, (Object)innerStruct[0].getValue());
        Assert.assertEquals((Object)"a_sequence", (Object)innerStruct[1].getName());
        long[] seqValues = (long[])innerStruct[1].getValue();
        long[] lArray = new long[10];
        lArray[0] = 4L;
        lArray[1] = 3L;
        lArray[2] = 2L;
        lArray[3] = 1L;
        lArray[5] = -1L;
        lArray[6] = -2L;
        lArray[7] = -3L;
        lArray[8] = -4L;
        lArray[9] = -5L;
        long[] expectedValues = lArray;
        Assert.assertArrayEquals((long[])expectedValues, (long[])seqValues);
    }

    private synchronized CtfTmfEvent getEvent(long index) {
        TestEventRequest req = new TestEventRequest(index);
        this.fTrace.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
        }
        catch (InterruptedException e) {
            return null;
        }
        return req.getEvent();
    }

    private class TestEventRequest
    extends TmfEventRequest {
        private CtfTmfEvent fRetEvent;

        public TestEventRequest(long index) {
            super(CtfTmfEvent.class, TmfTimeRange.ETERNITY, index, 1, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fRetEvent = null;
        }

        public void handleData(ITmfEvent event) {
            this.fRetEvent = (CtfTmfEvent)event;
        }

        public CtfTmfEvent getEvent() {
            return this.fRetEvent;
        }
    }
}

