/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.views.controlflow;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.controlflow.ControlFlowCheckActiveProvider;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.controlflow.ControlFlowPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractStateSystemTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowView
extends AbstractStateSystemTimeGraphView {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.views.controlflow";
    private static final String PROCESS_COLUMN = Messages.ControlFlowView_processColumn;
    private static final String TID_COLUMN = Messages.ControlFlowView_tidColumn;
    private static final String PTID_COLUMN = Messages.ControlFlowView_ptidColumn;
    private static final String BIRTH_TIME_COLUMN = Messages.ControlFlowView_birthTimeColumn;
    private static final String TRACE_COLUMN = Messages.ControlFlowView_traceColumn;
    private static final String[] COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN, PTID_COLUMN, BIRTH_TIME_COLUMN, TRACE_COLUMN};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public ControlFlowView() {
        super(ID, (TimeGraphPresentationProvider)new ControlFlowPresentationProvider());
        this.setTreeColumns(COLUMN_NAMES);
        this.setTreeLabelProvider(new ControlFlowTreeLabelProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ControlFlowFilterLabelProvider());
        this.setEntryComparator(new ControlFlowEntryComparator());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        super.getTimeGraphCombo().addTimeGraphFilterCheckActiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_checkActiveLabel, Messages.ControlFlowView_checkActiveToolTip));
        super.getTimeGraphCombo().addTimeGraphFilterUncheckInactiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_uncheckInactiveLabel, Messages.ControlFlowView_uncheckInactiveToolTip));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        Action hideArrowsAction = this.getTimeGraphCombo().getTimeGraphViewer().getHideArrowsAction(section);
        manager.add((IAction)hideArrowsAction);
        Action followArrowBwdAction = this.getTimeGraphCombo().getTimeGraphViewer().getFollowArrowBwdAction();
        followArrowBwdAction.setText(Messages.ControlFlowView_followCPUBwdText);
        followArrowBwdAction.setToolTipText(Messages.ControlFlowView_followCPUBwdText);
        manager.add((IAction)followArrowBwdAction);
        Action followArrowFwdAction = this.getTimeGraphCombo().getTimeGraphViewer().getFollowArrowFwdAction();
        followArrowFwdAction.setText(Messages.ControlFlowView_followCPUFwdText);
        followArrowFwdAction.setToolTipText(Messages.ControlFlowView_followCPUFwdText);
        manager.add((IAction)followArrowFwdAction);
    }

    protected String getNextText() {
        return Messages.ControlFlowView_nextProcessActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ControlFlowView_nextProcessActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ControlFlowView_previousProcessActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ControlFlowView_previousProcessActionToolTipText;
    }

    protected void buildEventList(final ITmfTrace trace, final ITmfTrace parentTrace, final IProgressMonitor monitor) {
        final ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return;
        }
        final ArrayList entryList = new ArrayList();
        final HashMap entryMap = new HashMap();
        long start = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), start));
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            long resolution = Math.max(1L, (end - ssq.getStartTime()) / (long)this.getDisplayWidth());
            this.setEndTime(Math.max(this.getEndTime(), end + 1L));
            final List threadQuarks = ssq.getQuarks(new String[]{"Threads", "*"});
            final long qStart = start;
            final long qEnd = end;
            this.queryFullStates(ssq, qStart, qEnd, resolution, monitor, new AbstractStateSystemTimeGraphView.IQueryHandler(){

                public void handle(List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState) {
                    Iterator iterator = threadQuarks.iterator();
                    while (iterator.hasNext()) {
                        int ppidQuark;
                        int execNameQuark;
                        int threadQuark = (Integer)iterator.next();
                        String threadName = ssq.getAttributeName(threadQuark);
                        int threadId = -1;
                        try {
                            threadId = Integer.parseInt(threadName);
                        }
                        catch (NumberFormatException e1) {
                            continue;
                        }
                        if (threadId <= 0) continue;
                        try {
                            execNameQuark = ssq.getQuarkRelative(threadQuark, new String[]{"Exec_name"});
                            ppidQuark = ssq.getQuarkRelative(threadQuark, new String[]{"PPID"});
                        }
                        catch (AttributeNotFoundException e) {
                            continue;
                        }
                        ITmfStateInterval lastExecNameInterval = prevFullState == null || execNameQuark >= prevFullState.size() ? null : prevFullState.get(execNameQuark);
                        long lastExecNameStartTime = lastExecNameInterval == null ? -1L : lastExecNameInterval.getStartTime();
                        long lastExecNameEndTime = lastExecNameInterval == null ? -1L : lastExecNameInterval.getEndTime() + 1L;
                        long lastPpidStartTime = prevFullState == null || ppidQuark >= prevFullState.size() ? -1L : prevFullState.get(ppidQuark).getStartTime();
                        for (List<ITmfStateInterval> fullState : fullStates) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (execNameQuark >= fullState.size() || ppidQuark >= fullState.size()) continue;
                            ITmfStateInterval execNameInterval = fullState.get(execNameQuark);
                            ITmfStateInterval ppidInterval = fullState.get(ppidQuark);
                            long startTime = execNameInterval.getStartTime();
                            long endTime = execNameInterval.getEndTime() + 1L;
                            if (startTime == lastExecNameStartTime && ppidInterval.getStartTime() == lastPpidStartTime) continue;
                            boolean isNull = execNameInterval.getStateValue().isNull();
                            if (isNull && lastExecNameEndTime < startTime && lastExecNameEndTime != -1L) {
                                try {
                                    execNameInterval = ssq.querySingleState(startTime - 1L, execNameQuark);
                                    ppidInterval = ssq.querySingleState(startTime - 1L, ppidQuark);
                                    startTime = execNameInterval.getStartTime();
                                    endTime = execNameInterval.getEndTime() + 1L;
                                }
                                catch (AttributeNotFoundException e) {
                                    Activator.getDefault().logError(e.getMessage());
                                }
                                catch (StateSystemDisposedException e) {
                                    // empty catch block
                                }
                            }
                            if (!execNameInterval.getStateValue().isNull() && execNameInterval.getStateValue().getType() == ITmfStateValue.Type.STRING) {
                                String execName = execNameInterval.getStateValue().unboxStr();
                                int ppid = ppidInterval.getStateValue().unboxInt();
                                ControlFlowEntry entry = (ControlFlowEntry)((Object)entryMap.get(threadId));
                                if (entry == null) {
                                    entry = new ControlFlowEntry(threadQuark, trace, execName, threadId, ppid, startTime, endTime);
                                    entryList.add(entry);
                                    entryMap.put(threadId, entry);
                                } else {
                                    entry.setName(execName);
                                    entry.setParentThreadId(ppid);
                                    entry.updateEndTime(endTime);
                                }
                            }
                            if (isNull) {
                                entryMap.remove(threadId);
                            }
                            lastExecNameStartTime = startTime;
                            lastExecNameEndTime = endTime;
                            lastPpidStartTime = ppidInterval.getStartTime();
                        }
                    }
                    ControlFlowView.this.updateTree(entryList, parentTrace, ssq);
                    for (TimeGraphEntry entry : ControlFlowView.this.getEntryList(ssq)) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        ControlFlowView.this.buildStatusEvents(trace, parentTrace, ssq, fullStates, prevFullState, (ControlFlowEntry)entry, monitor, qStart, qEnd);
                    }
                }
            });
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            start = end;
        }
    }

    private void updateTree(List<ControlFlowEntry> entryList, ITmfTrace parentTrace, ITmfStateSystem ss) {
        ArrayList<ControlFlowEntry> rootListToAdd = new ArrayList<ControlFlowEntry>();
        ArrayList<ControlFlowEntry> rootListToRemove = new ArrayList<ControlFlowEntry>();
        List rootList = this.getEntryList(ss);
        for (ControlFlowEntry entry : entryList) {
            boolean root;
            boolean bl = root = entry.getParent() == null;
            if (root && entry.getParentThreadId() > 0) {
                for (ControlFlowEntry parent : entryList) {
                    if (parent.getThreadId() != entry.getParentThreadId() || entry.getStartTime() > parent.getEndTime() || entry.getEndTime() < parent.getStartTime()) continue;
                    parent.addChild(entry);
                    root = false;
                    if (rootList == null || !rootList.contains((Object)entry)) break;
                    rootListToRemove.add(entry);
                    break;
                }
            }
            if (!root || rootList != null && rootList.contains((Object)entry)) continue;
            rootListToAdd.add(entry);
        }
        this.addToEntryList(parentTrace, ss, rootListToAdd);
        this.removeFromEntryList(parentTrace, ss, rootListToRemove);
    }

    private void buildStatusEvents(ITmfTrace trace, ITmfTrace parentTrace, ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, ControlFlowEntry entry, @NonNull IProgressMonitor monitor, long start, long end) {
        if (start < entry.getEndTime() && end > entry.getStartTime()) {
            List<ITimeEvent> eventList = this.getEventList(entry, ss, fullStates, prevFullState, monitor);
            if (eventList == null) {
                return;
            }
            for (ITimeEvent event : eventList) {
                entry.addEvent(event);
            }
            if (parentTrace.equals(this.getTrace())) {
                this.redraw();
            }
        }
        for (ITimeGraphEntry child : entry.getChildren()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.buildStatusEvents(trace, parentTrace, ss, fullStates, prevFullState, (ControlFlowEntry)child, monitor, start, end);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected List<ITimeEvent> getEventList(@NonNull TimeGraphEntry tgentry, ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        ArrayList<Object> eventList = null;
        if (!(tgentry instanceof ControlFlowEntry)) {
            return eventList;
        }
        ControlFlowEntry entry = (ControlFlowEntry)tgentry;
        try {
            int threadQuark = entry.getThreadQuark();
            int statusQuark = ss.getQuarkRelative(threadQuark, new String[]{"Status"});
            eventList = new ArrayList<Object>(fullStates.size());
            ITmfStateInterval lastInterval = prevFullState == null || statusQuark >= prevFullState.size() ? null : prevFullState.get(statusQuark);
            long lastStartTime = lastInterval == null ? -1L : lastInterval.getStartTime();
            long lastEndTime = lastInterval == null ? -1L : lastInterval.getEndTime() + 1L;
            Iterator<List<ITmfStateInterval>> iterator = fullStates.iterator();
            while (true) {
                ITmfStateInterval statusInterval;
                long time;
                if (!iterator.hasNext()) {
                    return eventList;
                }
                List<ITmfStateInterval> fullState = iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                if (statusQuark >= fullState.size() || (time = (statusInterval = fullState.get(statusQuark)).getStartTime()) == lastStartTime) continue;
                long duration = statusInterval.getEndTime() - time + 1L;
                int status = -1;
                try {
                    status = statusInterval.getStateValue().unboxInt();
                }
                catch (StateValueTypeException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
                if (lastEndTime != time && lastEndTime != -1L) {
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                }
                if (!statusInterval.getStateValue().isNull()) {
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                } else {
                    eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                }
                lastStartTime = time;
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException | TimeRangeException e) {
            Activator.getDefault().logError(e.getMessage());
        }
        return eventList;
    }

    private int getSelectionValue(long time) {
        int thread = -1;
        block3: for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace())) {
            ITmfStateSystem ssq;
            if (thread > 0) break;
            if (trace == null || (ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel")) == null || time < ssq.getStartTime() || time > ssq.getCurrentEndTime()) continue;
            List currentThreadQuarks = ssq.getQuarks(new String[]{"CPUs", "*", "Current_thread"});
            Iterator iterator = currentThreadQuarks.iterator();
            while (iterator.hasNext()) {
                int currentThreadQuark = (Integer)iterator.next();
                try {
                    int statusQuark;
                    ITmfStateInterval statusInterval;
                    ITmfStateInterval currentThreadInterval = ssq.querySingleState(time, currentThreadQuark);
                    int currentThread = currentThreadInterval.getStateValue().unboxInt();
                    if (currentThread <= 0 || (statusInterval = ssq.querySingleState(time, statusQuark = ssq.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThread), "Status"}))).getStartTime() != time) continue;
                    thread = currentThread;
                    continue block3;
                }
                catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
        }
        return thread;
    }

    protected void synchingToTime(long time) {
        int selected = this.getSelectionValue(time);
        if (selected > 0) {
            ITimeGraphEntry[] iTimeGraphEntryArray = this.getTimeGraphViewer().getExpandedElements();
            int n = iTimeGraphEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ControlFlowEntry entry;
                ITimeGraphEntry element = iTimeGraphEntryArray[n2];
                if (element instanceof ControlFlowEntry && (entry = (ControlFlowEntry)element).getThreadId() == selected) {
                    this.getTimeGraphCombo().setSelection((ITimeGraphEntry)entry);
                    break;
                }
                ++n2;
            }
        }
    }

    @NonNull
    protected List<ILinkEvent> getLinkList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @NonNull IProgressMonitor monitor) {
        ArrayList<ILinkEvent> list = new ArrayList<ILinkEvent>();
        List entryList = this.getEntryList(ss);
        if (entryList == null) {
            return list;
        }
        for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace())) {
            if (trace == null) continue;
            List currentThreadQuarks = ss.getQuarks(new String[]{"CPUs", "*", "Current_thread"});
            Iterator iterator = currentThreadQuarks.iterator();
            while (iterator.hasNext()) {
                int currentThreadQuark = (Integer)iterator.next();
                if (currentThreadQuark >= fullStates.get(0).size()) continue;
                ArrayList<ITmfStateInterval> currentThreadIntervals = new ArrayList<ITmfStateInterval>(fullStates.size() + 2);
                try {
                    long start = Math.max(fullStates.get(0).get(currentThreadQuark).getStartTime() - 1L, ss.getStartTime());
                    currentThreadIntervals.add(ss.querySingleState(start, currentThreadQuark));
                    for (List<ITmfStateInterval> fullState : fullStates) {
                        currentThreadIntervals.add(fullState.get(currentThreadQuark));
                    }
                    long end = Math.min(fullStates.get(fullStates.size() - 1).get(currentThreadQuark).getEndTime() + 1L, ss.getCurrentEndTime());
                    currentThreadIntervals.add(ss.querySingleState(end, currentThreadQuark));
                }
                catch (AttributeNotFoundException e) {
                    Activator.getDefault().logError(e.getMessage());
                    return list;
                }
                catch (StateSystemDisposedException e) {
                    return list;
                }
                int prevThread = 0;
                long prevEnd = 0L;
                long lastEnd = 0L;
                for (ITmfStateInterval currentThreadInterval : currentThreadIntervals) {
                    int thread;
                    if (monitor.isCanceled()) {
                        return list;
                    }
                    if (currentThreadInterval.getEndTime() + 1L == lastEnd) continue;
                    long time = currentThreadInterval.getStartTime();
                    if (time != lastEnd) {
                        prevThread = 0;
                        prevEnd = 0L;
                    }
                    if ((thread = currentThreadInterval.getStateValue().unboxInt()) > 0 && prevThread > 0) {
                        ControlFlowEntry prevEntry = this.findEntry(entryList, trace, prevThread);
                        ControlFlowEntry nextEntry = this.findEntry(entryList, trace, thread);
                        list.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)prevEntry, (ITimeGraphEntry)nextEntry, prevEnd, time - prevEnd, 0));
                    }
                    lastEnd = currentThreadInterval.getEndTime() + 1L;
                    if (thread == 0) continue;
                    prevThread = thread;
                    prevEnd = lastEnd;
                }
            }
        }
        return list;
    }

    private ControlFlowEntry findEntry(List<? extends ITimeGraphEntry> entryList, ITmfTrace trace, int threadId) {
        for (ITimeGraphEntry iTimeGraphEntry : entryList) {
            if (!(iTimeGraphEntry instanceof ControlFlowEntry)) continue;
            ControlFlowEntry controlFlowEntry = (ControlFlowEntry)iTimeGraphEntry;
            if (controlFlowEntry.getThreadId() == threadId && controlFlowEntry.getTrace() == trace) {
                return controlFlowEntry;
            }
            if (!iTimeGraphEntry.hasChildren() || (controlFlowEntry = this.findEntry(iTimeGraphEntry.getChildren(), trace, threadId)) == null) continue;
            return controlFlowEntry;
        }
        return null;
    }

    private static class ControlFlowEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ControlFlowEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            int result = 0;
            if (o1 instanceof ControlFlowEntry && o2 instanceof ControlFlowEntry) {
                ControlFlowEntry entry1 = (ControlFlowEntry)o1;
                ControlFlowEntry entry2 = (ControlFlowEntry)o2;
                result = entry1.getTrace().getStartTime().compareTo(entry2.getTrace().getStartTime());
                if (result == 0) {
                    result = entry1.getTrace().getName().compareTo(entry2.getTrace().getName());
                }
                if (result == 0) {
                    int n = entry1.getThreadId() < entry2.getThreadId() ? -1 : (result = entry1.getThreadId() > entry2.getThreadId() ? 1 : 0);
                }
            }
            if (result == 0) {
                result = o1.getStartTime() < o2.getStartTime() ? -1 : (o1.getStartTime() > o2.getStartTime() ? 1 : 0);
            }
            return result;
        }
    }

    private static class ControlFlowFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ControlFlowFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (columnIndex == 0) {
                return entry.getName();
            }
            if (columnIndex == 1) {
                return Integer.toString(entry.getThreadId());
            }
            return "";
        }
    }

    protected static class ControlFlowTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        protected ControlFlowTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_processColumn)) {
                return entry.getName();
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_tidColumn)) {
                return Integer.toString(entry.getThreadId());
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_ptidColumn)) {
                if (entry.getParentThreadId() > 0) {
                    return Integer.toString(entry.getParentThreadId());
                }
            } else {
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_birthTimeColumn)) {
                    return Utils.formatTime((long)entry.getStartTime(), (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC);
                }
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_traceColumn)) {
                    return entry.getTrace().getName();
                }
            }
            return "";
        }
    }
}

