/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.event;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.junit.Assert;
import org.junit.Test;

public class CTFCallsiteTest {
    private static CTFCallsite GenerateCS(long ip) {
        return new CTFCallsite("event name", "func name", ip, "file.java", 1L);
    }

    @Test
    public void constructorTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        Assert.assertNotNull((Object)cs);
    }

    @Test
    public void getterTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        Assert.assertEquals((String)"ip", (long)1L, (long)cs.getIp());
        Assert.assertEquals((String)"ip", (Object)"event name", (Object)cs.getEventName());
        Assert.assertEquals((String)"ip", (Object)"file.java", (Object)cs.getFileName());
        Assert.assertEquals((String)"ip", (Object)"func name", (Object)cs.getFunctionName());
    }

    @Test
    public void hashCodeTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        HashMap<CTFCallsite, Object> test = new HashMap<CTFCallsite, Object>();
        test.put(cs, new Object());
        Assert.assertTrue((boolean)test.containsKey(cs));
        Assert.assertTrue((boolean)test.containsKey(CTFCallsiteTest.GenerateCS(1L)));
        Assert.assertFalse((boolean)test.containsKey(CTFCallsiteTest.GenerateCS(2L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event nam", "func name", 1L, "file.java", 1L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event name", "func nam", 1L, "file.java", 1L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event name", "func name", 1L, "file.jav", 1L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event name", "func name", 1L, "file.java", 2L)));
    }

    @Test
    public void comparatorTest() {
        Object[] cs = new CTFCallsite[5];
        long[] lArray = new long[5];
        lArray[0] = 1L;
        lArray[2] = -2L;
        lArray[3] = 2L;
        lArray[4] = -1L;
        long[] vals = lArray;
        int i = 0;
        while (i < 5) {
            cs[i] = CTFCallsiteTest.GenerateCS(vals[i]);
            ++i;
        }
        Assert.assertEquals((long)1L, (long)cs[0].compareTo(cs[1]));
        Assert.assertEquals((long)-1L, (long)cs[1].compareTo(cs[0]));
        Assert.assertEquals((long)0L, (long)cs[0].compareTo(cs[0]));
        Assert.assertEquals((long)-1L, (long)cs[0].compareTo(cs[2]));
        Assert.assertEquals((long)1L, (long)cs[2].compareTo(cs[0]));
        Arrays.sort(cs);
        Assert.assertEquals((long)0L, (long)cs[0].getIp());
        Assert.assertEquals((long)1L, (long)cs[1].getIp());
        Assert.assertEquals((long)2L, (long)cs[2].getIp());
        Assert.assertEquals((long)-2L, (long)cs[3].getIp());
        Assert.assertEquals((long)-1L, (long)cs[4].getIp());
    }

    @Test
    public void toStringTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        Assert.assertEquals((Object)"file.java/func name:1", (Object)cs.toString());
    }
}

