/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.perf.trace;

import java.util.Random;
import java.util.TreeSet;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class CTFTraceCallsitePerformanceTest {
    private static final String TEST_SUITE_NAME = "CTF Callsite Benchmark";
    private static final String TEST_ID = "org.eclipse.linuxtools#CTF Callsite Benchmark";
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private static final int NUMBER_OF_SEEKS = 100000;
    private final String[] callsites = new String[]{"Alligator", "Bunny", "Cat", "Dolphin", "Echidna", "Gazelle", "Heron", "Ibex", "Jackalope", "Koala", "Lynx", "Meerkat", "Narwhal", "Ocelot", "Pangolin", "Quetzal", "Ringtail", "Sandpiper", "Tiger", "Urchin", "Vulture", "Walrus", "X-Ray Tetra", "Zonkey"};
    private final String[] functions = new String[]{"sentence", "together", "children", "mountain", "chipmunk", "crashing", "drinking", "insisted", "insulted", "invented", "squinted", "standing", "swishing", "talented", "whiplash", "complain", "granddad", "sprinkle", "surprise", "umbrella", "anything", "anywhere", "baseball", "birthday", "bluebird", "cheerful", "colorful", "daylight", "doghouse", "driveway", "everyone"};
    private final String[] files = new String[]{"Adult.java", "Aeroplane.java", "Air.java", "Airforce.java", "Airport.java", "Album.java", "Alphabet.java", "Apple.java", "Arm.java", "Army.java", "Babby.java"};
    Random rnd = new Random();
    CTFTrace fTrace = null;

    public static void main(String[] args) {
        new JUnitCore().run(new Class[]{CTFTraceCallsitePerformanceTest.class});
    }

    @Before
    public void setup() throws CTFException, SecurityException, IllegalArgumentException {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.fTrace = new CTFTrace(testTrace.getPath());
    }

    private void addCallsites(int numCallsites) {
        long stepSize = Long.MAX_VALUE / (long)(numCallsites + 1);
        int jitter = (int)Math.min(stepSize, Integer.MAX_VALUE);
        int i = 0;
        while (i < numCallsites) {
            long ip = (long)i * stepSize + (long)this.rnd.nextInt(jitter);
            this.fTrace.addCallsite(this.getRandomElement(this.callsites), this.getRandomElement(this.functions), ip, this.getRandomElement(this.files), ip / 1000000L * 100L);
            ++i;
        }
    }

    private String getRandomElement(String[] array) {
        return array[this.rnd.nextInt(array.length)];
    }

    private void testMain(PerformanceMeter pm) {
        TreeSet l = this.fTrace.getCallsiteCandidates(this.callsites[0]);
        CTFCallsite cs = this.fTrace.getCallsite(1L);
        CTFCallsite cs1 = this.fTrace.getCallsite(this.callsites[0]);
        CTFCallsite cs2 = this.fTrace.getCallsite(this.callsites[0], 1L);
        Assert.assertNotNull((Object)l);
        Assert.assertNotNull((Object)cs);
        Assert.assertNotNull((Object)cs1);
        Assert.assertNotNull((Object)cs2);
        pm.start();
        this.perfTest();
        pm.stop();
    }

    private void test(int callsiteSize) {
        String testName = "Test" + callsiteSize + " callsites";
        this.addCallsites(callsiteSize);
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#CTF Callsite Benchmark#" + testName);
        perf.tagAsSummary(pm, "CTF Callsite Benchmark:" + callsiteSize + " callsites", Dimension.CPU_TIME);
        this.testMain(pm);
        pm.commit();
    }

    private void perfTest() {
        int i = 0;
        while (i < 100000) {
            this.fTrace.getCallsite((long)this.rnd.nextInt() << 16);
            ++i;
        }
    }

    @Test
    public void test1KCallsites() {
        this.test(1000);
    }

    @Test
    public void test2KCallsites() {
        this.test(2000);
    }

    @Test
    public void test5KCallsites() {
        this.test(5000);
    }

    @Test
    public void test10KCallsites() {
        this.test(10000);
    }

    @Test
    public void test20KCallsites() {
        this.test(20000);
    }

    @Test
    public void test50KCallsites() {
        this.test(50000);
    }

    @Test
    public void test100KCallsites() {
        this.test(100000);
    }

    @Test
    public void test1MCallsites() {
        this.test(1000000);
    }

    @Test
    public void test2MCallsites() {
        this.test(2000000);
    }
}

