/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndexEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFStreamInputPacketIndexEntryTest {
    private ICTFPacketDescriptor fixture;

    @Before
    public void setUp() {
        this.fixture = new StreamInputPacketIndexEntry(1L, 1L);
    }

    @Test
    public void testStreamInputPacketIndexEntry_1() {
        String expectedResult = "StreamInputPacketIndexEntry [offsetBits=1, timestampBegin=-9223372036854775808, timestampEnd=9223372036854775807]";
        Assert.assertNotNull((Object)this.fixture);
        Assert.assertEquals((Object)expectedResult, (Object)this.fixture.toString());
        Assert.assertEquals((long)1L, (long)this.fixture.getOffsetBits());
        Assert.assertEquals((long)0L, (long)this.fixture.getOffsetBytes());
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor1() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_begin", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("load_factor", (IDeclaration)new FloatDeclaration(24, 8, ByteOrder.nativeOrder(), 8L));
        sd.addField("target", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII));
        sd.addField("Enum", (IDeclaration)new EnumDeclaration(IntegerDeclaration.INT_8_DECL));
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(100);
        bb.getByteBuffer().putInt(200);
        bb.getByteBuffer().putFloat(0.75f);
        bb.getByteBuffer().put("Test".getBytes());
        bb.getByteBuffer().put((byte)0);
        bb.getByteBuffer().put((byte)0);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 0L);
        Assert.assertNull((Object)sipie.getTarget());
        Assert.assertEquals((long)100L, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)200L, (long)sipie.getTimestampEnd());
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor2() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_begin", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("content_size", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("target", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII));
        sd.addField("Enum", (IDeclaration)new EnumDeclaration(IntegerDeclaration.INT_8_DECL));
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(100);
        bb.getByteBuffer().putInt(200);
        bb.getByteBuffer().putInt(128);
        bb.getByteBuffer().put("Test".getBytes());
        bb.getByteBuffer().put((byte)0);
        bb.getByteBuffer().put((byte)0);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 0L);
        Assert.assertNull((Object)sipie.getTarget());
        Assert.assertEquals((long)100L, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)200L, (long)sipie.getTimestampEnd());
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor3() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_begin", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("packet_size", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("target", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII));
        sd.addField("Enum", (IDeclaration)new EnumDeclaration(IntegerDeclaration.INT_8_DECL));
        sd.addField("intruder", (IDeclaration)new StructDeclaration(8L));
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(100);
        bb.getByteBuffer().putInt(200);
        bb.getByteBuffer().putInt(128);
        bb.getByteBuffer().put("Test".getBytes());
        bb.getByteBuffer().put((byte)0);
        bb.getByteBuffer().put((byte)0);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 0L);
        Assert.assertNull((Object)sipie.getTarget());
        Assert.assertEquals((long)100L, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)200L, (long)sipie.getTimestampEnd());
        Assert.assertTrue((boolean)sipie.includes(150L));
        Assert.assertFalse((boolean)sipie.includes(10L));
        Assert.assertFalse((boolean)sipie.includes(250L));
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor4() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("content_size", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("target", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII));
        sd.addField("Enum", (IDeclaration)new EnumDeclaration(IntegerDeclaration.INT_8_DECL));
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(0);
        bb.getByteBuffer().put("Test".getBytes());
        bb.getByteBuffer().put((byte)0);
        bb.getByteBuffer().put((byte)0);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 0L);
        Assert.assertNull((Object)sipie.getTarget());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)sipie.getTimestampEnd());
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor5() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("content_size", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("device", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII));
        sd.addField("Enum", (IDeclaration)new EnumDeclaration(IntegerDeclaration.INT_8_DECL));
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(-1);
        bb.getByteBuffer().putInt(0);
        bb.getByteBuffer().put("Test66".getBytes());
        bb.getByteBuffer().put((byte)0);
        bb.getByteBuffer().put((byte)0);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 0L);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)sipie.getTimestampEnd());
        Assert.assertEquals((Object)"Test66", (Object)sipie.getTarget());
        Assert.assertEquals((long)66L, (long)sipie.getTargetId());
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor6() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("content_size", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("cpu_id", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("events_discarded", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(-1);
        bb.getByteBuffer().putInt(0);
        bb.getByteBuffer().putInt(66);
        bb.getByteBuffer().putInt(300);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 100L);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)sipie.getTimestampEnd());
        Assert.assertEquals((Object)"CPU66", (Object)sipie.getTarget());
        Assert.assertEquals((long)66L, (long)sipie.getTargetId());
        Assert.assertEquals((long)200L, (long)sipie.getLostEvents());
        Assert.assertEquals((long)0L, (long)sipie.getOffsetBits());
        Assert.assertEquals((long)1024L, (long)sipie.getPacketSizeBits());
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor7() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("content_size", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        EnumDeclaration declaration = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)16, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)8L));
        declaration.add(313L, 315L, "CPU-PI");
        sd.addField("device", (IDeclaration)declaration);
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(-1);
        bb.getByteBuffer().putInt(0);
        bb.getByteBuffer().putShort((short)314);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 0L);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)sipie.getTimestampEnd());
        Assert.assertEquals((Object)"CPU-PI", (Object)sipie.getTarget());
        Assert.assertEquals((long)314L, (long)sipie.getTargetId());
    }

    @Test
    public void testStreamInputPacketIndexEntryConstructor8() throws CTFException {
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("content_size", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        IntegerDeclaration declaration = IntegerDeclaration.createDeclaration((int)16, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)8L);
        sd.addField("device", (IDeclaration)declaration);
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        bb.getByteBuffer().putInt(-1);
        bb.getByteBuffer().putInt(0);
        bb.getByteBuffer().putShort((short)314);
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        StreamInputPacketIndexEntry sipie = new StreamInputPacketIndexEntry(0L, sdef, 128L, 0L);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)sipie.getTimestampBegin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)sipie.getTimestampEnd());
        Assert.assertEquals((Object)"314", (Object)sipie.getTarget());
        Assert.assertEquals((long)314L, (long)sipie.getTargetId());
    }

    @Test
    public void testToString() throws CTFException {
        String expectedResult = "StreamInputPacketIndexEntry [offsetBits=0, timestampBegin=0, timestampEnd=0]";
        StructDeclaration sd = new StructDeclaration(8L);
        sd.addField("timestamp_begin", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        sd.addField("timestamp_end", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        BitBuffer bb = new BitBuffer(ByteBuffer.allocate(128));
        StructDefinition sdef = sd.createDefinition(null, (ILexicalScope)ILexicalScope.PACKET_HEADER, bb);
        Assert.assertEquals((Object)expectedResult, (Object)new StreamInputPacketIndexEntry(0L, sdef, 10000L, 0L).toString());
    }
}

