/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.ctf.core.trace.Metadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFTraceGrowingTest {
    private final String fPathName = CtfTestTrace.SYNTHETIC_TRACE.getPath();
    private final CTFTrace fixture = new CTFTrace();

    @Before
    public void init() throws FileNotFoundException, IOException, CTFException {
        Metadata md = new Metadata(this.fixture);
        File metadata = new File(String.valueOf(this.fPathName) + "/" + "metadata");
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(metadata)));){
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            String result = sb.toString();
            md.parseText(result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testEmptyStream() throws CTFException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fixture);){
            Assert.assertNull((Object)reader.getCurrentEventDef());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testAddStream() throws CTFException {
        File stream = new File(String.valueOf(this.fPathName) + "/" + "channel1");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fixture);){
            this.fixture.addStreamFile(stream);
            reader.update();
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertNotNull((Object)reader.getCurrentEventDef());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testAddTwoStreams1() throws CTFException {
        File stream = new File(String.valueOf(this.fPathName) + "/" + "channel1");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fixture);){
            this.fixture.addStreamFile(stream);
            stream = new File(String.valueOf(this.fPathName) + "/" + "channel2");
            this.fixture.addStreamFile(stream);
            reader.update();
            Assert.assertTrue((boolean)reader.advance());
            EventDefinition currentEventDef = reader.getCurrentEventDef();
            Assert.assertNotNull((Object)reader.getCurrentEventDef());
            Assert.assertEquals((long)16518L, (long)currentEventDef.getTimestamp());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testAddTwoStreams2() throws CTFException {
        File stream = new File(String.valueOf(this.fPathName) + "/" + "channel1");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fixture);){
            this.fixture.addStreamFile(stream);
            stream = new File(String.valueOf(this.fPathName) + "/" + "channel2");
            reader.update();
            Assert.assertTrue((boolean)reader.advance());
            this.fixture.addStreamFile(stream);
            reader.update();
            Assert.assertTrue((boolean)reader.advance());
            EventDefinition currentEventDef = reader.getCurrentEventDef();
            Assert.assertNotNull((Object)currentEventDef);
            Assert.assertEquals((long)223007L, (long)currentEventDef.getTimestamp());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testAddTwoStreams3() throws CTFException {
        File stream = new File(String.valueOf(this.fPathName) + "/" + "channel1");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fixture);){
            this.fixture.addStreamFile(stream);
            stream = new File(String.valueOf(this.fPathName) + "/" + "channel2");
            reader.update();
            reader.update();
            reader.update();
            Assert.assertTrue((boolean)reader.advance());
            this.fixture.addStreamFile(stream);
            reader.update();
            reader.update();
            reader.update();
            reader.update();
            Assert.assertTrue((boolean)reader.advance());
            EventDefinition currentEventDef = reader.getCurrentEventDef();
            Assert.assertNotNull((Object)currentEventDef);
            Assert.assertEquals((long)223007L, (long)currentEventDef.getTimestamp());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=CTFException.class)
    public void testAddStreamFail() throws CTFException {
        File stream = new File(String.valueOf(this.fPathName) + "/" + "metadata");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fixture);){
            this.fixture.addStreamFile(stream);
            Assert.assertNull((Object)reader.getCurrentEventDef());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

