/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.Messages;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis2;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AnalysisModuleTest {
    @NonNull
    private static final String MODULE_GENERIC_ID = "test.id";
    @NonNull
    private static final String MODULE_GENERIC_NAME = "Test analysis";

    @After
    public void cleanupTraces() {
        TmfTestTrace.A_TEST_10K.dispose();
    }

    @Test
    public void testGettersSetters() {
        TestAnalysis module = new TestAnalysis();
        module.setName(MODULE_GENERIC_NAME);
        module.setId(MODULE_GENERIC_ID);
        Assert.assertEquals((Object)MODULE_GENERIC_ID, (Object)module.getId());
        Assert.assertEquals((Object)MODULE_GENERIC_NAME, (Object)module.getName());
        module.setAutomatic(false);
        Assert.assertFalse((boolean)module.isAutomatic());
        module.setAutomatic(true);
        Assert.assertTrue((boolean)module.isAutomatic());
        module.addParameter("test");
        Assert.assertNull((Object)module.getParameter("test"));
        module.setParameter("test", 1);
        Assert.assertEquals((Object)1, (Object)module.getParameter("test"));
        String wrongParam = "abc";
        RuntimeException exception = null;
        try {
            module.setParameter(wrongParam, 1);
        }
        catch (RuntimeException e) {
            exception = e;
            Assert.assertEquals((Object)NLS.bind((String)Messages.TmfAbstractAnalysisModule_InvalidParameter, (Object)wrongParam, (Object)module.getName()), (Object)e.getMessage());
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertNull((Object)module.getParameter(wrongParam));
        module.dispose();
    }

    private static TestAnalysis setUpAnalysis() {
        TestAnalysis module = new TestAnalysis();
        module.setName(MODULE_GENERIC_NAME);
        module.setId(MODULE_GENERIC_ID);
        module.addParameter("test");
        return module;
    }

    @Test
    public void testWaitForCompletionSuccess() {
        TestAnalysis module = AnalysisModuleTest.setUpAnalysis();
        IStatus status = module.schedule();
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        try {
            Assert.assertTrue((boolean)module.setTrace(TmfTestTrace.A_TEST_10K.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        module.setParameter("test", 1);
        status = module.schedule();
        Assert.assertEquals((Object)Status.OK_STATUS, (Object)status);
        boolean completed = module.waitForCompletion();
        Assert.assertTrue((boolean)completed);
        Assert.assertEquals((long)1L, (long)module.getAnalysisOutput());
        module.dispose();
    }

    @Test
    public void testWaitForCompletionCancelled() {
        TestAnalysis module = AnalysisModuleTest.setUpAnalysis();
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        try {
            Assert.assertTrue((boolean)module.setTrace(trace));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        module.setParameter("test", 0);
        IStatus status = module.schedule();
        Assert.assertEquals((Object)Status.OK_STATUS, (Object)status);
        boolean completed = module.waitForCompletion();
        Assert.assertFalse((boolean)completed);
        Assert.assertEquals((long)0L, (long)module.getAnalysisOutput());
        module.dispose();
    }

    @Test
    public void testSetWrongTrace() {
        TestAnalysis2 module = new TestAnalysis2();
        module.setName(MODULE_GENERIC_NAME);
        module.setId(MODULE_GENERIC_ID);
        Assert.assertEquals((Object)MODULE_GENERIC_ID, (Object)module.getId());
        Assert.assertEquals((Object)MODULE_GENERIC_NAME, (Object)module.getName());
        try {
            Assert.assertFalse((boolean)module.setTrace(TmfTestTrace.A_TEST_10K.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        module.dispose();
    }

    @Test
    public void testSetTraceTwice() {
        TestAnalysis module = new TestAnalysis();
        module.setName(MODULE_GENERIC_NAME);
        module.setId(MODULE_GENERIC_ID);
        try {
            Assert.assertTrue((boolean)module.setTrace(TmfTestTrace.A_TEST_10K.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        TmfAnalysisException exception = null;
        try {
            module.setTrace(TmfTestTrace.A_TEST_10K.getTrace());
        }
        catch (TmfAnalysisException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)((Object)exception));
        module.dispose();
    }

    @Test
    public void testCancel() {
        TestAnalysis module = AnalysisModuleTest.setUpAnalysis();
        module.setParameter("test", 999);
        try {
            Assert.assertTrue((boolean)module.setTrace(TmfTestTrace.A_TEST_10K.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)Status.OK_STATUS, (Object)module.schedule());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        module.cancel();
        Assert.assertFalse((boolean)module.waitForCompletion());
        Assert.assertEquals((long)-1L, (long)module.getAnalysisOutput());
        module.dispose();
    }

    @Test
    public void testParameterChanged() {
        TestAnalysis module = AnalysisModuleTest.setUpAnalysis();
        try {
            Assert.assertTrue((boolean)module.setTrace(TmfTestTrace.A_TEST_10K.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        RuntimeException exception = null;
        try {
            module.notifyParameterChanged("aaa");
        }
        catch (RuntimeException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        module.dispose();
    }

    @Test
    public void testHelper() {
        TestAnalysis module = AnalysisModuleTest.setUpAnalysis();
        try {
            Assert.assertTrue((boolean)module.setTrace(TmfTestTrace.A_TEST_10K.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        module.setParameter("test", 1);
        boolean res = TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        Assert.assertTrue((boolean)res);
        module.setParameter("test", 0);
        res = TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        Assert.assertFalse((boolean)res);
        module.dispose();
    }

    @Test
    public void testDependentAnalyses() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        int paramAndResult = 5;
        String suffix = " dep";
        final TestAnalysis depModule = new TestAnalysis(){

            @Override
            protected boolean executeAnalysis(IProgressMonitor monitor) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
                return super.executeAnalysis(monitor);
            }
        };
        depModule.setName("Test analysis dep");
        depModule.setId("test.id dep");
        depModule.addParameter("test");
        depModule.setParameter("test", paramAndResult);
        TestAnalysis module = new TestAnalysis(){

            protected Iterable<IAnalysisModule> getDependentAnalyses() {
                HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>();
                modules.add((IAnalysisModule)depModule);
                return modules;
            }
        };
        module.setName(MODULE_GENERIC_NAME);
        module.setId(MODULE_GENERIC_ID);
        module.addParameter("test");
        module.setParameter("test", paramAndResult);
        try {
            Assert.assertTrue((boolean)depModule.setTrace(trace));
            Assert.assertTrue((boolean)module.setTrace(trace));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)0L, (long)module.getAnalysisOutput());
        Assert.assertEquals((long)0L, (long)depModule.getAnalysisOutput());
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        Assert.assertEquals((long)paramAndResult, (long)module.getAnalysisOutput());
        Assert.assertEquals((long)paramAndResult, (long)depModule.getAnalysisOutput());
        module.dispose();
        depModule.dispose();
        trace.dispose();
    }
}

