/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirement;
import org.junit.Assert;
import org.junit.Test;

public class AnalysisRequirementTest {
    private TmfAnalysisRequirement fRequirement;
    private TmfAnalysisRequirement fSubRequirement;
    private static final String TYPE_A = "Test Type A";
    private static final String TYPE_B = "Test Type B";
    private static final String VALUE_A = "Test Value A";
    private static final String VALUE_B = "Test Value B";
    private static final String VALUE_C = "Test Value C";
    private static final String VALUE_D = "Test Value D";
    private static final String VALUE_E = "Test Value E";
    private static final String VALUE_F = "Test Value F";
    private static final String INFO_A = "This is an information.";
    private static final String INFO_B = "This is another information.";
    private static final String INFO_C = "This is the last information.";

    @Test
    public void testAddAndGetInformation() {
        this.fRequirement = new TmfAnalysisRequirement(TYPE_A);
        this.fRequirement.addInformation(INFO_A);
        this.fRequirement.addInformation(INFO_B);
        this.fRequirement.addInformation(INFO_B);
        Set information = this.fRequirement.getInformation();
        Assert.assertEquals((long)2L, (long)information.size());
        Assert.assertTrue((boolean)information.contains(INFO_A));
        Assert.assertTrue((boolean)information.contains(INFO_B));
    }

    @Test
    public void testAddValuesToRequirement() {
        this.fRequirement = new TmfAnalysisRequirement(TYPE_A);
        Assert.assertEquals((long)0L, (long)this.fRequirement.getValues().size());
        ArrayList<String> values = new ArrayList<String>();
        values.add(VALUE_A);
        values.add(VALUE_B);
        values.add(VALUE_C);
        values.add(VALUE_C);
        this.fRequirement.addValues(values, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        Assert.assertEquals((long)3L, (long)this.fRequirement.getValues().size());
        this.fRequirement.addValue(VALUE_D, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        this.fRequirement.addValue(VALUE_D, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        Assert.assertEquals((long)4L, (long)this.fRequirement.getValues().size());
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY, (Object)this.fRequirement.getValueLevel(VALUE_D));
    }

    @Test
    public void testGetValueLevel() {
        this.fRequirement = new TmfAnalysisRequirement(TYPE_A);
        this.fRequirement.addValue(VALUE_A, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL, (Object)this.fRequirement.getValueLevel(VALUE_A));
        Assert.assertNull((Object)this.fRequirement.getValueLevel(VALUE_B));
    }

    @Test
    public void testMergeMandatory() {
        this.initMergeRequirements(TYPE_A, TYPE_A);
        Assert.assertTrue((boolean)this.fRequirement.merge(this.fSubRequirement, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY));
        Assert.assertEquals((long)this.fRequirement.getValues().size(), (long)6L);
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY, (Object)this.fRequirement.getValueLevel(VALUE_A));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY, (Object)this.fRequirement.getValueLevel(VALUE_B));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY, (Object)this.fRequirement.getValueLevel(VALUE_C));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL, (Object)this.fRequirement.getValueLevel(VALUE_D));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY, (Object)this.fRequirement.getValueLevel(VALUE_E));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL, (Object)this.fRequirement.getValueLevel(VALUE_F));
        Set information = this.fRequirement.getInformation();
        Assert.assertEquals((long)3L, (long)information.size());
        Assert.assertTrue((boolean)information.contains(INFO_A));
        Assert.assertTrue((boolean)information.contains(INFO_B));
        Assert.assertTrue((boolean)information.contains(INFO_C));
    }

    @Test
    public void testMergeOptional() {
        this.initMergeRequirements(TYPE_A, TYPE_A);
        Assert.assertTrue((boolean)this.fRequirement.merge(this.fSubRequirement, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL));
        Assert.assertEquals((long)6L, (long)this.fRequirement.getValues().size());
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY, (Object)this.fRequirement.getValueLevel(VALUE_A));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY, (Object)this.fRequirement.getValueLevel(VALUE_B));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL, (Object)this.fRequirement.getValueLevel(VALUE_C));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL, (Object)this.fRequirement.getValueLevel(VALUE_D));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL, (Object)this.fRequirement.getValueLevel(VALUE_E));
        Assert.assertEquals((Object)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL, (Object)this.fRequirement.getValueLevel(VALUE_F));
        Set information = this.fRequirement.getInformation();
        Assert.assertEquals((long)3L, (long)information.size());
        Assert.assertTrue((boolean)information.contains(INFO_A));
        Assert.assertTrue((boolean)information.contains(INFO_B));
        Assert.assertTrue((boolean)information.contains(INFO_C));
    }

    @Test
    public void testMergeDifferentTypes() {
        this.initMergeRequirements(TYPE_A, TYPE_B);
        Assert.assertFalse((boolean)this.fRequirement.merge(this.fSubRequirement, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL));
    }

    @Test
    public void testIsSameRequirementType() {
        this.fRequirement = new TmfAnalysisRequirement(TYPE_A);
        Assert.assertTrue((boolean)this.fRequirement.isSameType(new TmfAnalysisRequirement(TYPE_A)));
        Assert.assertFalse((boolean)this.fRequirement.isSameType(new TmfAnalysisRequirement(TYPE_B)));
    }

    private void initMergeRequirements(String typeA, String typeB) {
        this.fRequirement = new TmfAnalysisRequirement(typeA);
        this.fRequirement.addValue(VALUE_A, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        this.fRequirement.addValue(VALUE_B, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        this.fRequirement.addValue(VALUE_C, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        this.fRequirement.addValue(VALUE_D, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        this.fRequirement.addInformation(INFO_A);
        this.fRequirement.addInformation(INFO_B);
        this.fSubRequirement = new TmfAnalysisRequirement(typeB);
        this.fSubRequirement.addValue(VALUE_A, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        this.fSubRequirement.addValue(VALUE_B, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        this.fSubRequirement.addValue(VALUE_C, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        this.fSubRequirement.addValue(VALUE_D, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        this.fSubRequirement.addValue(VALUE_E, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        this.fSubRequirement.addValue(VALUE_F, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        this.fSubRequirement.addInformation(INFO_B);
        this.fSubRequirement.addInformation(INFO_C);
    }
}

