/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfSimpleTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfSimpleTimestampTest {
    private final ITmfTimestamp ts0 = new TmfSimpleTimestamp();
    private final ITmfTimestamp ts1 = new TmfSimpleTimestamp(12345L);
    private final ITmfTimestamp ts2 = new TmfSimpleTimestamp(-1234L);

    @Test
    public void testDefaultConstructor() {
        Assert.assertEquals((String)"getValue", (long)0L, (long)this.ts0.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts0.getScale());
    }

    @Test
    public void testFullConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts1.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts1.getScale());
    }

    @Test
    public void testCopyConstructor() {
        TmfSimpleTimestamp copy = new TmfSimpleTimestamp(this.ts1);
        Assert.assertEquals((String)"getValue", (long)this.ts1.getValue(), (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)this.ts1.getScale(), (long)copy.getScale());
        Assert.assertEquals((String)"getValue", (long)12345L, (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)copy.getScale());
    }

    @Test
    public void testCopyBadTimestamp() {
        try {
            new TmfSimpleTimestamp(null);
            Assert.fail((String)"TmfSimpleTimestamp: null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(this.ts0));
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(this.ts1));
        Assert.assertTrue((String)"equals", (boolean)this.ts2.equals(this.ts2));
        Assert.assertTrue((String)"equals", (!this.ts0.equals(this.ts1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts0.equals(this.ts2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(this.ts0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(this.ts2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts2.equals(this.ts0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts2.equals(this.ts1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TmfSimpleTimestamp ts0copy = new TmfSimpleTimestamp(this.ts0);
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy));
        Assert.assertTrue((String)"equals", (boolean)ts0copy.equals(this.ts0));
        TmfSimpleTimestamp ts1copy = new TmfSimpleTimestamp(this.ts1);
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy));
        Assert.assertTrue((String)"equals", (boolean)ts1copy.equals(this.ts1));
    }

    @Test
    public void testEqualsTransivity() {
        TmfSimpleTimestamp ts0copy1 = new TmfSimpleTimestamp(this.ts0);
        TmfSimpleTimestamp ts0copy2 = new TmfSimpleTimestamp((ITmfTimestamp)ts0copy1);
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy1));
        Assert.assertTrue((String)"equals", (boolean)ts0copy1.equals(ts0copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy2));
        TmfSimpleTimestamp ts1copy1 = new TmfSimpleTimestamp(this.ts1);
        TmfSimpleTimestamp ts1copy2 = new TmfSimpleTimestamp((ITmfTimestamp)ts1copy1);
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy1));
        Assert.assertTrue((String)"equals", (boolean)ts1copy1.equals(ts1copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy2));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.ts0.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsNonTimestamp() {
        Assert.assertFalse((String)"equals", (boolean)this.ts0.equals(this.ts0.toString()));
    }

    @Test
    public void testToString() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        Date d0 = new Date(this.ts0.getValue() * 1000L);
        Date d1 = new Date(this.ts1.getValue() * 1000L);
        Date d2 = new Date(this.ts2.getValue() * 1000L);
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d0)) + " 000 000"), (Object)this.ts0.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d1)) + " 000 000"), (Object)this.ts1.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d2)) + " 000 000"), (Object)this.ts2.toString());
    }

    @Test
    public void testHashCode() {
        TmfTimestamp ts0copy = new TmfTimestamp(this.ts0);
        TmfTimestamp ts1copy = new TmfTimestamp(this.ts1);
        TmfTimestamp ts2copy = new TmfTimestamp(this.ts2);
        Assert.assertTrue((String)"hashCode", (this.ts0.hashCode() == ts0copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.ts1.hashCode() == ts1copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.ts2.hashCode() == ts2copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.ts0.hashCode() != this.ts1.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testNormalizeScale0() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 0);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(12345L, 0);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(10L, 0);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(-10L, 0);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeScaleNot0() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 1);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)1L, (long)ts.getScale());
        ts = this.ts0.normalize(12345L, 1);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)1L, (long)ts.getScale());
        ts = this.ts0.normalize(10L, 1);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)1L, (long)ts.getScale());
        ts = this.ts0.normalize(-10L, 1);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)1L, (long)ts.getScale());
    }

    @Test
    public void testBasicCompareTo() {
        TmfSimpleTimestamp tstamp1 = new TmfSimpleTimestamp(900L);
        TmfSimpleTimestamp tstamp2 = new TmfSimpleTimestamp(1000L);
        TmfSimpleTimestamp tstamp3 = new TmfSimpleTimestamp(1100L);
        Assert.assertTrue((tstamp1.compareTo((ITmfTimestamp)tstamp1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp1.compareTo((ITmfTimestamp)tstamp2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp1.compareTo((ITmfTimestamp)tstamp3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp2.compareTo((ITmfTimestamp)tstamp1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp2.compareTo((ITmfTimestamp)tstamp3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp3.compareTo((ITmfTimestamp)tstamp1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp3.compareTo((ITmfTimestamp)tstamp2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        TmfTimestamp ts0a = new TmfTimestamp(0L, 2);
        TmfTimestamp ts1a = new TmfTimestamp(123450L, -1);
        TmfTimestamp ts2a = new TmfTimestamp(-12340L, -1);
        Assert.assertTrue((this.ts1.compareTo(this.ts1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts0.compareTo((ITmfTimestamp)ts0a) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts1.compareTo((ITmfTimestamp)ts1a) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts2.compareTo((ITmfTimestamp)ts2a) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDelta() {
        TmfSimpleTimestamp tstamp0 = new TmfSimpleTimestamp(10L);
        TmfSimpleTimestamp tstamp1 = new TmfSimpleTimestamp(5L);
        TmfSimpleTimestamp expectd = new TmfSimpleTimestamp(5L);
        ITmfTimestamp delta = tstamp0.getDelta((ITmfTimestamp)tstamp1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)expectd));
        tstamp0 = new TmfTimestamp(5L);
        tstamp1 = new TmfTimestamp(10L);
        expectd = new TmfTimestamp(-5L);
        delta = tstamp0.getDelta((ITmfTimestamp)tstamp1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)expectd));
    }

    @Test
    public void testDelta2() {
        TmfSimpleTimestamp tstamp0 = new TmfSimpleTimestamp(10L);
        TmfTimestamp tstamp1 = new TmfTimestamp(1L, 1);
        TmfTimestamp expectd = new TmfTimestamp(0L, 0);
        ITmfTimestamp delta = tstamp0.getDelta((ITmfTimestamp)tstamp1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)expectd));
    }
}

