/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfTimeRangeTest {
    @Test
    public void testConstructor() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        Assert.assertEquals((String)"startTime", (Object)ts1, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)ts2, (Object)range.getEndTime());
    }

    @Test
    public void testOpenRange1() {
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, (ITmfTimestamp)ts2);
        Assert.assertEquals((String)"startTime", (Object)TmfTimestamp.BIG_BANG, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)ts2, (Object)range.getEndTime());
    }

    @Test
    public void testOpenRange2() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)ts1, TmfTimestamp.BIG_CRUNCH);
        Assert.assertEquals((String)"startTime", (Object)ts1, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)range.getEndTime());
    }

    @Test
    public void testOpenRange3() {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertEquals((String)"startTime", (Object)TmfTimestamp.BIG_BANG, (Object)range.getStartTime());
        Assert.assertEquals((String)"endTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)range.getEndTime());
    }

    @Test
    public void testHashCode() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range1b = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range2 = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfTimeRange range2b = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertTrue((String)"hashCode", (range1.hashCode() == range1b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (range2.hashCode() == range2b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (range1.hashCode() != range2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range2 = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertTrue((String)"equals", (boolean)range1.equals((Object)range1));
        Assert.assertTrue((String)"equals", (boolean)range2.equals((Object)range2));
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!range2.equals((Object)range1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range1a = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range1b = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range2a = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfTimeRange range2b = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        Assert.assertTrue((String)"equals", (boolean)range1a.equals((Object)range1b));
        Assert.assertTrue((String)"equals", (boolean)range1b.equals((Object)range1a));
        Assert.assertTrue((String)"equals", (boolean)range2a.equals((Object)range2b));
        Assert.assertTrue((String)"equals", (boolean)range2b.equals((Object)range2a));
    }

    @Test
    public void testEqualsTransivity() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range1a = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range1b = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range1c = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        Assert.assertTrue((String)"equals", (boolean)range1a.equals((Object)range1b));
        Assert.assertTrue((String)"equals", (boolean)range1b.equals((Object)range1c));
        Assert.assertTrue((String)"equals", (boolean)range1a.equals((Object)range1c));
    }

    @Test
    public void testEqualsNull() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        Assert.assertTrue((String)"equals", (!range1.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsBadType() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)ts1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualStartTime() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimestamp ts3 = new TmfTimestamp(12355L);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts3);
        TmfTimeRange range2 = new TmfTimeRange((ITmfTimestamp)ts2, (ITmfTimestamp)ts3);
        TmfTimeRange range3 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range3) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsEndTime() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimestamp ts3 = new TmfTimestamp(12355L);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range2 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts3);
        TmfTimeRange range3 = new TmfTimeRange((ITmfTimestamp)ts2, (ITmfTimestamp)ts3);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!range1.equals((Object)range3) ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        String expected = "TmfTimeRange [fStartTime=" + ts1 + ", fEndTime=" + ts2 + "]";
        Assert.assertEquals((String)"toString", (Object)expected, (Object)range.toString());
    }

    @Test
    public void testContainsTimestamp() {
        TmfTimestamp ts1 = new TmfTimestamp(12345L);
        TmfTimestamp ts2 = new TmfTimestamp(12350L);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        Assert.assertTrue((String)"contains (lower bound)", (boolean)range.contains((ITmfTimestamp)new TmfTimestamp(12345L)));
        Assert.assertTrue((String)"contains (higher bound)", (boolean)range.contains((ITmfTimestamp)new TmfTimestamp(12350L)));
        Assert.assertTrue((String)"contains (within bounds)", (boolean)range.contains((ITmfTimestamp)new TmfTimestamp(12346L)));
        Assert.assertFalse((String)"contains (low value)", (boolean)range.contains((ITmfTimestamp)new TmfTimestamp(12340L)));
        Assert.assertFalse((String)"contains (high value)", (boolean)range.contains((ITmfTimestamp)new TmfTimestamp(12351L)));
    }

    @Test
    public void testContainsRange() {
        TmfTimestamp ts1 = new TmfTimestamp(10L);
        TmfTimestamp ts2 = new TmfTimestamp(20L);
        TmfTimestamp ts3 = new TmfTimestamp(30L);
        TmfTimestamp ts4 = new TmfTimestamp(40L);
        TmfTimestamp ts5 = new TmfTimestamp(50L);
        TmfTimestamp ts6 = new TmfTimestamp(60L);
        TmfTimestamp ts7 = new TmfTimestamp(70L);
        TmfTimestamp ts8 = new TmfTimestamp(80L);
        TmfTimeRange range0 = new TmfTimeRange((ITmfTimestamp)ts3, (ITmfTimestamp)ts6);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1, (ITmfTimestamp)ts2);
        TmfTimeRange range2 = new TmfTimeRange((ITmfTimestamp)ts2, (ITmfTimestamp)ts3);
        TmfTimeRange range3 = new TmfTimeRange((ITmfTimestamp)ts2, (ITmfTimestamp)ts4);
        TmfTimeRange range4 = new TmfTimeRange((ITmfTimestamp)ts2, (ITmfTimestamp)ts6);
        TmfTimeRange range5 = new TmfTimeRange((ITmfTimestamp)ts2, (ITmfTimestamp)ts7);
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range1));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range2));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range3));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range4));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range5));
        TmfTimeRange range6 = new TmfTimeRange((ITmfTimestamp)ts3, (ITmfTimestamp)ts7);
        TmfTimeRange range7 = new TmfTimeRange((ITmfTimestamp)ts4, (ITmfTimestamp)ts7);
        TmfTimeRange range8 = new TmfTimeRange((ITmfTimestamp)ts6, (ITmfTimestamp)ts7);
        TmfTimeRange range9 = new TmfTimeRange((ITmfTimestamp)ts7, (ITmfTimestamp)ts8);
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range6));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range7));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range8));
        Assert.assertFalse((String)"contains", (boolean)range0.contains(range9));
        TmfTimeRange range10 = new TmfTimeRange((ITmfTimestamp)ts3, (ITmfTimestamp)ts4);
        TmfTimeRange range11 = new TmfTimeRange((ITmfTimestamp)ts3, (ITmfTimestamp)ts6);
        TmfTimeRange range12 = new TmfTimeRange((ITmfTimestamp)ts4, (ITmfTimestamp)ts5);
        TmfTimeRange range13 = new TmfTimeRange((ITmfTimestamp)ts4, (ITmfTimestamp)ts6);
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range10));
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range11));
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range12));
        Assert.assertTrue((String)"contains", (boolean)range0.contains(range13));
    }

    @Test
    public void testGetIntersection() {
        TmfTimestamp ts1a = new TmfTimestamp(1000L);
        TmfTimestamp ts1b = new TmfTimestamp(2000L);
        TmfTimeRange range1 = new TmfTimeRange((ITmfTimestamp)ts1a, (ITmfTimestamp)ts1b);
        TmfTimestamp ts2a = new TmfTimestamp(2000L);
        TmfTimestamp ts2b = new TmfTimestamp(3000L);
        TmfTimeRange range2 = new TmfTimeRange((ITmfTimestamp)ts2a, (ITmfTimestamp)ts2b);
        TmfTimestamp ts3a = new TmfTimestamp(3000L);
        TmfTimestamp ts3b = new TmfTimestamp(4000L);
        TmfTimeRange range3 = new TmfTimeRange((ITmfTimestamp)ts3a, (ITmfTimestamp)ts3b);
        TmfTimestamp ts4a = new TmfTimestamp(1500L);
        TmfTimestamp ts4b = new TmfTimestamp(2500L);
        TmfTimeRange range4 = new TmfTimeRange((ITmfTimestamp)ts4a, (ITmfTimestamp)ts4b);
        TmfTimestamp ts5a = new TmfTimestamp(1500L);
        TmfTimestamp ts5b = new TmfTimestamp(2000L);
        TmfTimeRange range5 = new TmfTimeRange((ITmfTimestamp)ts5a, (ITmfTimestamp)ts5b);
        TmfTimestamp ts6a = new TmfTimestamp(2000L);
        TmfTimestamp ts6b = new TmfTimestamp(2500L);
        TmfTimeRange range6 = new TmfTimeRange((ITmfTimestamp)ts6a, (ITmfTimestamp)ts6b);
        TmfTimestamp ts7a = new TmfTimestamp(1500L);
        TmfTimestamp ts7b = new TmfTimestamp(3500L);
        TmfTimeRange range7 = new TmfTimeRange((ITmfTimestamp)ts7a, (ITmfTimestamp)ts7b);
        TmfTimestamp ts8a = new TmfTimestamp(2250L);
        TmfTimestamp ts8b = new TmfTimestamp(2750L);
        TmfTimeRange range8 = new TmfTimeRange((ITmfTimestamp)ts8a, (ITmfTimestamp)ts8b);
        Assert.assertEquals((String)"getIntersection (below - not contiguous)", null, (Object)range1.getIntersection(range3));
        Assert.assertEquals((String)"getIntersection (above - not contiguous)", null, (Object)range3.getIntersection(range1));
        Assert.assertEquals((String)"getIntersection (below - contiguous)", (Object)new TmfTimeRange((ITmfTimestamp)ts1b, (ITmfTimestamp)ts1b), (Object)range1.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (above - contiguous)", (Object)new TmfTimeRange((ITmfTimestamp)ts3a, (ITmfTimestamp)ts3a), (Object)range3.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (below - overlap)", (Object)new TmfTimeRange((ITmfTimestamp)ts2a, (ITmfTimestamp)ts4b), (Object)range2.getIntersection(range4));
        Assert.assertEquals((String)"getIntersection (above - overlap)", (Object)new TmfTimeRange((ITmfTimestamp)ts2a, (ITmfTimestamp)ts4b), (Object)range4.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (within - overlap1)", (Object)range6, (Object)range2.getIntersection(range6));
        Assert.assertEquals((String)"getIntersection (within - overlap2)", (Object)range6, (Object)range6.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (within - overlap3)", (Object)range5, (Object)range1.getIntersection(range5));
        Assert.assertEquals((String)"getIntersection (within - overlap4)", (Object)range5, (Object)range5.getIntersection(range1));
        Assert.assertEquals((String)"getIntersection (within - overlap5)", (Object)range8, (Object)range2.getIntersection(range8));
        Assert.assertEquals((String)"getIntersection (within - overlap6)", (Object)range8, (Object)range8.getIntersection(range2));
        Assert.assertEquals((String)"getIntersection (accross1)", (Object)range2, (Object)range2.getIntersection(range7));
        Assert.assertEquals((String)"getIntersection (accross2)", (Object)range2, (Object)range7.getIntersection(range2));
    }
}

