/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.junit.Assert;
import org.junit.Test;

public class TmfTimestampDeltaTest {
    private final ITmfTimestamp ts0 = new TmfTimestampDelta();
    private final ITmfTimestamp ts1 = new TmfTimestampDelta(12345L, 0);
    private final ITmfTimestamp ts2 = new TmfTimestampDelta(12345L, -1);
    private final ITmfTimestamp ts3 = new TmfTimestampDelta(12345L, 2);
    private final ITmfTimestamp ts4 = new TmfTimestampDelta(-12345L, -5);

    @Test
    public void testDefaultConstructor() {
        Assert.assertEquals((String)"getValue", (long)0L, (long)this.ts0.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts0.getScale());
    }

    @Test
    public void testValueConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts1.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts1.getScale());
    }

    @Test
    public void testValueScaleConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts2.getValue());
        Assert.assertEquals((String)"getscale", (long)-1L, (long)this.ts2.getScale());
    }

    @Test
    public void testFullConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts3.getValue());
        Assert.assertEquals((String)"getscale", (long)2L, (long)this.ts3.getScale());
        Assert.assertEquals((String)"getValue", (long)-12345L, (long)this.ts4.getValue());
        Assert.assertEquals((String)"getscale", (long)-5L, (long)this.ts4.getScale());
    }

    @Test
    public void testCopyConstructor() {
        TmfTimestamp ts = new TmfTimestamp(12345L, 2);
        TmfTimestamp copy = new TmfTimestamp((ITmfTimestamp)ts);
        Assert.assertEquals((String)"getValue", (long)ts.getValue(), (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)ts.getScale(), (long)copy.getScale());
        Assert.assertEquals((String)"getValue", (long)12345L, (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)2L, (long)copy.getScale());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCopyNullConstructor() {
        new TmfTimestamp(null);
    }

    @Test
    public void testNormalizeOffset() {
        ITmfTimestamp ts = this.ts0.normalize(12345L, 0);
        Assert.assertTrue((String)"instance", (boolean)(ts instanceof TmfTimestampDelta));
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testToStringDefault() {
        Assert.assertEquals((String)"toString", (Object)"000.000 000 000", (Object)this.ts0.toString());
        Assert.assertEquals((String)"toString", (Object)"12345.000 000 000", (Object)this.ts1.toString());
        Assert.assertEquals((String)"toString", (Object)"1234.500 000 000", (Object)this.ts2.toString());
        Assert.assertEquals((String)"toString", (Object)"1234500.000 000 000", (Object)this.ts3.toString());
        Assert.assertEquals((String)"toString", (Object)"-000.123 450 000", (Object)this.ts4.toString());
    }

    @Test
    public void testToStringFormat() {
        TmfTimestampFormat format = new TmfTimestampFormat("HH:mm:ss.SSS CCC NNN");
        Assert.assertEquals((String)"toString", (Object)"00:00:00.000 000 000", (Object)this.ts0.toString(format));
        Assert.assertEquals((String)"toString", (Object)"03:25:45.000 000 000", (Object)this.ts1.toString(format));
        Assert.assertEquals((String)"toString", (Object)"00:20:34.500 000 000", (Object)this.ts2.toString(format));
        Assert.assertEquals((String)"toString", (Object)"06:55:00.000 000 000", (Object)this.ts3.toString(format));
        Assert.assertEquals((String)"toString", (Object)"-00:00:00.123 450 000", (Object)this.ts4.toString(format));
    }
}

