/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event.lookup;

import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.junit.Assert;
import org.junit.Test;

public class TmfCallsiteTest {
    private static final String fFileName1 = "filename1";
    private static final String fFunctionName1 = "func1";
    private static final long fLine1 = 10L;
    private static final String fFileName2 = "filename2";
    private static final String fFunctionName2 = "func2";
    private static final long fLine2 = 25L;
    private static final String fFileName3 = "filename3";
    private static final String fFunctionName3 = null;
    private static final long fLine3 = 123L;
    private static final ITmfCallsite fCallsite1 = new TmfCallsite("filename1", "func1", 10L);
    private static final ITmfCallsite fCallsite2 = new TmfCallsite("filename2", "func2", 25L);
    private static final ITmfCallsite fCallsite3 = new TmfCallsite("filename3", fFunctionName3, 123L);

    @Test
    public void testDefaultConstructor() {
        Assert.assertEquals((Object)fFileName1, (Object)fCallsite1.getFileName());
        Assert.assertEquals((Object)fFunctionName1, (Object)fCallsite1.getFunctionName());
        Assert.assertEquals((long)10L, (long)fCallsite1.getLineNumber());
    }

    @Test
    public void testCallsiteCopy() {
        TmfCallsite copy = new TmfCallsite(fCallsite1);
        Assert.assertEquals((Object)fFileName1, (Object)copy.getFileName());
        Assert.assertEquals((Object)fFunctionName1, (Object)copy.getFunctionName());
        Assert.assertEquals((long)10L, (long)copy.getLineNumber());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCallsiteCopy2() {
        new TmfCallsite(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCallsiteCopy3() {
        new TmfCallsite(new ITmfCallsite(){

            public long getLineNumber() {
                return 0L;
            }

            public String getFunctionName() {
                return null;
            }

            public String getFileName() {
                return null;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCallsiteFileNull() {
        new TmfCallsite(null, fFunctionName1, 10L);
    }

    @Test
    public void testHashCode() {
        TmfCallsite callsite1b = new TmfCallsite(fCallsite1);
        TmfCallsite callsite2b = new TmfCallsite(fCallsite2);
        Assert.assertTrue((String)"hashCode", (fCallsite1.hashCode() == callsite1b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (fCallsite2.hashCode() == callsite2b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (fCallsite1.hashCode() != fCallsite2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (fCallsite2.hashCode() != fCallsite1.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)fCallsite1.equals(fCallsite1));
        Assert.assertTrue((String)"equals", (boolean)fCallsite2.equals(fCallsite2));
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(fCallsite2));
        Assert.assertFalse((String)"equals", (boolean)fCallsite2.equals(fCallsite1));
    }

    @Test
    public void testEqualsSymmetry() {
        TmfCallsite callsite1 = new TmfCallsite(fCallsite1);
        TmfCallsite callsite2 = new TmfCallsite(fCallsite2);
        Assert.assertTrue((String)"equals", (boolean)callsite1.equals(fCallsite1));
        Assert.assertTrue((String)"equals", (boolean)fCallsite1.equals(callsite1));
        Assert.assertTrue((String)"equals", (boolean)callsite2.equals(fCallsite2));
        Assert.assertTrue((String)"equals", (boolean)fCallsite2.equals(callsite2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfCallsite callsite1 = new TmfCallsite(fCallsite1);
        TmfCallsite callsite2 = new TmfCallsite(fCallsite1);
        TmfCallsite callsite3 = new TmfCallsite(fCallsite1);
        Assert.assertTrue((String)"equals", (boolean)callsite1.equals(callsite2));
        Assert.assertTrue((String)"equals", (boolean)callsite2.equals(callsite3));
        Assert.assertTrue((String)"equals", (boolean)callsite1.equals(callsite3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(null));
        Assert.assertFalse((String)"equals", (boolean)fCallsite2.equals(null));
        Assert.assertFalse((String)"equals", (boolean)fCallsite3.equals(null));
    }

    @Test
    public void testNonEqualClasses() {
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(fCallsite1.getFileName()));
    }

    @Test
    public void testNullElements() {
        TmfCallsite callsite = new TmfCallsite(fFileName1, null, 10L);
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(callsite));
        Assert.assertFalse((String)"equals", (boolean)callsite.equals(fCallsite1));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)"toString", (Object)"filename1:10 func1()", (Object)fCallsite1.toString());
        Assert.assertEquals((String)"toString", (Object)"filename2:25 func2()", (Object)fCallsite2.toString());
        Assert.assertEquals((String)"toString", (Object)"filename3:123", (Object)fCallsite3.toString());
    }
}

