/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter;

import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.tests.filter.TmfFilterTreeNodeTest;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfFilterMatchesNodeTest
extends TmfFilterTreeNodeTest {
    private ITmfEventField[] fFields1 = new ITmfEventField[]{new TmfEventField("field", (Object)"value 1", null)};
    private ITmfEventField[] fFields2 = new ITmfEventField[]{new TmfEventField("field", (Object)"value 2", null)};
    private ITmfEventField fContent1 = new TmfEventField(":root:", null, this.fFields1);
    private ITmfEventField fContent2 = new TmfEventField(":root:", null, this.fFields2);
    private TmfEvent fEvent1 = new TmfEvent(TRACE, 0L, (ITmfTimestamp)new TmfNanoTimestamp(1L), EVENT_TYPE, this.fContent1);
    private TmfEvent fEvent2 = new TmfEvent(TRACE, 1L, (ITmfTimestamp)new TmfNanoTimestamp(2L), EVENT_TYPE, this.fContent2);
    private TmfFilterMatchesNode fFilter;

    @Before
    public void createFilter() {
        this.fFilter = new TmfFilterMatchesNode(null);
        this.fFilterNode = this.fFilter;
    }

    @Test
    public void testMatches() {
        this.fFilter.setEventAspect((ITmfEventAspect)new TmfContentFieldAspect("field", new String[]{"field"}));
        this.fFilter.setRegex("value");
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        this.fFilter.setRegex(".*value.*");
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        this.fFilter.setRegex("^value");
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        this.fFilter.setRegex("value$");
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        this.fFilter.setRegex(".* 1");
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        this.fFilter.setNot(true);
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((String)"getName()", (Object)"MATCHES", (Object)this.fFilter.getNodeName());
    }

    @Test
    public void testGetValidChildren() {
        Assert.assertArrayEquals((String)"getValidChildren()", (Object[])new String[0], (Object[])this.fFilter.getValidChildren().toArray());
    }
}

