/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.synchronization;

import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinear;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinearFast;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.junit.Assert;
import org.junit.Test;

public class TsTransformFastTest {
    private static final long ts = 1361657893526374091L;

    @Test
    public void testFLTRepeatability() {
        TmfTimestampTransformLinearFast fast = new TmfTimestampTransformLinearFast(Math.PI, 0.0);
        long deltaMax = fast.getDeltaMax();
        long timestamp = 1361657893526374091L - 1361657893526374091L % deltaMax;
        fast.transform(timestamp);
        long tsMiss = timestamp + deltaMax;
        long tsNoMiss = timestamp + deltaMax - 1L;
        long tsTNoMiss = fast.transform(tsNoMiss);
        Assert.assertEquals((long)1L, (long)fast.getCacheMisses());
        fast.transform(tsMiss);
        Assert.assertEquals((long)2L, (long)fast.getCacheMisses());
        long tsTAfterMiss = fast.transform(tsNoMiss);
        Assert.assertEquals((long)tsTNoMiss, (long)tsTAfterMiss);
    }

    @Test
    public void testFLTEquivalence() {
        TmfTimestampTransformLinearFast fast = new TmfTimestampTransformLinearFast(Math.PI, 0.0);
        TmfTimestampTransformLinearFast fast2 = new TmfTimestampTransformLinearFast(Math.PI, 0.0);
        long deltaMax = fast.getDeltaMax();
        long start = 1361657893526374091L - 1361657893526374091L % deltaMax - 10L;
        TsTransformFastTest.checkTime((ITmfTimestampTransform)fast, (ITmfTimestampTransform)fast2, 20, start, 1L);
    }

    @Test
    public void testFastTransformPrecision() {
        int[] directions;
        TmfTimestampTransformLinear precise = new TmfTimestampTransformLinear(Math.PI, 0.0);
        TmfTimestampTransformLinearFast fast = new TmfTimestampTransformLinearFast(Math.PI, 0.0);
        int samples = 100;
        long start = (long)Math.pow(10.0, 18.0);
        long end = Long.MAX_VALUE;
        int step = (int)((double)(end - start) / ((double)samples * Math.PI));
        TsTransformFastTest.checkTime((ITmfTimestampTransform)precise, (ITmfTimestampTransform)fast, samples, start, step);
        Assert.assertEquals((long)samples, (long)fast.getCacheMisses());
        samples = 1000;
        int[] nArray = directions = new int[]{1, -1};
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer direction = nArray[n2];
            int i = 0;
            while (i <= 30) {
                fast.resetScaleStats();
                step = (1 << i) * direction;
                TsTransformFastTest.checkTime((ITmfTimestampTransform)precise, (ITmfTimestampTransform)fast, samples, start, step);
                Assert.assertTrue((String)String.format("samples: %d scale misses: %d", samples, fast.getCacheMisses()), ((long)samples >= fast.getCacheMisses() ? 1 : 0) != 0);
                ++i;
            }
            ++n2;
        }
    }

    @Test
    public void testFastTransformSlope() {
        int[] dir = new int[]{1, -1};
        long start = 0x40000000L;
        int ex = -9;
        while (ex <= 9) {
            int d = 0;
            while (d < dir.length) {
                double slope = Math.pow(10.0, ex);
                TmfTimestampTransformLinear precise = new TmfTimestampTransformLinear(slope, 0.0);
                TmfTimestampTransformLinearFast fast = new TmfTimestampTransformLinearFast(slope, 0.0);
                TsTransformFastTest.checkTime((ITmfTimestampTransform)precise, (ITmfTimestampTransform)fast, 1000, start, dir[d]);
                ++d;
            }
            ++ex;
        }
    }

    @Test
    public void testFastTransformArguments() {
        double[] slopes;
        double[] dArray = slopes = new double[]{-1.0, 2.147483648E9, 1.0E-10};
        int n = slopes.length;
        int n2 = 0;
        while (n2 < n) {
            double slope = dArray[n2];
            IllegalArgumentException exception = null;
            try {
                new TmfTimestampTransformLinearFast(slope, 0.0);
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            Assert.assertNotNull((Object)exception);
            ++n2;
        }
    }

    private static void checkTime(ITmfTimestampTransform precise, ITmfTimestampTransform fast, int samples, long start, long step) {
        long prev = 0L;
        int i = 0;
        while (i < samples) {
            long time = start + (long)i * step;
            long exp = precise.transform(time);
            long act = fast.transform(time);
            long err = act - exp;
            Assert.assertTrue((String)("[" + err + "]"), (Math.abs(err) < 3L ? 1 : 0) != 0);
            if (i > 0) {
                if (step > 0L) {
                    Assert.assertTrue((String)("monotonic error" + act + " " + prev), (act >= prev ? 1 : 0) != 0);
                } else if (step < 0L) {
                    Assert.assertTrue((String)"monotonic ", (act <= prev ? 1 : 0) != 0);
                }
            }
            prev = act;
            ++i;
        }
    }
}

