/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace;

import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperimentUtils;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis2;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfExperimentUtilsTest {
    private static final String EXPERIMENT = "MyExperiment";
    private static int BLOCK_SIZE = 1000;
    private TmfExperimentStub fExperiment;
    private ITmfTrace[] fTraces;

    @Before
    public void setupExperiment() {
        this.fTraces = new ITmfTrace[2];
        this.fTraces[0] = TmfTestTrace.A_TEST_10K.getTrace();
        this.fTraces[1] = TmfTestTrace.A_TEST_10K2.getTraceAsStub2();
        TmfSignalManager.register((Object)this.fTraces[1]);
        this.fExperiment = new TmfExperimentStub(EXPERIMENT, this.fTraces, BLOCK_SIZE);
        this.fExperiment.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, true);
        this.fExperiment.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)this.fExperiment, null));
    }

    @After
    public void cleanUp() {
        this.fExperiment.dispose();
    }

    @Test
    public void testGetModuleById() {
        String commonModule = "org.eclipse.linuxtools.tmf.core.tests.analysis.test";
        String notCommonModule = "org.eclipse.linuxtools.tmf.core.tests.analysis.testother";
        String host1 = TmfTestTrace.A_TEST_10K.getPath();
        String host2 = TmfTestTrace.A_TEST_10K2.getPath();
        TmfExperimentStub experiment = this.fExperiment;
        Assert.assertNotNull((Object)((Object)experiment));
        IAnalysisModule module = TmfExperimentUtils.getAnalysisModuleForHost((TmfExperiment)experiment, (String)host1, (String)commonModule);
        Assert.assertNotNull((Object)module);
        IAnalysisModule traceModule = this.fTraces[0].getAnalysisModule(commonModule);
        Assert.assertNotNull((Object)traceModule);
        Assert.assertEquals((Object)module, (Object)traceModule);
        Assert.assertNull((Object)TmfExperimentUtils.getAnalysisModuleForHost((TmfExperiment)experiment, (String)host1, (String)notCommonModule));
        traceModule = this.fTraces[0].getAnalysisModule(notCommonModule);
        Assert.assertNull((Object)traceModule);
        module = TmfExperimentUtils.getAnalysisModuleForHost((TmfExperiment)experiment, (String)host2, (String)commonModule);
        Assert.assertNotNull((Object)module);
        traceModule = this.fTraces[1].getAnalysisModule(commonModule);
        Assert.assertNotNull((Object)traceModule);
        Assert.assertEquals((Object)module, (Object)traceModule);
        module = TmfExperimentUtils.getAnalysisModuleForHost((TmfExperiment)experiment, (String)host2, (String)notCommonModule);
        Assert.assertNotNull((Object)module);
        traceModule = this.fTraces[1].getAnalysisModule(notCommonModule);
        Assert.assertNotNull((Object)traceModule);
        Assert.assertEquals((Object)module, (Object)traceModule);
    }

    @Test
    public void testGetModuleByClass() {
        Class<TestAnalysis> commonClass = TestAnalysis.class;
        Class<TestAnalysis2> notCommonClass = TestAnalysis2.class;
        String host1 = TmfTestTrace.A_TEST_10K.getPath();
        String host2 = TmfTestTrace.A_TEST_10K2.getPath();
        TmfExperimentStub experiment = this.fExperiment;
        Assert.assertNotNull((Object)((Object)experiment));
        TestAnalysis module1 = (TestAnalysis)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)experiment, (String)host1, commonClass);
        Assert.assertNotNull((Object)((Object)module1));
        IAnalysisModule sameModule = null;
        for (IAnalysisModule mod : this.fTraces[0].getAnalysisModules()) {
            if (mod != module1) continue;
            sameModule = mod;
        }
        Assert.assertNotNull(sameModule);
        TestAnalysis2 module2 = (TestAnalysis2)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)experiment, (String)host1, notCommonClass);
        Assert.assertNull((Object)((Object)module2));
        module1 = (TestAnalysis)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)experiment, (String)host2, commonClass);
        Assert.assertNotNull((Object)((Object)module1));
        sameModule = null;
        for (IAnalysisModule mod : this.fTraces[1].getAnalysisModules()) {
            if (mod != module1) continue;
            sameModule = mod;
        }
        Assert.assertNotNull((Object)sameModule);
        module2 = (TestAnalysis2)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)experiment, (String)host2, notCommonClass);
        Assert.assertNotNull((Object)((Object)module2));
        sameModule = null;
        for (IAnalysisModule mod : this.fTraces[1].getAnalysisModules()) {
            if (mod != module1) continue;
            sameModule = mod;
        }
        Assert.assertNotNull((Object)sameModule);
    }
}

