/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.core.trace.experiment.TmfExperimentContext;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TmfMultiTraceExperimentTest {
    private static final long DEFAULT_INITIAL_OFFSET_VALUE = 100000000L;
    private static final String EXPERIMENT = "MyExperiment";
    private static int NB_EVENTS = 20000;
    private static int BLOCK_SIZE = 1000;
    private static TmfExperimentStub fExperiment;
    private static byte SCALE;

    static {
        SCALE = (byte)-3;
    }

    @BeforeClass
    public static void setUp() {
        ITmfTrace[] traces = TmfMultiTraceExperimentTest.setupTraces();
        fExperiment = new TmfExperimentStub(EXPERIMENT, traces, BLOCK_SIZE);
        fExperiment.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, true);
    }

    @AfterClass
    public static void tearDown() {
        fExperiment.dispose();
    }

    private static ITmfTrace[] setupTraces() {
        try {
            ITmfTrace[] traces = new ITmfTrace[2];
            URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TmfTestTrace.O_TEST_10K.getFullPath()), null);
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            TmfTraceStub trace1 = new TmfTraceStub(test.getPath(), 0, true, null);
            traces[0] = trace1;
            location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TmfTestTrace.E_TEST_10K.getFullPath()), null);
            test = new File(FileLocator.toFileURL((URL)location).toURI());
            TmfTraceStub trace2 = new TmfTraceStub(test.getPath(), 0, true, null);
            traces[1] = trace2;
            return traces;
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ITmfTrace[0];
    }

    @Test
    public void testBasicTmfExperimentConstructor() {
        Assert.assertEquals((String)"GetId", (Object)EXPERIMENT, (Object)fExperiment.getName());
        Assert.assertEquals((String)"GetNbEvents", (long)NB_EVENTS, (long)fExperiment.getNbEvents());
        TmfTimeRange timeRange = fExperiment.getTimeRange();
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)timeRange.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)NB_EVENTS, (long)timeRange.getEndTime().getValue());
        TmfTimestamp initRange = new TmfTimestamp(100000000L, -9);
        Assert.assertEquals((String)"getInitialRangeOffset", (Object)initRange, (Object)fExperiment.getInitialRangeOffset());
    }

    @Test
    public void testSeekRankOnCacheBoundary() {
        long cacheSize = fExperiment.getCacheSize();
        ITmfContext context = fExperiment.seekEvent(0L);
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        context = fExperiment.seekEvent(cacheSize);
        Assert.assertEquals((String)"Context rank", (long)cacheSize, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 1L), (long)context.getRank());
        context = fExperiment.seekEvent(4L * cacheSize);
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize), (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize + 1L), (long)context.getRank());
    }

    @Test
    public void testSeekRankNotOnCacheBoundary() {
        long cacheSize = fExperiment.getCacheSize();
        ITmfContext context = fExperiment.seekEvent(9L);
        Assert.assertEquals((String)"Context rank", (long)9L, (long)context.getRank());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)10L, (long)context.getRank());
        context = fExperiment.seekEvent(cacheSize - 1L);
        Assert.assertEquals((String)"Context rank", (long)(cacheSize - 1L), (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)cacheSize, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)cacheSize, (long)context.getRank());
        context = fExperiment.seekEvent(cacheSize + 1L);
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 1L), (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 2L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 2L), (long)context.getRank());
        context = fExperiment.seekEvent(4500L);
        Assert.assertEquals((String)"Context rank", (long)4500L, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)4501L, (long)context.getRank());
    }

    @Test
    public void testSeekRankOutOfScope() {
        ITmfContext context = fExperiment.seekEvent(-1L);
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        context = fExperiment.seekEvent(NB_EVENTS);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertNull((String)"Event", (Object)event);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
    }

    @Test
    public void testSeekTimestampOnCacheBoundary() {
        long cacheSize = fExperiment.getCacheSize();
        ITmfContext context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(cacheSize + 1L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)cacheSize, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 1L), (long)context.getRank());
        context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(4L * cacheSize + 1L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize), (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize + 1L), (long)context.getRank());
    }

    @Test
    public void testSeekTimestampNotOnCacheBoundary() {
        ITmfContext context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(2L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)2L, (long)context.getRank());
        context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(10L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)9L, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)10L, (long)context.getRank());
        context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1000L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)999L, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1000L, (long)context.getRank());
        context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1002L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)1001L, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1002L, (long)context.getRank());
        context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(4501L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)4500L, (long)context.getRank());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)4501L, (long)context.getRank());
    }

    @Test
    public void testSeekTimestampOutOfScope() {
        ITmfContext context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(-1L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp((long)(NB_EVENTS + 1), (int)SCALE));
        event = fExperiment.getNext(context);
        Assert.assertNull((String)"Event location", (Object)event);
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
    }

    @Test
    public void testSeekLocationOnCacheBoundary() {
        long cacheSize = fExperiment.getCacheSize();
        ITmfContext tmpContext = fExperiment.seekEvent(0L);
        ITmfContext context = fExperiment.seekEvent(tmpContext.getLocation());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        tmpContext = fExperiment.seekEvent(cacheSize);
        context = fExperiment.seekEvent(tmpContext.getLocation());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 2L), (long)event.getTimestamp().getValue());
        tmpContext = fExperiment.seekEvent(4L * cacheSize);
        context = fExperiment.seekEvent(tmpContext.getLocation());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 2L), (long)event.getTimestamp().getValue());
    }

    @Test
    public void testSeekLocationNotOnCacheBoundary() {
        long cacheSize = fExperiment.getCacheSize();
        ITmfContext tmpContext = fExperiment.seekEvent(cacheSize - 1L);
        ITmfContext context = fExperiment.seekEvent(tmpContext.getLocation());
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)cacheSize, (long)event.getTimestamp().getValue());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        tmpContext = fExperiment.seekEvent(2L * cacheSize - 1L);
        context = fExperiment.seekEvent(tmpContext.getLocation());
        context = fExperiment.seekEvent(2L * cacheSize - 1L);
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(2L * cacheSize), (long)event.getTimestamp().getValue());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(2L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        tmpContext = fExperiment.seekEvent(4500L);
        context = fExperiment.seekEvent(tmpContext.getLocation());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4502L, (long)event.getTimestamp().getValue());
    }

    @Test
    public void testSeekLocationOutOfScope() {
        ITmfContext context = fExperiment.seekEvent(null);
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
    }

    private static void validateContextRanks(ITmfContext context) {
        Assert.assertTrue((String)"Experiment context type", (boolean)(context instanceof TmfExperimentContext));
        TmfExperimentContext ctx = (TmfExperimentContext)context;
        int nbTraces = ctx.getNbTraces();
        long expRank = -nbTraces + (ctx.getLastTrace() != -1 ? 1 : 0);
        int i = 0;
        while (i < nbTraces) {
            ITmfContext subContext = ctx.getContext(i);
            Assert.assertNotNull((Object)subContext);
            long rank = subContext.getRank();
            if (rank == -1L) {
                expRank = -1L;
                break;
            }
            expRank += rank;
            ++i;
        }
        Assert.assertEquals((String)"Experiment context rank", (long)expRank, (long)ctx.getRank());
    }

    @Test
    public void testGetNextAfteSeekingOnTS_1() {
        ITmfEvent event;
        long INITIAL_TS = 1L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1L, (int)SCALE));
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i), (long)context.getRank());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfteSeekingOnTS_2() {
        ITmfEvent event;
        long INITIAL_TS = 2L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(2L, (int)SCALE));
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(2L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(2L + (long)i), (long)context.getRank());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)21L, (long)context.getRank());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfteSeekingOnTS_3() {
        ITmfEvent event;
        long INITIAL_TS = 500L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(500L, (int)SCALE));
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(500L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(500L + (long)i), (long)context.getRank());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)520L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)519L, (long)context.getRank());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnRank_1() {
        ITmfEvent event;
        long INITIAL_RANK = 0L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent(0L);
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(0L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(0L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnRank_2() {
        ITmfEvent event;
        long INITIAL_RANK = 1L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent(1L);
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)21L, (long)context.getRank());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnRank_3() {
        ITmfEvent event;
        long INITIAL_RANK = 500L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent(500L);
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(500L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(500L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)521L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)520L, (long)context.getRank());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_1() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = null;
        long INITIAL_TS = 1L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent(INITIAL_LOC);
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i), (long)context.getRank());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_2() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = fExperiment.seekEvent(1L).getLocation();
        long INITIAL_TS = 2L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent(INITIAL_LOC);
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(2L + (long)i), (long)event.getTimestamp().getValue());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_3() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = fExperiment.seekEvent(500L).getLocation();
        long INITIAL_TS = 501L;
        int NB_READS = 20;
        ITmfContext context = fExperiment.seekEvent(INITIAL_LOC);
        TmfMultiTraceExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(501L + (long)i), (long)event.getTimestamp().getValue());
            ++i;
        }
        event = fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)521L, (long)event.getTimestamp().getValue());
        TmfMultiTraceExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextLocation() {
        ITmfContext context1 = fExperiment.seekEvent(0L);
        fExperiment.getNext(context1);
        ITmfLocation location = context1.getLocation();
        ITmfEvent event1 = fExperiment.getNext(context1);
        ITmfContext context2 = fExperiment.seekEvent(location);
        ITmfEvent event2 = fExperiment.getNext(context2);
        Assert.assertEquals((String)"Event timestamp", (long)event1.getTimestamp().getValue(), (long)event2.getTimestamp().getValue());
    }

    @Test
    public void testGetNextEndLocation() {
        ITmfContext context1 = fExperiment.seekEvent(fExperiment.getNbEvents() - 1L);
        fExperiment.getNext(context1);
        ITmfLocation location = context1.getLocation();
        ITmfContext context2 = fExperiment.seekEvent(location);
        ITmfEvent event = fExperiment.getNext(context2);
        Assert.assertNull((String)"Event", (Object)event);
    }

    @Test
    public void testProcessRequestForNbEvents() throws InterruptedException {
        int nbEvents = 1000;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        fExperiment.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)1000L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < 1000) {
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testProcessRequestForAllEvents() throws InterruptedException {
        int nbEvents = Integer.MAX_VALUE;
        final Vector requestedEvents = new Vector();
        long nbExpectedEvents = NB_EVENTS;
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        fExperiment.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)nbExpectedEvents, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while ((long)i < nbExpectedEvents) {
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testCancel() throws InterruptedException {
        int nbEvents = NB_EVENTS;
        final int limit = BLOCK_SIZE;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, nbEvents, ITmfEventRequest.ExecutionType.FOREGROUND){
            int nbRead;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                this.nbRead = 0;
            }

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
                if (++this.nbRead == limit) {
                    this.cancel();
                }
            }
        };
        fExperiment.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)limit, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertTrue((String)"isCancelled", (boolean)request.isCancelled());
    }

    @Test
    public void testGetTimestamp() {
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(1L, -3), (Object)fExperiment.getTimestamp(0));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(2L, -3), (Object)fExperiment.getTimestamp(1));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(11L, -3), (Object)fExperiment.getTimestamp(10));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(101L, -3), (Object)fExperiment.getTimestamp(100));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(1001L, -3), (Object)fExperiment.getTimestamp(1000));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(2001L, -3), (Object)fExperiment.getTimestamp(2000));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(2501L, -3), (Object)fExperiment.getTimestamp(2500));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(10000L, -3), (Object)fExperiment.getTimestamp(9999));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(20000L, -3), (Object)fExperiment.getTimestamp(19999));
        Assert.assertNull((String)"getTimestamp", (Object)fExperiment.getTimestamp(20000));
    }

    @Test
    public void testDefaultCurrentTimeValues() {
        ITmfTrace[] traces = TmfMultiTraceExperimentTest.setupTraces();
        TmfExperimentStub exp = new TmfExperimentStub(EXPERIMENT, traces, BLOCK_SIZE);
        TmfTimestamp initRange = new TmfTimestamp(100000000L, -9);
        Assert.assertEquals((String)"getInitialRangeOffset", (Object)initRange, (Object)exp.getInitialRangeOffset());
        exp.dispose();
    }

    @Test
    public void testInitialRangeOffset() {
        ITmfTrace[] traces = TmfMultiTraceExperimentTest.setupTraces();
        ((TmfTraceStub)traces[0]).setInitialRangeOffset((ITmfTimestamp)new TmfTimestamp(5L, -3));
        ((TmfTraceStub)traces[1]).setInitialRangeOffset((ITmfTimestamp)new TmfTimestamp(2L, -3));
        TmfExperimentStub exp = new TmfExperimentStub(EXPERIMENT, traces, BLOCK_SIZE);
        TmfTimestamp initRange = new TmfTimestamp(2L, -3);
        Assert.assertEquals((String)"getInitialRangeOffset", (Object)initRange, (Object)exp.getInitialRangeOffset());
        exp.dispose();
    }
}

