/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Random;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.ICheckpointCollection;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCheckpointCollectionTest {
    private static final String INDEX_FILE_NAME = "checkpoint.idx";
    protected static final int CHECKPOINTS_INSERT_NUM = 50000;
    protected ICheckpointCollection fCheckpointCollection = null;
    private TmfTraceStub fTrace;
    private File fFile = new File("checkpoint.idx");

    @Before
    public void setUp() {
        this.fTrace = new TmfTraceStub();
        if (this.fFile.exists()) {
            this.fFile.delete();
        }
        this.fCheckpointCollection = this.createCollection();
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
        this.fTrace = null;
        if (this.fCheckpointCollection != null) {
            this.fCheckpointCollection.dispose();
        }
        if (this.fFile.exists()) {
            this.fFile.delete();
        }
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public boolean isPersistableCollection() {
        return false;
    }

    public File getFile() {
        return this.fFile;
    }

    @Test
    public void testConstructor() {
        if (this.isPersistableCollection()) {
            Assert.assertTrue((boolean)this.fFile.exists());
        }
        Assert.assertTrue((boolean)this.fCheckpointCollection.isCreatedFromScratch());
    }

    @Test
    public void testConstructorExistingFile() {
        if (this.isPersistableCollection()) {
            Assert.assertTrue((boolean)this.fFile.exists());
            this.fCheckpointCollection.setIndexComplete();
            this.fCheckpointCollection.dispose();
            this.fCheckpointCollection = this.createCollection();
            Assert.assertFalse((boolean)this.fCheckpointCollection.isCreatedFromScratch());
        }
    }

    @Test
    public void testIsCreatedFromScratch() {
        Assert.assertTrue((boolean)this.fCheckpointCollection.isCreatedFromScratch());
        this.fCheckpointCollection.setIndexComplete();
        if (this.isPersistableCollection()) {
            this.fCheckpointCollection.dispose();
            this.fCheckpointCollection = this.createCollection();
            Assert.assertFalse((boolean)this.fCheckpointCollection.isCreatedFromScratch());
        }
    }

    @Test
    public void testSetGetTimeRange() {
        if (this.isPersistableCollection()) {
            TmfTimeRange timeRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(0L), (ITmfTimestamp)new TmfTimestamp(100L));
            this.fCheckpointCollection.setTimeRange(timeRange);
            Assert.assertEquals((Object)timeRange, (Object)this.fCheckpointCollection.getTimeRange());
        }
    }

    protected abstract ICheckpointCollection createCollection();

    @Test
    public void testSetGetNbEvents() {
        if (this.isPersistableCollection()) {
            int expected = 12345;
            this.fCheckpointCollection.setNbEvents((long)expected);
            Assert.assertEquals((long)expected, (long)this.fCheckpointCollection.getNbEvents());
        }
    }

    @Test
    public void testSetGetSize() {
        Assert.assertEquals((long)0L, (long)this.fCheckpointCollection.size());
        int expected = 50000;
        int i = 0;
        while (i < expected) {
            this.fCheckpointCollection.insert((ITmfCheckpoint)new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(0L), (ITmfLocation)new TmfLongLocation(0L), 0L));
            ++i;
        }
        Assert.assertEquals((long)expected, (long)this.fCheckpointCollection.size());
    }

    @Test
    public void testDelete() {
        if (this.isPersistableCollection()) {
            Assert.assertTrue((boolean)this.fFile.exists());
            this.fCheckpointCollection.delete();
            Assert.assertFalse((boolean)this.fFile.exists());
        }
    }

    @Test
    public void testVersionChange() throws IOException {
        this.fCheckpointCollection.setIndexComplete();
        this.fCheckpointCollection.dispose();
        Throwable throwable = null;
        Object var2_3 = null;
        try (RandomAccessFile f = new RandomAccessFile(this.fFile, "rw");){
            f.writeInt(-1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fCheckpointCollection = this.createCollection();
        Assert.assertTrue((boolean)this.fCheckpointCollection.isCreatedFromScratch());
    }

    @Test
    public void testInsert() {
        TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(12345L), (ITmfLocation)new TmfLongLocation(123456L), 0L);
        this.fCheckpointCollection.insert((ITmfCheckpoint)checkpoint);
        long found = this.fCheckpointCollection.binarySearch((ITmfCheckpoint)checkpoint);
        Assert.assertEquals((long)0L, (long)found);
    }

    protected ArrayList<Integer> insertAlot() {
        int i = 0;
        while (i < 50000) {
            TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)(12345 + i)), (ITmfLocation)new TmfLongLocation(123456L + (long)i), (long)i);
            this.fCheckpointCollection.insert((ITmfCheckpoint)checkpoint);
            ++i;
        }
        this.fCheckpointCollection.setIndexComplete();
        if (this.isPersistableCollection()) {
            this.fCheckpointCollection.dispose();
        }
        boolean random = true;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < 50000) {
            if (random) {
                Random rand = new Random();
                list.add(rand.nextInt(50000));
            } else {
                list.add(i2);
            }
            ++i2;
        }
        return list;
    }

    @Test
    public void testInsertAlot() {
        ArrayList<Integer> list = this.insertAlot();
        if (this.isPersistableCollection()) {
            this.fCheckpointCollection = this.createCollection();
        }
        int i = 0;
        while (i < 50000) {
            Integer randomCheckpoint = list.get(i);
            TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)(12345 + randomCheckpoint)), (ITmfLocation)new TmfLongLocation(123456L + (long)randomCheckpoint.intValue()), 0L);
            long found = this.fCheckpointCollection.binarySearch((ITmfCheckpoint)checkpoint);
            Assert.assertEquals((long)randomCheckpoint.intValue(), (long)found);
            ++i;
        }
    }

    @Test
    public void testInsertSameTimestamp() {
        int i = 0;
        while (i < 50000) {
            TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(12345L), (ITmfLocation)new TmfLongLocation(123456L + (long)i), (long)i);
            this.fCheckpointCollection.insert((ITmfCheckpoint)checkpoint);
            ++i;
        }
        this.fCheckpointCollection.setIndexComplete();
        if (this.isPersistableCollection()) {
            this.fCheckpointCollection.dispose();
        }
        boolean random = true;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < 50000) {
            if (random) {
                Random rand = new Random();
                list.add(rand.nextInt(50000));
            } else {
                list.add(i2);
            }
            ++i2;
        }
        if (this.isPersistableCollection()) {
            this.fCheckpointCollection = this.createCollection();
        }
        i2 = 0;
        while (i2 < 50000) {
            Integer randomCheckpoint = (Integer)list.get(i2);
            TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(12345L), (ITmfLocation)new TmfLongLocation(123456L + (long)randomCheckpoint.intValue()), 0L);
            long found = this.fCheckpointCollection.binarySearch((ITmfCheckpoint)checkpoint);
            Assert.assertEquals((long)randomCheckpoint.intValue(), (long)found);
            ++i2;
        }
    }

    @Test
    public void testBinarySearchFindInBetween() {
        long i = 0L;
        while (i < 50000L) {
            TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(2L * i), (ITmfLocation)new TmfLongLocation(2L * i), i);
            this.fCheckpointCollection.insert((ITmfCheckpoint)checkpoint);
            ++i;
        }
        TmfCheckpoint searchedCheckpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(123L), (ITmfLocation)new TmfLongLocation(123L), 123L);
        int expectedInsertionPoint = 61;
        int expectedRank = -(expectedInsertionPoint + 2);
        long rank = this.fCheckpointCollection.binarySearch((ITmfCheckpoint)searchedCheckpoint);
        Assert.assertEquals((long)expectedRank, (long)rank);
    }

    @Test
    public void testBinarySearchInBetweenSameTimestamp() {
        TmfCheckpoint checkpoint;
        int checkpointNum = 0;
        while (checkpointNum < 100) {
            checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(0L), (ITmfLocation)new TmfLongLocation((long)checkpointNum), (long)checkpointNum);
            this.fCheckpointCollection.insert((ITmfCheckpoint)checkpoint);
            ++checkpointNum;
        }
        while (checkpointNum < 200) {
            checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(1L), (ITmfLocation)new TmfLongLocation((long)checkpointNum), (long)checkpointNum);
            this.fCheckpointCollection.insert((ITmfCheckpoint)checkpoint);
            ++checkpointNum;
        }
        TmfCheckpoint searchedCheckpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(1L), null, 0L);
        long found = this.fCheckpointCollection.binarySearch((ITmfCheckpoint)searchedCheckpoint);
        int expectedInsertionPoint = 99;
        int expectedRank = -(expectedInsertionPoint + 2);
        Assert.assertEquals((long)expectedRank, (long)found);
    }
}

