/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.component;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.osgi.framework.Bundle;

public class TmfEventProviderStub
extends TmfEventProvider {
    private TmfTraceStub fTrace;

    public TmfEventProviderStub(String path) throws IOException {
        super(path, ITmfEvent.class);
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(path), null);
        try {
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            this.fTrace = new TmfTraceStub(test.getPath(), 0, true, null);
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public TmfEventProviderStub() throws IOException {
        this(TmfTestTrace.A_TEST_10K.getFullPath());
    }

    public void dispose() {
        this.fTrace.dispose();
        super.dispose();
    }

    public ITmfContext armRequest(ITmfEventRequest request) {
        ITmfContext context = this.fTrace.seekEvent(request.getRange().getStartTime());
        return context;
    }

    public ITmfEvent getNext(ITmfContext context) {
        return this.fTrace.getNext(context);
    }

    public boolean matches(ITmfEvent event) {
        return super.matches(event) || event.getTrace() == this.fTrace;
    }
}

