/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.trace;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfEventParser;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfEventParserStub;

public class TmfTraceStub
extends TmfTrace
implements ITmfPersistentlyIndexable {
    private RandomAccessFile fTrace;
    @NonNull
    private final ITmfEventParser fParser;
    private final ReentrantLock fLock = new ReentrantLock();
    private ITmfTimestamp fInitialRangeOffset = null;
    private static int fCheckpointSize = -1;

    public TmfTraceStub() {
        this.fParser = new TmfEventParserStub((ITmfTrace)this);
    }

    public TmfTraceStub(String path, int cacheSize, long interval) throws TmfTraceException {
        super(null, ITmfEvent.class, path, cacheSize, interval);
        this.setupTrace(path);
        this.fParser = new TmfEventParserStub((ITmfTrace)this);
    }

    public TmfTraceStub(String path, int cacheSize, boolean waitForCompletion, ITmfEventParser parser) throws TmfTraceException {
        super(null, ITmfEvent.class, path, cacheSize, 0L);
        this.setupTrace(path);
        Object object = this.fParser = parser != null ? parser : new TmfEventParserStub((ITmfTrace)this);
        if (waitForCompletion) {
            this.indexTrace(true);
        }
    }

    public TmfTraceStub(IResource resource, String path, int cacheSize, boolean waitForCompletion, ITmfEventParser parser) throws TmfTraceException {
        super(resource, ITmfEvent.class, path, cacheSize, 0L);
        this.setupTrace(path);
        Object object = this.fParser = parser != null ? parser : new TmfEventParserStub((ITmfTrace)this);
        if (waitForCompletion) {
            this.indexTrace(true);
        }
    }

    public TmfTraceStub(TmfTraceStub trace) throws TmfTraceException {
        super((TmfTrace)trace);
        this.setupTrace(this.getPath());
        this.fParser = new TmfEventParserStub((ITmfTrace)this);
    }

    private void setupTrace(String path) throws TmfTraceException {
        try {
            this.fTrace = new RandomAccessFile(path, "r");
        }
        catch (FileNotFoundException e) {
            throw new TmfTraceException(e.getMessage());
        }
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        try {
            this.fTrace = new RandomAccessFile(path, "r");
        }
        catch (FileNotFoundException e) {
            throw new TmfTraceException(e.getMessage());
        }
        super.initTrace(resource, path, type);
    }

    public void initialize(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initialize(resource, path, type);
    }

    public RandomAccessFile getStream() {
        return this.fTrace;
    }

    public void setInitialRangeOffset(ITmfTimestamp initOffset) {
        this.fInitialRangeOffset = initOffset;
    }

    public ITmfTimestamp getInitialRangeOffset() {
        if (this.fInitialRangeOffset != null) {
            return this.fInitialRangeOffset;
        }
        return super.getInitialRangeOffset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TmfContext seekEvent(ITmfLocation location) {
        try {
            this.fLock.lock();
            try {
                TmfContext context;
                if (this.fTrace == null) return null;
                long loc = 0L;
                long rank = 0L;
                if (location != null) {
                    loc = (Long)location.getLocationInfo();
                    rank = -1L;
                }
                if (loc != this.fTrace.getFilePointer()) {
                    this.fTrace.seek(loc);
                }
                TmfContext tmfContext = context = new TmfContext(this.getCurrentLocation(), rank);
                return tmfContext;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                this.fLock.unlock();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public TmfContext seekEvent(double ratio) {
        this.fLock.lock();
        try {
            if (this.fTrace != null) {
                TmfLongLocation location = new TmfLongLocation(Long.valueOf(Math.round(ratio * (double)this.fTrace.length())));
                TmfContext context = this.seekEvent((ITmfLocation)location);
                context.setRank(-1L);
                TmfContext tmfContext = context;
                return tmfContext;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public double getLocationRatio(ITmfLocation location) {
        this.fLock.lock();
        try {
            if (this.fTrace != null && location.getLocationInfo() instanceof Long) {
                double d = ((Long)location.getLocationInfo()).doubleValue() / (double)this.fTrace.length();
                return d;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.fLock.unlock();
        }
        return 0.0;
    }

    public ITmfLocation getCurrentLocation() {
        this.fLock.lock();
        try {
            if (this.fTrace != null) {
                TmfLongLocation tmfLongLocation = new TmfLongLocation(this.fTrace.getFilePointer());
                return tmfLongLocation;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        this.fLock.lock();
        try {
            if (this.fTrace != null && context != null) {
                ITmfEvent event;
                ITmfEvent iTmfEvent = event = this.fParser.parseEvent(context);
                return iTmfEvent;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public ITmfTimestamp createTimestamp(long ts) {
        return new TmfTimestamp(this.getTimestampTransform().transform(ts) / 1000000L, -3);
    }

    public synchronized void setNbEvents(long nbEvents) {
        super.setNbEvents(nbEvents);
    }

    public void setTimeRange(TmfTimeRange range) {
        super.setTimeRange(range);
    }

    public void setStartTime(ITmfTimestamp startTime) {
        super.setStartTime(startTime);
    }

    public void setEndTime(ITmfTimestamp endTime) {
        super.setEndTime(endTime);
    }

    public void setStreamingInterval(long interval) {
        super.setStreamingInterval(interval);
    }

    public synchronized void dispose() {
        block6: {
            this.fLock.lock();
            try {
                try {
                    if (this.fTrace != null) {
                        this.fTrace.close();
                        this.fTrace = null;
                    }
                }
                catch (IOException iOException) {
                    this.fLock.unlock();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.fLock.unlock();
                throw throwable;
            }
            this.fLock.unlock();
        }
        super.dispose();
    }

    public IStatus validate(IProject project, String path) {
        if (this.fileExists(path)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.tracecompass.tmf.core", "File does not exist: " + path);
    }

    public synchronized int getCheckpointSize() {
        if (fCheckpointSize == -1) {
            TmfCheckpoint c = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(0L), (ITmfLocation)new TmfLongLocation(0L), 0L);
            ByteBuffer b = ByteBuffer.allocate(1024);
            b.clear();
            c.serialize(b);
            fCheckpointSize = b.position();
        }
        return fCheckpointSize;
    }

    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new TmfLongLocation(bufferIn);
    }

    public void openTrace() {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)this, null));
        this.selectTrace();
    }

    public void selectTrace() {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceSelectedSignal((Object)this, (ITmfTrace)this));
    }

    public List<TmfCoalescedEventRequest> getAllPendingRequests() throws Exception {
        Method m = TmfEventProvider.class.getDeclaredMethod("getPendingRequests", new Class[0]);
        m.setAccessible(true);
        LinkedList list = (LinkedList)m.invoke((Object)this, new Object[0]);
        LinkedList<TmfCoalescedEventRequest> retList = new LinkedList<TmfCoalescedEventRequest>();
        for (Object element : list) {
            retList.add((TmfCoalescedEventRequest)element);
        }
        return retList;
    }

    public void clearAllPendingRequests() throws Exception {
        Method m = TmfEventProvider.class.getDeclaredMethod("clearPendingRequests", new Class[0]);
        m.setAccessible(true);
        m.invoke((Object)this, new Object[0]);
    }

    public void setTimerEnabledFlag(boolean enabled) throws Exception {
        Class[] paramTypes = new Class[]{Boolean.class};
        Method m = TmfEventProvider.class.getDeclaredMethod("setTimerEnabled", paramTypes);
        Object[] params = new Object[]{enabled};
        m.setAccessible(true);
        m.invoke((Object)this, params);
    }
}

