/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.tests.trace;

import java.io.IOException;
import java.util.Map;
import org.eclipse.tracecompass.btf.core.tests.utils.BtfTestTrace;
import org.eclipse.tracecompass.btf.core.trace.BtfTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BtfTraceTest {
    private static final long START_TIME = 1392809960000000000L;
    private BtfTrace fixture;

    @Before
    public void setup() {
        this.fixture = BtfTestTrace.BTF_TEST.getTrace();
        Assert.assertNotNull((Object)this.fixture);
    }

    @After
    public void cleanup() {
        try {
            this.fixture.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testValidate() {
        TraceValidationStatus status = (TraceValidationStatus)this.fixture.validate(null, this.fixture.getPath());
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isOK());
        Assert.assertEquals((long)100L, (long)status.getConfidence());
    }

    @Test
    public void testSeek1stEvent() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((long)0L, (long)ctx.getRank());
        Assert.assertEquals((Object)499L, (Object)ctx.getLocation().getLocationInfo());
    }

    @Test
    public void testRead1stEvent() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        ITmfEvent event = this.fixture.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((long)1392809960000000000L, (long)event.getTimestamp().getValue());
    }

    @Test
    public void testRead10thEvent1() {
        ITmfContext ctx = this.fixture.seekEvent(10L);
        ITmfEvent event = this.fixture.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((long)1392809960000000000L, (long)event.getTimestamp().getValue());
    }

    @Test
    public void testRead10thEvent2() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        ITmfEvent event = null;
        int i = 0;
        while (i < 10) {
            event = this.fixture.getNext(ctx);
            ++i;
        }
        Assert.assertNotNull(event);
        Assert.assertEquals((long)1392809960000000000L, (long)event.getTimestamp().getValue());
    }

    @Test
    public void testReadProperties() {
        Map data = this.fixture.getTraceProperties();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)"ns", data.get("#timeScale"));
        Assert.assertEquals((Object)"2.1.0", data.get("#version"));
    }

    @Test
    public void testTwoContexts() {
        ITmfContext ctx0 = this.fixture.seekEvent(0L);
        ITmfContext ctx1 = this.fixture.seekEvent(10L);
        ITmfEvent event = null;
        int i = 0;
        while (i < 11) {
            event = this.fixture.getNext(ctx0);
            ++i;
        }
        ITmfEvent event1 = this.fixture.getNext(ctx1);
        Assert.assertNotNull((Object)event);
        Assert.assertNotNull((Object)event1);
        Assert.assertEquals((Object)event, (Object)event1);
    }
}

