/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.parsers.custom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.parsers.custom.AbstractCustomParserWizard;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TestCustomTxtWizard
extends AbstractCustomParserWizard {
    private static final String MANAGE_CUSTOM_PARSERS_SHELL_TITLE = "Manage Custom Parsers";
    private static final String PROJECT_NAME = "TestText";
    private static final String CATEGORY_NAME = "Test Category";
    private static final String TRACETYPE_NAME = "Test Trace";
    private static final String EXPECTED_TEST_DEFINITION = "<Definition category=\"Test Category\" name=\"Test Trace\">\n<TimeStampOutputFormat>ss</TimeStampOutputFormat>\n<InputLine>\n<Cardinality max=\"2147483647\" min=\"0\"/>\n<RegEx>\\s*(\\d\\d)\\s(.*\\S)</RegEx>\n<InputData action=\"0\" format=\"ss\" name=\"Time Stamp\"/>\n<InputData action=\"0\" name=\"Message\"/>\n</InputLine>\n<InputLine>\n<Cardinality max=\"2147483647\" min=\"0\"/>\n<RegEx>([^0-9]*)</RegEx>\n<InputData action=\"2\" name=\"Message\"/>\n</InputLine>\n<OutputColumn name=\"Time Stamp\"/>\n<OutputColumn name=\"Message\"/>\n";

    @Test
    public void testNew() throws FileNotFoundException, IOException {
        File xmlFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata/.plugins/org.eclipse.tracecompass.tmf.core/custom_txt_parsers.xml").toFile();
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotView proejctExplorerBot = fBot.viewByTitle("Project Explorer");
        proejctExplorerBot.show();
        SWTBotTreeItem treeItem = proejctExplorerBot.bot().tree().getTreeItem(PROJECT_NAME);
        treeItem.select();
        treeItem.expand();
        SWTBotTreeItem treeNode = null;
        for (String node : treeItem.getNodes()) {
            if (!node.startsWith("Trace")) continue;
            treeNode = treeItem.getNode(node);
            break;
        }
        Assert.assertNotNull(treeNode);
        treeNode.contextMenu("Manage Custom Parsers...").click();
        fBot.shell(MANAGE_CUSTOM_PARSERS_SHELL_TITLE).setFocus();
        fBot.button("New...").click();
        fBot.textWithLabel("Category:").setText(CATEGORY_NAME);
        fBot.textWithLabel("Trace type:").setText(TRACETYPE_NAME);
        fBot.textWithLabel("Time Stamp format:").setText("ss");
        fBot.comboBox(1).setSelection("Time Stamp");
        fBot.textWithLabel("format:").setText("ss");
        fBot.button(8).click();
        fBot.button(2).click();
        SWTBotTreeItem[] treeItems = fBot.tree().getAllItems();
        SWTBotTreeItem[] eventLine = new SWTBotTreeItem[2];
        SWTBotTreeItem[] sWTBotTreeItemArray = treeItems = fBot.tree().getAllItems();
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            if (item.getText().startsWith("Root Line 1")) {
                eventLine[0] = item;
            }
            if (item.getText().startsWith("Root Line 2")) {
                eventLine[1] = item;
            }
            ++n2;
        }
        Assert.assertNotNull((Object)eventLine[0]);
        Assert.assertNotNull((Object)eventLine[1]);
        fBot.styledText().setText("12 Hello\nWorld\n23 Goodbye\ncruel world");
        eventLine[0].select();
        SWTBotUtils.waitForJobs();
        fBot.textWithLabel("Regular expression:").setText("\\s*(\\d\\d)\\s(.*\\S)");
        eventLine[1].select();
        fBot.textWithLabel("Regular expression:").setText("([^0-9]*)");
        fBot.button(7).click();
        fBot.comboBox("Set").setSelection("Append with |");
        fBot.button("Highlight All").click();
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil((ICondition)new AbstractCustomParserWizard.CustomDefinitionHasContent(xmlFile, CATEGORY_NAME, TRACETYPE_NAME, EXPECTED_TEST_DEFINITION));
        String xmlPart = TestCustomTxtWizard.extractTestXml(xmlFile, CATEGORY_NAME, TRACETYPE_NAME);
        Assert.assertEquals((Object)EXPECTED_TEST_DEFINITION, (Object)xmlPart);
        fBot.list().select("Test Category : Test Trace");
        fBot.button("Delete").click();
        fBot.button("Yes").click();
        fBot.button("Close").click();
        fBot.waitUntil((ICondition)new AbstractCustomParserWizard.CustomDefinitionHasContent(xmlFile, CATEGORY_NAME, TRACETYPE_NAME, ""));
        xmlPart = TestCustomTxtWizard.extractTestXml(xmlFile, CATEGORY_NAME, TRACETYPE_NAME);
        Assert.assertEquals((Object)"", (Object)xmlPart);
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
    }

    @Test
    public void testEdit() throws FileNotFoundException, IOException {
        File xmlFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata/.plugins/org.eclipse.tracecompass.tmf.core/custom_txt_parsers.xml").toFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fw = new FileWriter(xmlFile);){
            String xmlContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<CustomTxtTraceDefinitionList>\n<Definition category=\"Demo Category\" name=\"Demo trace\">\n<TimeStampOutputFormat>sss</TimeStampOutputFormat>\n<InputLine>\n<Cardinality max=\"2147483647\" min=\"0\"/>\n<RegEx>\\s*(\\d*)\\s(.*)</RegEx>\n<InputData action=\"0\" format=\"sss\" name=\"Time Stamp\"/>\n<InputData action=\"0\" name=\"Message\"/>\n</InputLine>\n<OutputColumn name=\"Time Stamp\"/>\n<OutputColumn name=\"Message\"/>\n</Definition>\n<Definition name=\"dmesg\">\n<TimeStampOutputFormat>sssssss.ssssss</TimeStampOutputFormat>\n<InputLine>\n<Cardinality max=\"2147483647\" min=\"0\"/>\n<RegEx>^[([0-9]*\\.[0.9]*)]\\s(.*)</RegEx>\n<InputData action=\"0\" format=\"sssss.sssss\" name=\"Time Stamp\"/>\n<InputData action=\"0\" name=\"Message\"/>\n</InputLine>\n<OutputColumn name=\"Time Stamp\"/>\n<OutputColumn name=\"Message\"/>\n</Definition>\n</CustomTxtTraceDefinitionList>";
            fw.write(xmlContent);
            fw.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotView proejctExplorerBot = fBot.viewByTitle("Project Explorer");
        proejctExplorerBot.show();
        SWTBotTreeItem treeItem = proejctExplorerBot.bot().tree().getTreeItem(PROJECT_NAME);
        treeItem.select();
        treeItem.expand();
        SWTBotTreeItem treeNode = null;
        for (String node : treeItem.getNodes()) {
            if (!node.startsWith("Trace")) continue;
            treeNode = treeItem.getNode(node);
            break;
        }
        Assert.assertNotNull(treeNode);
        treeNode.contextMenu("Manage Custom Parsers...").click();
        fBot.shell(MANAGE_CUSTOM_PARSERS_SHELL_TITLE).setFocus();
        fBot.list().select("Demo Category : Demo trace");
        fBot.button("Edit...").click();
        fBot.textWithLabel("Category:").setText(CATEGORY_NAME);
        fBot.textWithLabel("Trace type:").setText(TRACETYPE_NAME);
        fBot.textWithLabel("Time Stamp format:").setText("ss");
        fBot.comboBox(1).setSelection("Time Stamp");
        fBot.textWithLabel("format:").setText("ss");
        fBot.button(2).click();
        SWTBotTreeItem[] treeItems = fBot.tree().getAllItems();
        SWTBotTreeItem[] eventLine = new SWTBotTreeItem[2];
        SWTBotTreeItem[] sWTBotTreeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            if (item.getText().startsWith("Root Line 1")) {
                eventLine[0] = item;
            }
            if (item.getText().startsWith("Root Line 2")) {
                eventLine[1] = item;
            }
            ++n2;
        }
        treeItems = fBot.tree().getAllItems();
        Assert.assertNotNull((Object)eventLine[0]);
        Assert.assertNotNull((Object)eventLine[1]);
        fBot.styledText().setText("12 Hello\nWorld\n23 Goodbye\ncruel world");
        eventLine[0].select();
        SWTBotUtils.waitForJobs();
        fBot.textWithLabel("Regular expression:").setText("\\s*(\\d\\d)\\s(.*\\S)");
        eventLine[1].select();
        fBot.textWithLabel("Regular expression:").setText("([^0-9]*)");
        fBot.button(7).click();
        fBot.comboBox("Set").setSelection("Append with |");
        fBot.button("Highlight All").click();
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil((ICondition)new AbstractCustomParserWizard.CustomDefinitionHasContent(xmlFile, CATEGORY_NAME, TRACETYPE_NAME, EXPECTED_TEST_DEFINITION));
        String xmlPart = TestCustomTxtWizard.extractTestXml(xmlFile, CATEGORY_NAME, TRACETYPE_NAME);
        Assert.assertEquals((Object)EXPECTED_TEST_DEFINITION, (Object)xmlPart);
        fBot.list().select("Test Category : Test Trace");
        fBot.button("Delete").click();
        fBot.button("Yes").click();
        fBot.button("Close").click();
        fBot.waitUntil((ICondition)new AbstractCustomParserWizard.CustomDefinitionHasContent(xmlFile, CATEGORY_NAME, TRACETYPE_NAME, ""));
        xmlPart = TestCustomTxtWizard.extractTestXml(xmlFile, CATEGORY_NAME, TRACETYPE_NAME);
        Assert.assertEquals((Object)"", (Object)xmlPart);
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
    }
}

