/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.utils.TableCollection;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.hamcrest.Matcher;

public final class ConditionHelpers {
    private ConditionHelpers() {
    }

    public static ICondition IsTreeNodeAvailable(final String name, final SWTBotTree tree) {
        return new SWTBotTestCondition(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean test() throws Exception {
                try {
                    SWTBotTreeItem[] treeItems;
                    SWTBotTreeItem[] sWTBotTreeItemArray = treeItems = tree.getAllItems();
                    int n = treeItems.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        SWTBotTreeItem ti = sWTBotTreeItemArray[n2];
                        String text = ti.getText();
                        if (text.equals(name)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        };
    }

    public static ICondition isTableItemAvailable(final String name, final SWTBotTable table) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                try {
                    return table.containsItem(name);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
    }

    public static ICondition IsTreeChildNodeAvailable(final String name, final SWTBotTreeItem treeItem) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                try {
                    return treeItem.getNode(name) != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
    }

    public static ICondition isWizardReady(final Wizard wizard) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return wizard.getShell() != null;
            }
        };
    }

    public static ICondition isWizardOnPage(final Wizard wizard, final IWizardPage page) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                if (wizard == null || page == null) {
                    return false;
                }
                IWizardContainer container = wizard.getContainer();
                if (container == null) {
                    return false;
                }
                IWizardPage currentPage = container.getCurrentPage();
                return page.equals(currentPage);
            }
        };
    }

    public static ICondition ViewIsClosed(final SWTBotView view) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return view != null && !view.isActive();
            }
        };
    }

    public static ICondition isTableCellFilled(final SWTBotTable table, final String content, final int row, final int column) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                String cell;
                block3: {
                    try {
                        cell = table.cell(row, column);
                        if (cell != null) break block3;
                        return false;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return cell.endsWith(content);
            }
        };
    }

    public static ICondition isEditorOpened(final SWTWorkbenchBot bot, final String title) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                Matcher withPartName = WidgetMatcherFactory.withPartName((String)title);
                return !bot.editors(withPartName).isEmpty();
            }
        };
    }

    public static ICondition selectionRange(final TmfTimeRange range) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return TmfTraceManager.getInstance().getCurrentTraceContext().getSelectionRange().equals((Object)range);
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Selection range: {0} expected: {1}", (Object)TmfTraceManager.getInstance().getCurrentTraceContext().getSelectionRange(), (Object)range);
            }
        };
    }

    public static ICondition windowRange(final TmfTimeRange range) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                return TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().equals((Object)range);
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Window range: {0} expected: {1}", (Object)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange(), (Object)range);
            }
        };
    }

    public static ICondition treeSelectionContains(final SWTBotTree tree, final int column, final String text) {
        return new SWTBotTestCondition(){

            @Override
            public boolean test() throws Exception {
                TableCollection selection = tree.selection();
                int row = 0;
                while (row < selection.rowCount()) {
                    if (selection.get(row, column).equals(text)) {
                        return true;
                    }
                    ++row;
                }
                return false;
            }

            @Override
            public String getFailureMessage() {
                return NLS.bind((String)"Tree selection [0,{0}]: {1} expected: {2}", (Object[])new Object[]{column, tree.selection().get(0, column), text});
            }
        };
    }

    public static class ProjectElementHasChild
    extends DefaultCondition {
        private final SWTBotTreeItem fParentItem;
        private final String fName;
        private final String fRegex;
        private SWTBotTreeItem fItem = null;

        public ProjectElementHasChild(SWTBotTreeItem parentItem, String name) {
            this.fParentItem = parentItem;
            this.fName = name;
            this.fRegex = String.valueOf(name) + "(\\s\\[(\\d)+\\])?";
        }

        public boolean test() throws Exception {
            this.fParentItem.expand();
            SWTBotTreeItem[] sWTBotTreeItemArray = this.fParentItem.getItems();
            int n = sWTBotTreeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                SWTBotTreeItem item = sWTBotTreeItemArray[n2];
                if (item.getText().matches(this.fRegex)) {
                    this.fItem = item;
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getFailureMessage() {
            return NLS.bind((String)"No child of {0} found with name {1}", (Object)this.fParentItem.getText(), (Object)this.fName);
        }

        public SWTBotTreeItem getItem() {
            return this.fItem;
        }
    }

    private static abstract class SWTBotTestCondition
    implements ICondition {
        private SWTBotTestCondition() {
        }

        public abstract boolean test() throws Exception;

        public final void init(SWTBot bot) {
        }

        public String getFailureMessage() {
            return null;
        }
    }
}

