/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TestTraceOffsetting {
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE = " \" name=\"event\"><field name=\"field\" value=\"";
    private static final String EVENT_END = "\" type=\"int\" /></event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJET_NAME = "TestForOffsetting";
    private static final int NUM_EVENTS = 100;
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;
    private File fLocation;

    private static String makeEvent(int ts, int val) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE + Integer.toString(val) + EVENT_END + "\n";
    }

    @Before
    public void init() throws IOException {
        SWTBotUtils.failIfUIThread();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
        this.fLocation = File.createTempFile("sample", ".xml");
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(this.fLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 100) {
                braf.writeBytes(TestTraceOffsetting.makeEvent(i * 100, i % 4));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @After
    public void cleanup() {
        this.fLocation.delete();
        fLogger.removeAllAppenders();
    }

    @Test
    public void testOffsetting() {
        SWTBotUtils.createProject(PROJET_NAME);
        SWTBotTreeItem traceFolderItem = SWTBotUtils.selectTracesFolder(fBot, PROJET_NAME);
        SWTBotUtils.openTrace(PROJET_NAME, this.fLocation.getAbsolutePath(), "org.eclipse.linuxtools.tmf.core.tests.xmlstub");
        SWTBotEditor editor = fBot.editorByTitle(this.fLocation.getName());
        SWTBotTable eventsTableBot = editor.bot().table();
        String timestamp = eventsTableBot.cell(1, 1);
        Assert.assertEquals((Object)"19:00:00.000 000 000", (Object)timestamp);
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, traceFolderItem, this.fLocation.getName());
        traceItem.select();
        traceItem.contextMenu("Apply Time Offset...").click();
        SWTBotUtils.waitForJobs();
        SWTBotShell shell = fBot.shell("Apply time offset");
        shell.setFocus();
        SWTBotTreeItem[] allItems = fBot.tree().getAllItems();
        SWTBotTreeItem swtBotTreeItem = allItems[0];
        swtBotTreeItem.select();
        swtBotTreeItem.click(1);
        swtBotTreeItem.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)57)});
        swtBotTreeItem.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)57)});
        swtBotTreeItem.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)10)});
        SWTBotUtils.waitForJobs();
        fBot.button("OK").click();
        fBot.waitWhile(ConditionHelpers.isEditorOpened(fBot, this.fLocation.getName()));
        SWTBotUtils.openTrace(PROJET_NAME, this.fLocation.getAbsolutePath(), "org.eclipse.linuxtools.tmf.core.tests.xmlstub");
        editor = fBot.editorByTitle(this.fLocation.getName());
        eventsTableBot = editor.bot().table();
        timestamp = eventsTableBot.cell(1, 1);
        Assert.assertEquals((Object)"19:00:00.000 000 099", (Object)timestamp);
        SWTBotUtils.deleteProject(PROJET_NAME, fBot);
    }
}

