/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.keyboard.Keyboard;
import org.eclipse.swtbot.swt.finder.keyboard.KeyboardFactory;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ControlFlowViewTest
extends KernelTest {
    private static final String FOLLOW_CPU_BACKWARD = "Follow CPU Backward";
    private static final String FOLLOW_CPU_FORWARD = "Follow CPU Forward";
    private static final String SELECT_PREVIOUS_EVENT = "Select Previous Event";
    private static final String SELECT_NEXT_EVENT = "Select Next Event";
    private static final Keyboard KEYBOARD = KeyboardFactory.getSWTKeyboard();
    @NonNull
    private static final ITmfTimestamp START_TIME = new TmfNanoTimestamp(1368000272650993664L);
    @NonNull
    private static final ITmfTimestamp TID1_TIME1 = new TmfNanoTimestamp(1368000272651208412L);
    @NonNull
    private static final ITmfTimestamp TID1_TIME2 = new TmfNanoTimestamp(1368000272656147616L);
    @NonNull
    private static final ITmfTimestamp TID1_TIME3 = new TmfNanoTimestamp(1368000272656362364L);
    @NonNull
    private static final ITmfTimestamp TID1_TIME4 = new TmfNanoTimestamp(1368000272663234300L);
    @NonNull
    private static final ITmfTimestamp TID1_TIME5 = new TmfNanoTimestamp(1368000272663449048L);
    @NonNull
    private static final ITmfTimestamp TID1_TIME6 = new TmfNanoTimestamp(1368000272665596528L);
    @NonNull
    private static final ITmfTimestamp TID2_TIME1 = new TmfNanoTimestamp(1368000272651852656L);
    @NonNull
    private static final ITmfTimestamp TID2_TIME2 = new TmfNanoTimestamp(1368000272652067404L);
    @NonNull
    private static final ITmfTimestamp TID2_TIME3 = new TmfNanoTimestamp(1368000272652282152L);
    @NonNull
    private static final ITmfTimestamp TID2_TIME4 = new TmfNanoTimestamp(1368000272652496900L);
    @NonNull
    private static final ITmfTimestamp TID5_TIME1 = new TmfNanoTimestamp(1368000272652496900L);
    private SWTBotView fViewBot;

    @Override
    @Before
    public void before() {
        super.before();
        this.fViewBot = fBot.viewByTitle("Control Flow");
    }

    @Test
    public void testKeyboardLeftRight() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        SWTBotTree tree = this.fViewBot.bot().tree();
        tree.pressShortcut(new KeyStroke[]{Keystrokes.HOME});
        final TimeGraphControl timegraph = (TimeGraphControl)this.fViewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                timegraph.setFocus();
            }
        });
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.RIGHT});
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME3)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME3));
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME6)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME6));
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME2)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME2));
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.RIGHT});
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME4)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME4));
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME1)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME1));
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME5)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME5));
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.LEFT});
        KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.LEFT});
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(START_TIME));
    }

    @Test
    public void testToolBarSelectNextPreviousEvent() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        SWTBotTree tree = this.fViewBot.bot().tree();
        tree.pressShortcut(new KeyStroke[]{Keystrokes.HOME});
        final TimeGraphControl timegraph = (TimeGraphControl)this.fViewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                timegraph.setFocus();
            }
        });
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click();
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click();
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click();
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME3)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME3));
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME6)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME6));
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME2)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME2));
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click();
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click();
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME4)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME4));
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME1)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME1));
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click(131072);
        this.fViewBot.toolbarButton(SELECT_NEXT_EVENT).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME5)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME5));
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click();
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click();
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click();
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click();
        this.fViewBot.toolbarButton(SELECT_PREVIOUS_EVENT).click();
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(START_TIME));
    }

    @Test
    public void testToolBarFollowCPUForwardBackward() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        SWTBotTree tree = this.fViewBot.bot().tree();
        tree.pressShortcut(new KeyStroke[]{Keystrokes.HOME});
        final TimeGraphControl timegraph = (TimeGraphControl)this.fViewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                timegraph.setFocus();
            }
        });
        fBot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                List arrows = timegraph.getArrows();
                return arrows.size() >= 3 && ((ILinkEvent)arrows.get(0)).getTime() == TID1_TIME1.getValue() && ((ILinkEvent)arrows.get(1)).getTime() == TID2_TIME2.getValue() && ((ILinkEvent)arrows.get(2)).getTime() == TID2_TIME4.getValue();
            }

            public String getFailureMessage() {
                return "Arrows not found";
            }
        });
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID2_TIME2)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME2));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID5_TIME1)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"5"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID5_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID2_TIME1)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID2_TIME3)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME3));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID1_TIME1)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"1"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME1));
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.fViewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID2_TIME4)));
        fBot.waitUntil(ConditionHelpers.treeSelectionContains((SWTBotTree)tree, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME4));
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.fViewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(START_TIME));
    }
}

