/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.statistics;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfBaseColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfBaseColumnDataTest {
    private int fAlignment;
    private int fWidth;
    private String fHeader;
    private String fToolTip;
    private ColumnLabelProvider fLabelProvider;
    private ViewerComparator fComparator;
    private TmfBaseColumnData.ITmfColumnPercentageProvider fPercentageProvider;
    private TmfStatisticsTreeNode fTreeNode;
    private String fTraceName;
    private TmfBaseColumnData fBaseColumnData;

    @Before
    public void init() {
        this.fHeader = "test Column1";
        this.fWidth = 300;
        this.fAlignment = 16384;
        this.fToolTip = "Tooltip " + this.fHeader;
        this.fLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TmfStatisticsTreeNode)element).getName();
            }

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
        };
        this.fComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TmfStatisticsTreeNode n1 = (TmfStatisticsTreeNode)e1;
                TmfStatisticsTreeNode n2 = (TmfStatisticsTreeNode)e2;
                return n1.getName().compareTo(n2.getName());
            }
        };
        this.fPercentageProvider = new TmfBaseColumnData.ITmfColumnPercentageProvider(){

            public double getPercentage(TmfStatisticsTreeNode node) {
                TmfStatisticsTreeNode parent = node;
                while ((parent = parent.getParent()) != null && parent.getValues().getTotal() == 0L) {
                }
                if (parent == null) {
                    return 0.0;
                }
                return (double)node.getValues().getTotal() / (double)parent.getValues().getTotal();
            }
        };
        TmfStatisticsTree baseData = new TmfStatisticsTree();
        this.fTraceName = "trace1";
        this.fTreeNode = new TmfStatisticsTreeNode(baseData, baseData.getRootNode(), new String[]{this.fTraceName});
        this.fBaseColumnData = new TmfBaseColumnData(this.fHeader, this.fWidth, this.fAlignment, this.fToolTip, this.fLabelProvider, this.fComparator, this.fPercentageProvider);
    }

    @Test
    public void testGetHeader() {
        Assert.assertEquals((String)"getHeader", (long)0L, (long)this.fBaseColumnData.getHeader().compareTo(this.fHeader));
    }

    @Test
    public void testGetWidth() {
        Assert.assertEquals((String)"getWidth", (long)this.fWidth, (long)this.fBaseColumnData.getWidth());
    }

    @Test
    public void testGetAlignment() {
        Assert.assertEquals((String)"getAlignment", (long)this.fAlignment, (long)this.fBaseColumnData.getAlignment());
    }

    @Test
    public void testGetTooltip() {
        Assert.assertEquals((String)"getTooltip", (Object)this.fToolTip, (Object)this.fBaseColumnData.getTooltip());
    }

    @Test
    public void testGetLabelProvider() {
        Assert.assertEquals((String)"getLabelProvider", (long)0L, (long)this.fBaseColumnData.getLabelProvider().getText((Object)this.fTreeNode).compareTo(this.fLabelProvider.getText((Object)this.fTreeNode)));
        Assert.assertTrue((String)"getLabelProvider", (boolean)this.fBaseColumnData.getLabelProvider().getImage((Object)this.fTreeNode).equals((Object)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS")));
        Assert.assertTrue((String)"getLabelProvider", (boolean)this.fBaseColumnData.getLabelProvider().equals(this.fLabelProvider));
    }

    @Test
    public void testGetComparator() {
        Assert.assertTrue((String)"getComparator", (boolean)this.fBaseColumnData.getComparator().equals(this.fComparator));
    }

    @Test
    public void testGetPercentageProvider() {
        Assert.assertTrue((String)"getPercentageProvider", (boolean)this.fBaseColumnData.getPercentageProvider().equals(this.fPercentageProvider));
    }
}

