/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.statistics;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.Messages;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.junit.Assert;
import org.junit.Test;

public class TmfStatisticsTreeNodeTest {
    private final String fTypeId1 = "Some type1";
    private final String fTypeId2 = "Some type2";
    private final String fTypeId3 = "Some type3";
    private final TmfStatisticsTree fStatsTree = new TmfStatisticsTree();
    private static final String fTestName = "StatisticsTreeNodeTest";

    public TmfStatisticsTreeNodeTest() {
        this.fStatsTree.setTotal(fTestName, true, 18L);
        this.fStatsTree.setTypeCount(fTestName, "Some type1", true, 5L);
        this.fStatsTree.setTypeCount(fTestName, "Some type2", true, 6L);
        this.fStatsTree.setTypeCount(fTestName, "Some type3", true, 7L);
        this.fStatsTree.setTotal(fTestName, false, 9L);
        this.fStatsTree.setTypeCount(fTestName, "Some type1", false, 2L);
        this.fStatsTree.setTypeCount(fTestName, "Some type2", false, 3L);
        this.fStatsTree.setTypeCount(fTestName, "Some type3", false, 4L);
    }

    @Test
    public void testContainsChild() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        Assert.assertTrue((boolean)rootNode.containsChild(fTestName));
        Assert.assertFalse((boolean)rootNode.containsChild(catNode.getName()));
        Assert.assertTrue((boolean)traceNode.containsChild(catNode.getName()));
        Assert.assertFalse((boolean)traceNode.containsChild("Some type1"));
        Assert.assertTrue((boolean)catNode.containsChild("Some type1"));
        Assert.assertTrue((boolean)catNode.containsChild("Some type2"));
    }

    @Test
    public void testGetChildren() {
        Collection childrenTreeNode = this.fStatsTree.getRootNode().getChildren();
        Assert.assertEquals((long)1L, (long)childrenTreeNode.size());
        TmfStatisticsTreeNode treeNode = (TmfStatisticsTreeNode)childrenTreeNode.iterator().next();
        Assert.assertEquals((Object)fTestName, (Object)treeNode.getName());
        childrenTreeNode = this.fStatsTree.getNode(new String[]{fTestName}).getChildren();
        Assert.assertEquals((long)1L, (long)childrenTreeNode.size());
        treeNode = (TmfStatisticsTreeNode)childrenTreeNode.iterator().next();
        Assert.assertEquals((Object)Messages.TmfStatisticsData_EventTypes, (Object)treeNode.getName());
        Vector<String> keyExpected = new Vector<String>();
        keyExpected.add("Some type1");
        keyExpected.add("Some type2");
        keyExpected.add("Some type3");
        childrenTreeNode = treeNode.getChildren();
        Assert.assertEquals((long)3L, (long)childrenTreeNode.size());
        for (TmfStatisticsTreeNode temp : childrenTreeNode) {
            if (keyExpected.contains(temp.getName())) {
                keyExpected.removeElement(temp.getName());
                continue;
            }
            Assert.fail();
        }
        childrenTreeNode = this.fStatsTree.getNode(((TmfStatisticsTreeNode)childrenTreeNode.iterator().next()).getPath()).getChildren();
        Assert.assertEquals((long)0L, (long)childrenTreeNode.size());
    }

    @Test
    public void testGetNbChildren() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode elementNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        Assert.assertEquals((long)1L, (long)rootNode.getNbChildren());
        Assert.assertEquals((long)1L, (long)traceNode.getNbChildren());
        Assert.assertEquals((long)3L, (long)catNode.getNbChildren());
        Assert.assertEquals((long)0L, (long)elementNode.getNbChildren());
    }

    @Test
    public void testHasChildren() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode elementNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        Assert.assertTrue((boolean)rootNode.hasChildren());
        Assert.assertTrue((boolean)traceNode.hasChildren());
        Assert.assertTrue((boolean)catNode.hasChildren());
        Assert.assertFalse((boolean)elementNode.hasChildren());
    }

    @Test
    public void testGetParent() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode parentNode = rootNode.getParent();
        Assert.assertNull((Object)parentNode);
        TmfStatisticsTreeNode newTraceNode = new TmfStatisticsTreeNode(this.fStatsTree, rootNode, new String[]{"newly created trace node"});
        parentNode = newTraceNode.getParent();
        Assert.assertNotNull((Object)parentNode);
        Assert.assertTrue((this.fStatsTree.getRootNode() == parentNode ? 1 : 0) != 0);
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        parentNode = traceNode.getParent();
        Assert.assertNotNull((Object)parentNode);
        Assert.assertTrue((rootNode == parentNode ? 1 : 0) != 0);
        TmfStatisticsTreeNode elementNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        parentNode = elementNode.getParent();
        Assert.assertTrue((parentNode == this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes}) ? 1 : 0) != 0);
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        parentNode = catNode.getParent();
        Assert.assertNotNull((Object)parentNode);
        Assert.assertTrue((parentNode == this.fStatsTree.getNode(new String[]{fTestName}) ? 1 : 0) != 0);
        parentNode = elementNode.getParent();
        Assert.assertNotNull((Object)parentNode);
        Assert.assertTrue((boolean)TmfStatisticsTreeNodeTest.arraysEqual(parentNode.getPath(), fTestName, Messages.TmfStatisticsData_EventTypes));
    }

    @Test
    public void testgetName() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode elementNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        Assert.assertEquals((long)0L, (long)rootNode.getName().compareTo("root"));
        Assert.assertEquals((long)0L, (long)traceNode.getName().compareTo(fTestName));
        Assert.assertEquals((long)0L, (long)catNode.getName().compareTo(Messages.TmfStatisticsData_EventTypes));
        Assert.assertEquals((long)0L, (long)elementNode.getName().compareTo("Some type1"));
    }

    @Test
    public void testGetPath() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode elementNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        Assert.assertEquals((long)0L, (long)rootNode.getPath().length);
        Assert.assertTrue((boolean)TmfStatisticsTreeNodeTest.arraysEqual(traceNode.getPath(), fTestName));
        Assert.assertTrue((boolean)TmfStatisticsTreeNodeTest.arraysEqual(catNode.getPath(), fTestName, Messages.TmfStatisticsData_EventTypes));
        Assert.assertTrue((boolean)TmfStatisticsTreeNodeTest.arraysEqual(elementNode.getPath(), fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"));
    }

    @Test
    public void testGetValue() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode elementNode1 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        TmfStatisticsTreeNode elementNode2 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type2"});
        TmfStatisticsTreeNode elementNode3 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type3"});
        Assert.assertEquals((long)0L, (long)rootNode.getValues().getTotal());
        Assert.assertEquals((long)18L, (long)traceNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)catNode.getValues().getTotal());
        Assert.assertEquals((long)5L, (long)elementNode1.getValues().getTotal());
        Assert.assertEquals((long)6L, (long)elementNode2.getValues().getTotal());
        Assert.assertEquals((long)7L, (long)elementNode3.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)rootNode.getValues().getPartial());
        Assert.assertEquals((long)9L, (long)traceNode.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)catNode.getValues().getPartial());
        Assert.assertEquals((long)2L, (long)elementNode1.getValues().getPartial());
        Assert.assertEquals((long)3L, (long)elementNode2.getValues().getPartial());
        Assert.assertEquals((long)4L, (long)elementNode3.getValues().getPartial());
    }

    @Test
    public void testReset() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode elementNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        elementNode.reset();
        Assert.assertEquals((long)0L, (long)elementNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)elementNode.getValues().getPartial());
        catNode.reset();
        Assert.assertEquals((long)0L, (long)catNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)catNode.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)catNode.getNbChildren());
        Assert.assertNull((Object)this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"}));
        traceNode.reset();
        Assert.assertEquals((long)0L, (long)traceNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)traceNode.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)traceNode.getNbChildren());
        rootNode.reset();
        Assert.assertEquals((long)0L, (long)rootNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)rootNode.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)rootNode.getNbChildren());
    }

    @Test
    public void testResetGlobalValue() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode eventTypeNode1 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        TmfStatisticsTreeNode eventTypeNode2 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type2"});
        TmfStatisticsTreeNode eventTypeNode3 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type3"});
        rootNode.resetGlobalValue();
        Assert.assertEquals((long)0L, (long)rootNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)traceNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)catNode.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)eventTypeNode1.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)eventTypeNode2.getValues().getTotal());
        Assert.assertEquals((long)0L, (long)eventTypeNode3.getValues().getTotal());
        Collection rootChildren = rootNode.getChildren();
        Assert.assertEquals((long)1L, (long)rootChildren.size());
        Assert.assertTrue((boolean)rootChildren.contains(traceNode));
        Collection traceChildren = traceNode.getChildren();
        Assert.assertEquals((long)1L, (long)traceChildren.size());
        Assert.assertTrue((boolean)traceChildren.contains(catNode));
        Collection catChildren = catNode.getChildren();
        Assert.assertEquals((long)3L, (long)catChildren.size());
        Assert.assertTrue((boolean)catChildren.contains(eventTypeNode1));
        Assert.assertTrue((boolean)catChildren.contains(eventTypeNode2));
        Assert.assertTrue((boolean)catChildren.contains(eventTypeNode3));
    }

    @Test
    public void testResetTimeRangeValue() {
        TmfStatisticsTreeNode rootNode = this.fStatsTree.getRootNode();
        TmfStatisticsTreeNode traceNode = this.fStatsTree.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode catNode = (TmfStatisticsTreeNode)traceNode.getChildren().iterator().next();
        TmfStatisticsTreeNode eventTypeNode1 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type1"});
        TmfStatisticsTreeNode eventTypeNode2 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type2"});
        TmfStatisticsTreeNode eventTypeNode3 = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Some type3"});
        rootNode.resetTimeRangeValue();
        Assert.assertEquals((long)0L, (long)rootNode.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)traceNode.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)catNode.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)eventTypeNode1.getValues().getPartial());
        Assert.assertEquals((long)0L, (long)eventTypeNode2.getValues().getPartial());
        Collection rootChildren = rootNode.getChildren();
        Assert.assertEquals((long)1L, (long)rootChildren.size());
        Assert.assertTrue((boolean)rootChildren.contains(traceNode));
        Collection traceChildren = traceNode.getChildren();
        Assert.assertEquals((long)1L, (long)traceChildren.size());
        Assert.assertTrue((boolean)traceChildren.contains(catNode));
        Collection catChildren = catNode.getChildren();
        Assert.assertEquals((long)3L, (long)catChildren.size());
        Assert.assertTrue((boolean)catChildren.contains(eventTypeNode1));
        Assert.assertTrue((boolean)catChildren.contains(eventTypeNode2));
        Assert.assertTrue((boolean)catChildren.contains(eventTypeNode3));
    }

    private static boolean arraysEqual(String[] array1, String ... array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!array1[i].equals(array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

