/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.trace;

import java.io.File;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfEventParser;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCustomTraceIndexTest {
    protected static final String TIMESTAMP_FORMAT = "dd/MM/yyyy HH:mm:ss:SSS";
    protected static final int BLOCK_SIZE = 100;
    protected static final int NB_EVENTS = 10000;
    private TestTrace fTrace = null;

    @Before
    public void setUp() throws Exception {
        this.setupTrace();
    }

    private synchronized void setupTrace() throws Exception {
        File traceDirectory = new File(this.getTraceDirectory());
        if (traceDirectory.exists()) {
            traceDirectory.delete();
        }
        traceDirectory.mkdir();
        if (this.fTrace == null) {
            this.fTrace = this.createTrace();
            this.fTrace.indexTrace(true);
        }
    }

    protected abstract TestTrace createTrace() throws Exception;

    protected abstract String getTraceDirectory();

    /*
     * Unable to fully structure code
     */
    @After
    public void tearDown() {
        block5: {
            directory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this.fTrace);
            try {
                this.fTrace.dispose();
                this.fTrace = null;
            }
            finally {
                dir = new File(directory);
                if (!dir.exists()) break block5;
                var8_8 = files = dir.listFiles();
                var7_10 = files.length;
                var6_12 = 0;
                ** while (var6_12 < var7_10)
            }
lbl-1000:
            // 1 sources

            {
                file = var8_8[var6_12];
                file.delete();
                ++var6_12;
                continue;
            }
lbl18:
            // 1 sources

            dir.delete();
        }
        trace = new File(this.getTraceDirectory());
        if (trace.exists()) {
            trace.delete();
        }
    }

    @Test
    public void testTmfTraceIndexing() {
        this.verifyIndexContent();
    }

    private void verifyIndexContent() {
        Assert.assertEquals((String)"getCacheSize", (long)100L, (long)this.fTrace.getCacheSize());
        Assert.assertEquals((String)"getTraceSize", (long)10000L, (long)this.fTrace.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)0L, (long)this.fTrace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)9999L, (long)this.fTrace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)0L, (long)this.fTrace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)9999L, (long)this.fTrace.getEndTime().getValue());
        ITmfCheckpointIndex checkpoints = this.fTrace.getIndexer().getCheckpoints();
        int pageSize = this.fTrace.getCacheSize();
        Assert.assertTrue((String)"Checkpoints exist", (checkpoints != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Checkpoints size", (long)100L, (long)checkpoints.size());
        int i = 0;
        while (i < checkpoints.size()) {
            ITmfCheckpoint checkpoint = checkpoints.get((long)i);
            TmfContext context = new TmfContext(checkpoint.getLocation(), (long)(i * pageSize));
            ITmfEvent event = ((ITmfEventParser)this.fTrace).parseEvent((ITmfContext)context);
            Assert.assertTrue((context.getRank() == (long)(i * pageSize) ? 1 : 0) != 0);
            Assert.assertTrue((checkpoint.getTimestamp().compareTo(event.getTimestamp()) == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testReopenIndex() throws Exception {
        this.fTrace.dispose();
        this.fTrace = this.createTrace();
        Assert.assertFalse((boolean)this.fTrace.getIndexer().getCheckpoints().isCreatedFromScratch());
        this.fTrace.indexTrace(true);
        this.verifyIndexContent();
    }

    protected static class TestIndexer
    extends TmfBTreeTraceIndexer {
        public TestIndexer(ITmfTrace trace, int interval) {
            super(trace, interval);
        }

        public ITmfCheckpointIndex getCheckpoints() {
            return this.getTraceIndex();
        }
    }

    static interface TestTrace
    extends ITmfTrace {
        public TestIndexer getIndexer();
    }
}

