/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import java.util.List;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDSignalValidator;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestFacility;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfSyncMessage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfUml2SDSyncLoaderFindTest {
    private static final Uml2SDTestTimestamp TC_002_TIME_VALUE = new Uml2SDTestTimestamp(9788642104149L);
    private static final String TC_002_MESSAGE_NAME = "GAME_REQUEST";
    private static final int TC_002_PAGE_VALUE = 0;
    private static final int TC_002_START_OCCURRANCE = 3;
    private static final int TC_002_END_OCCURRANCE = 3;
    private static final String TC_002_START_LIFELINE = "player1";
    private static final String TC_002_END_LIFELINE = "Master";
    private static final Uml2SDTestTimestamp TC_003_TIME_VALUE = new Uml2SDTestTimestamp(9788642113228L);
    private static final String TC_003_MESSAGE_NAME = "GAME_REPLY";
    private static final int TC_003_PAGE_VALUE = 0;
    private static final int TC_003_START_OCCURRANCE = 4;
    private static final int TC_003_END_OCCURRANCE = 4;
    private static final String TC_003_START_LIFELINE = "Master";
    private static final String TC_003_END_LIFELINE = "player1";
    private static final Uml2SDTestTimestamp TC_004_TIME_VALUE = new Uml2SDTestTimestamp(9791893030834L);
    private static final String TC_004_MESSAGE_NAME = "GAME_REQUEST";
    private static final int TC_004_PAGE_VALUE = 4;
    private static final int TC_004_START_OCCURRANCE = 19;
    private static final int TC_004_END_OCCURRANCE = 19;
    private static final String TC_004_START_LIFELINE = "player2";
    private static final String TC_004_END_LIFELINE = "Master";
    private static final int TC_005_PAGE_VALUE = 0;
    private static final String TC_005_LIFELINE_NAME = "player1";
    private static final int TC_006_PAGE_VALUE = 4;
    private static final String TC_006_LIFELINE_NAME = "player2";
    private static Uml2SDTestFacility fFacility;
    private static Uml2SDSignalValidator fTmfComponent;
    private static Criteria criteria;
    private static List<GraphNode> selection;
    private static TmfSyncMessage msg;
    private static Lifeline lifeline;

    @BeforeClass
    public static void setUpClass() {
        fFacility = Uml2SDTestFacility.getInstance();
        fFacility.selectExperiment();
        fTmfComponent = new Uml2SDSignalValidator();
    }

    @AfterClass
    public static void tearDownClass() {
        fTmfComponent.dispose();
        fFacility.disposeExperiment();
        fFacility = null;
    }

    @Test
    public void verifyISDGraphNodeSupporter() {
        fFacility.firstPage();
        Assert.assertTrue((String)"isNodeSupported", (boolean)fFacility.getLoader().isNodeSupported(0));
        Assert.assertTrue((String)"isNodeSupported", (boolean)fFacility.getLoader().isNodeSupported(1));
        Assert.assertFalse((String)"isNodeSupported", (boolean)fFacility.getLoader().isNodeSupported(2));
        Assert.assertFalse((String)"isNodeSupported", (boolean)fFacility.getLoader().isNodeSupported(3));
        Assert.assertFalse((String)"isNodeSupported", (boolean)fFacility.getLoader().isNodeSupported(4));
        Assert.assertFalse((String)"isNodeSupported", (boolean)fFacility.getLoader().isNodeSupported(5));
        Assert.assertEquals((String)"getNodeName", (Object)"Lifeline", (Object)fFacility.getLoader().getNodeName(0, null));
        Assert.assertEquals((String)"getNodeName", (Object)"Interaction", (Object)fFacility.getLoader().getNodeName(1, null));
        Assert.assertEquals((String)"getNodeName", (Object)"", (Object)fFacility.getLoader().getNodeName(2, null));
        Assert.assertEquals((String)"getNodeName", (Object)"", (Object)fFacility.getLoader().getNodeName(3, null));
        Assert.assertEquals((String)"getNodeName", (Object)"", (Object)fFacility.getLoader().getNodeName(4, null));
        Assert.assertEquals((String)"getNodeName", (Object)"", (Object)fFacility.getLoader().getNodeName(5, null));
        fFacility.getLoader().cancel();
    }

    @Test
    public void verifyFirstMessage() {
        fFacility.firstPage();
        criteria = new Criteria();
        criteria.setSyncMessageSelected(true);
        criteria.setExpression("GAME_.*");
        fTmfComponent.setSource(fFacility.getLoader());
        fTmfComponent.setCurrentTime(TC_002_TIME_VALUE);
        fTmfComponent.setCurrentRange(null);
        fTmfComponent.setSignalReceived(false);
        fFacility.getLoader().find(criteria);
        fFacility.delay(1000L);
        Assert.assertTrue((String)"find", (boolean)fTmfComponent.isSignalReceived());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isSignalError());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isCurrentTimeError());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isSourceError());
        Assert.assertEquals((String)"find", (long)0L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull(selection);
        Assert.assertEquals((String)"find", (long)1L, (long)selection.size());
        Assert.assertTrue((boolean)(selection.get(0) instanceof TmfSyncMessage));
        msg = (TmfSyncMessage)selection.get(0);
        Assert.assertEquals((String)"find", (Object)"GAME_REQUEST", (Object)msg.getName());
        Assert.assertEquals((String)"find", (long)0L, (long)TC_002_TIME_VALUE.compareTo(msg.getStartTime()));
        Assert.assertEquals((String)"find", (long)3L, (long)msg.getStartOccurrence());
        Assert.assertEquals((String)"find", (long)3L, (long)msg.getEndOccurrence());
        Assert.assertEquals((String)"find", (Object)"player1", (Object)msg.getStartLifeline().getName());
        Assert.assertEquals((String)"find", (Object)"Master", (Object)msg.getEndLifeline().getName());
        fTmfComponent.setSource(fFacility.getLoader());
        fTmfComponent.setCurrentTime(TC_003_TIME_VALUE);
        fTmfComponent.setCurrentRange(null);
        fTmfComponent.setSignalReceived(false);
        fFacility.getLoader().find(criteria);
        fFacility.delay(1000L);
        Assert.assertTrue((String)"find", (boolean)fTmfComponent.isSignalReceived());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isSignalError());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isCurrentTimeError());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isSourceError());
        Assert.assertEquals((String)"find", (long)0L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull(selection);
        Assert.assertEquals((String)"find", (long)1L, (long)selection.size());
        Assert.assertTrue((boolean)(selection.get(0) instanceof TmfSyncMessage));
        msg = (TmfSyncMessage)selection.get(0);
        Assert.assertEquals((String)"find", (Object)TC_003_MESSAGE_NAME, (Object)msg.getName());
        Assert.assertEquals((String)"find", (long)0L, (long)TC_003_TIME_VALUE.compareTo(msg.getStartTime()));
        Assert.assertEquals((String)"find", (long)4L, (long)msg.getStartOccurrence());
        Assert.assertEquals((String)"find", (long)4L, (long)msg.getEndOccurrence());
        Assert.assertEquals((String)"find", (Object)"Master", (Object)msg.getStartLifeline().getName());
        Assert.assertEquals((String)"find", (Object)"player1", (Object)msg.getEndLifeline().getName());
        fTmfComponent.setSource(fFacility.getLoader());
        fTmfComponent.setCurrentTime(TC_004_TIME_VALUE);
        fTmfComponent.setCurrentRange(new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH));
        fTmfComponent.setSignalReceived(false);
        fFacility.getLoader().find(criteria);
        fFacility.waitForJobs();
        fFacility.delay(1000L);
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertTrue((String)"find", (boolean)fTmfComponent.isSignalReceived());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isSignalError());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isCurrentTimeError());
        Assert.assertFalse((String)"find", (boolean)fTmfComponent.isSourceError());
        Assert.assertEquals((String)"find", (long)4L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull(selection);
        Assert.assertEquals((String)"find", (long)1L, (long)selection.size());
        Assert.assertTrue((boolean)(selection.get(0) instanceof TmfSyncMessage));
        msg = (TmfSyncMessage)selection.get(0);
        Assert.assertEquals((String)"find", (Object)"GAME_REQUEST", (Object)msg.getName());
        Assert.assertEquals((String)"find", (long)0L, (long)TC_004_TIME_VALUE.compareTo(msg.getStartTime()));
        Assert.assertEquals((String)"find", (long)19L, (long)msg.getStartOccurrence());
        Assert.assertEquals((String)"find", (long)19L, (long)msg.getEndOccurrence());
        Assert.assertEquals((String)"find", (Object)"player2", (Object)msg.getStartLifeline().getName());
        Assert.assertEquals((String)"find", (Object)"Master", (Object)msg.getEndLifeline().getName());
        fFacility.getLoader().cancel();
    }

    @Test
    public void verifyFind() {
        fFacility.firstPage();
        criteria = new Criteria();
        criteria.setLifeLineSelected(true);
        criteria.setExpression("player1");
        fFacility.getLoader().find(criteria);
        fFacility.delay(1000L);
        Assert.assertEquals((String)"find", (long)0L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull(selection);
        Assert.assertEquals((String)"find", (long)1L, (long)selection.size());
        Assert.assertTrue((boolean)(selection.get(0) instanceof Lifeline));
        lifeline = (Lifeline)selection.get(0);
        Assert.assertEquals((String)"find", (Object)"player1", (Object)lifeline.getName());
        criteria = new Criteria();
        criteria.setLifeLineSelected(true);
        criteria.setExpression("player2");
        fFacility.getLoader().find(criteria);
        fFacility.waitForJobs();
        fFacility.delay(1000L);
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"find", (long)4L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull(selection);
        Assert.assertEquals((String)"find", (long)1L, (long)selection.size());
        Assert.assertTrue((boolean)(selection.get(0) instanceof Lifeline));
        lifeline = (Lifeline)selection.get(0);
        Assert.assertEquals((String)"find", (Object)"player2", (Object)lifeline.getName());
        fFacility.getLoader().cancel();
    }

    @Test
    public void verifyCancelSearch() {
        fFacility.firstPage();
        criteria = new Criteria();
        criteria.setLifeLineSelected(true);
        criteria.setExpression("player2");
        fFacility.getLoader().find(criteria);
        fFacility.delay(200L);
        fFacility.getLoader().cancel();
        Assert.assertEquals((String)"find", (long)0L, (long)fFacility.getLoader().currentPage());
        fFacility.getLoader().cancel();
        fFacility.firstPage();
    }
}

