/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfEventParser;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.ui.tests.uml2sd.trace.TmfUml2SDTestTrace;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterCriteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterListDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.load.LoadersManager;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfUml2SDSyncLoader;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Uml2SDTestFacility {
    private static Uml2SDTestFacility fInstance = null;
    private TmfUml2SDSyncLoader fLoader;
    private SDView fSdView;
    private TmfTraceStub fTrace = null;
    private TmfUml2SDTestTrace fParser = null;
    private TmfExperiment fExperiment = null;
    private volatile boolean fIsInitialized = false;

    private Uml2SDTestFacility() {
    }

    public static synchronized Uml2SDTestFacility getInstance() {
        if (fInstance == null) {
            fInstance = new Uml2SDTestFacility();
            fInstance.init();
        }
        return fInstance;
    }

    public void init() {
        if (!this.fIsInitialized) {
            IViewPart view;
            this.fParser = new TmfUml2SDTestTrace();
            this.fTrace = this.setupTrace(this.fParser);
            this.fParser.setTrace((ITmfTrace)this.fTrace);
            try {
                view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.internal.introview");
                if (view != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(view);
                }
                view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.tmf.ui.tmfUml2SDSyncView");
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
            this.fSdView = (SDView)view;
            this.fLoader = (TmfUml2SDSyncLoader)LoadersManager.getInstance().createLoader("org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfUml2SDSyncLoader", this.fSdView);
            this.delay(3000L);
            this.fIsInitialized = true;
        }
    }

    private TmfTraceStub setupTrace(ITmfEventParser parser) {
        try {
            URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("tracesets/sdEvents"), null);
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            return new TmfTraceStub(test.getPath(), 500, true, parser);
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        if (this.fIsInitialized) {
            TmfTraceStub trace = this.fTrace;
            TmfExperiment experiment = this.fExperiment;
            if (trace == null || experiment == null) {
                throw new IllegalStateException();
            }
            trace.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)experiment));
            experiment.dispose();
            this.waitForJobs();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.fSdView);
            this.fIsInitialized = false;
        }
    }

    public void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (!display.readAndDispatch()) {
                    try {
                        Thread.sleep(Math.min(waitTimeMillis, 10L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                display.update();
            }
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void waitForJobs() {
        while (!Job.getJobManager().isIdle()) {
            this.delay(1000L);
        }
    }

    public TmfUml2SDSyncLoader getLoader() {
        return this.fLoader;
    }

    public SDView getSdView() {
        return this.fSdView;
    }

    public TmfTraceStub getTrace() {
        return this.fTrace;
    }

    public TmfUml2SDTestTrace getParser() {
        return this.fParser;
    }

    public TmfExperiment getExperiment() {
        return this.fExperiment;
    }

    public void nextPage() {
        this.fLoader.nextPage();
        this.fLoader.waitForCompletion();
        this.delay(1000L);
    }

    public void prevPage() {
        this.fLoader.prevPage();
        this.fLoader.waitForCompletion();
        this.delay(1000L);
    }

    public void lastPage() {
        this.fLoader.lastPage();
        this.fLoader.waitForCompletion();
        this.delay(1000L);
    }

    public void firstPage() {
        this.fLoader.firstPage();
        this.fLoader.waitForCompletion();
        this.delay(1000L);
    }

    public void setPage(int page) {
        this.fLoader.pageNumberChanged(page);
        this.fLoader.waitForCompletion();
        this.delay(1000L);
    }

    public void selectExperiment() {
        this.selectExperiment(true);
    }

    public void selectExperiment(boolean wait) {
        this.fParser = new TmfUml2SDTestTrace();
        this.fTrace = this.setupTrace(this.fParser);
        this.fParser.setTrace((ITmfTrace)this.fTrace);
        ITmfTrace[] traces = new ITmfTrace[]{this.fTrace};
        this.fExperiment = new TmfExperiment(ITmfEvent.class, "TestExperiment", traces, 5000, null){

            protected ITmfTraceIndexer createIndexer(int interval) {
                return new TmfCheckpointIndexer((ITmfTrace)this, interval);
            }
        };
        this.fTrace.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)this.fExperiment, null));
        this.fTrace.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, (ITmfTrace)this.fExperiment));
        if (wait) {
            while (this.fExperiment.getNbEvents() == 0L) {
                this.delay(1000L);
            }
            this.waitForJobs();
            this.delay(1000L);
        }
    }

    public void disposeExperiment() {
        TmfTraceStub trace = this.fTrace;
        TmfExperiment experiment = this.fExperiment;
        if (trace == null || experiment == null) {
            throw new IllegalStateException();
        }
        trace.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)experiment));
        experiment.dispose();
        this.delay(1000L);
    }

    public void createFilterCriteria() {
        ArrayList<FilterCriteria> filterToSave = new ArrayList<FilterCriteria>();
        Criteria criteria = new Criteria();
        criteria.setLifeLineSelected(true);
        criteria.setExpression("player1");
        filterToSave.add(new FilterCriteria(criteria, true, false));
        criteria = new Criteria();
        criteria.setSyncMessageSelected(true);
        criteria.setExpression("BALL_.*");
        filterToSave.add(new FilterCriteria(criteria, true, false));
        FilterListDialog.saveFiltersCriteria(filterToSave);
    }
}

