/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPFunctionScope
extends CPPScope
implements ICPPFunctionScope {
    private CharArrayObjectMap<ILabel> labels = CharArrayObjectMap.emptyMap();

    public CPPFunctionScope(IASTFunctionDeclarator physicalNode) {
        super(physicalNode);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eLocal;
    }

    @Override
    public void addBinding(IBinding binding) {
        if (!(binding instanceof ILabel)) {
            return;
        }
        if (this.labels == CharArrayObjectMap.EMPTY_MAP) {
            this.labels = new CharArrayObjectMap(2);
        }
        this.labels.put(binding.getNameCharArray(), (ILabel)binding);
    }

    @Override
    public IBinding[] find(String name) {
        IBinding[] additional;
        char[] n = name.toCharArray();
        ArrayList<IBinding> bindings = new ArrayList<IBinding>();
        int i = 0;
        while (i < this.labels.size()) {
            char[] key = this.labels.keyAt(i);
            if (CharArrayUtils.equals(key, n)) {
                bindings.add(this.labels.get(key));
            }
            ++i;
        }
        IBinding[] iBindingArray = additional = super.find(name);
        int n2 = additional.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding element = iBindingArray[n3];
            bindings.add(element);
            ++n3;
        }
        return bindings.toArray(new IBinding[bindings.size()]);
    }

    @Override
    public IScope getParent() {
        IASTFunctionDeclarator fdtor = (IASTFunctionDeclarator)this.getPhysicalNode();
        IASTName name = fdtor.getName().getLastName();
        return CPPVisitor.getContainingNonTemplateScope(name);
    }

    @Override
    public IScope getBodyScope() {
        IASTStatement body;
        IASTFunctionDeclarator fnDtor = (IASTFunctionDeclarator)this.getPhysicalNode();
        IASTNode parent = fnDtor.getParent();
        if (parent instanceof IASTFunctionDefinition && (body = ((IASTFunctionDefinition)parent).getBody()) instanceof IASTCompoundStatement) {
            return ((IASTCompoundStatement)body).getScope();
        }
        return null;
    }

    @Override
    public IName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof IASTDeclarator) {
            return ((IASTDeclarator)node).getName();
        }
        return null;
    }
}

