/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.TextEditUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ChangeFormatter {
    public static MultiTextEdit formatChangedCode(String code, ITranslationUnit tu, MultiTextEdit rootEdit) {
        Document document = new Document(code);
        try {
            int newEnd;
            TextEdit edit = rootEdit.copy();
            edit.apply((IDocument)document, 2);
            TextEdit[] appliedEdits = edit.getChildren();
            TextEdit[] edits = rootEdit.copy().removeChildren();
            IRegion[] regions = new IRegion[appliedEdits.length];
            int numRegions = 0;
            int prevEnd = -1;
            int i = 0;
            while (i < appliedEdits.length) {
                edit = appliedEdits[i];
                int offset = edit.getOffset();
                int end = offset + edit.getLength();
                int newOffset = document.getLineInformationOfOffset(offset).getOffset();
                edit = edits[i];
                int originalEnd = edit.getExclusiveEnd();
                IRegion lineInfo = document.getLineInformationOfOffset(end);
                newEnd = lineInfo.getOffset();
                int n = newEnd = (originalEnd == 0 || code.charAt(originalEnd - 1) == '\n') && end == newEnd ? end : ChangeFormatter.endOffset(lineInfo);
                if (newOffset <= prevEnd && numRegions > 0) {
                    newOffset = regions[--numRegions].getOffset();
                }
                prevEnd = newEnd;
                if (newEnd != newOffset) {
                    regions[numRegions] = new Region(newOffset, newEnd - newOffset);
                    ++numRegions;
                }
                ++i;
            }
            if (numRegions == 0) {
                return rootEdit;
            }
            if (numRegions < regions.length) {
                regions = Arrays.copyOf(regions, numRegions);
            }
            ICProject project = tu.getCProject();
            HashMap<String, String> options = new HashMap<String, String>(project.getOptions(true));
            options.put("org.eclipse.cdt.core.formatter.current_translation_unit", (String)((Object)tu));
            options.put("org.eclipse.cdt.core.formatter.comment.never_indent_line_comments_on_first_column", "false");
            CodeFormatter formatter = ToolFactory.createCodeFormatter(options);
            code = document.get();
            TextEdit[] formatEdits = formatter.format(8, code, regions, TextUtilities.getDefaultLineDelimiter((IDocument)document));
            MultiTextEdit combinedFormatEdit = new MultiTextEdit();
            TextEdit[] textEditArray = formatEdits;
            int n = formatEdits.length;
            newEnd = 0;
            while (newEnd < n) {
                TextEdit formatEdit = textEditArray[newEnd];
                combinedFormatEdit = TextEditUtil.merge((TextEdit)combinedFormatEdit, formatEdit);
                ++newEnd;
            }
            formatEdits = TextEditUtil.flatten((TextEdit)combinedFormatEdit).removeChildren();
            MultiTextEdit result = new MultiTextEdit();
            int delta = 0;
            TextEdit edit1 = null;
            TextEdit edit2 = null;
            int i2 = 0;
            int j = 0;
            while (true) {
                if (edit1 == null && i2 < edits.length) {
                    edit1 = edits[i2++];
                }
                if (edit2 == null && j < formatEdits.length) {
                    edit2 = formatEdits[j++];
                }
                if (edit1 == null) {
                    if (edit2 == null) break;
                    edit2.moveTree(-delta);
                    result.addChild(edit2);
                    edit2 = null;
                    continue;
                }
                if (edit2 == null) {
                    delta += TextEditUtil.delta(edit1);
                    result.addChild(edit1);
                    edit1 = null;
                    continue;
                }
                if (edit2.getExclusiveEnd() - delta <= edit1.getOffset()) {
                    edit2.moveTree(-delta);
                    result.addChild(edit2);
                    edit2 = null;
                    continue;
                }
                TextEdit piece = ChangeFormatter.clippedEdit(edit2, (IRegion)new Region(-1, edit1.getOffset() + delta));
                if (piece != null) {
                    piece.moveTree(-delta);
                    result.addChild(piece);
                }
                int d = TextEditUtil.delta(edit1);
                Region region = new Region(edit1.getOffset() + delta, edit1.getLength() + d);
                int end = ChangeFormatter.endOffset((IRegion)region);
                MultiTextEdit format = new MultiTextEdit();
                while ((piece = ChangeFormatter.clippedEdit(edit2, (IRegion)region)) != null) {
                    format.addChild(piece);
                    if (edit2 != null && (edit2.getExclusiveEnd() >= end || j >= formatEdits.length)) break;
                    edit2 = formatEdits[j++];
                }
                if (format.hasChildren()) {
                    format.moveTree(-delta);
                    edit1 = ChangeFormatter.applyEdit((TextEdit)format, edit1);
                }
                delta += d;
                result.addChild(edit1);
                edit1 = null;
                edit2 = ChangeFormatter.clippedEdit(edit2, (IRegion)new Region(end, Integer.MAX_VALUE - end));
            }
            return result;
        }
        catch (MalformedTreeException e) {
            CCorePlugin.log(e);
        }
        catch (BadLocationException e) {
            CCorePlugin.log(e);
        }
        return rootEdit;
    }

    private static TextEdit clippedEdit(TextEdit edit, IRegion region) {
        if (edit.getOffset() < region.getOffset() && edit.getExclusiveEnd() <= region.getOffset() || edit.getOffset() >= ChangeFormatter.endOffset(region)) {
            return null;
        }
        int offset = Math.max(edit.getOffset(), region.getOffset());
        int length = Math.min(ChangeFormatter.endOffset(edit), ChangeFormatter.endOffset(region)) - offset;
        if (offset == edit.getOffset() && length == edit.getLength()) {
            return edit;
        }
        if (edit instanceof DeleteEdit) {
            return new DeleteEdit(offset, length);
        }
        if (edit instanceof ReplaceEdit) {
            String replacement = ((ReplaceEdit)edit).getText();
            int start = Math.max(offset - edit.getOffset(), 0);
            int end = Math.min(ChangeFormatter.endOffset(region) - offset, replacement.length());
            if (end <= start) {
                return new DeleteEdit(offset, length);
            }
            return new ReplaceEdit(offset, length, replacement.substring(start, end));
        }
        throw new IllegalArgumentException("Unexpected edit type: " + edit.getClass().getSimpleName());
    }

    private static TextEdit applyEdit(TextEdit source, TextEdit target) throws MalformedTreeException, BadLocationException {
        source.moveTree(-target.getOffset());
        String text = target instanceof InsertEdit ? ((InsertEdit)target).getText() : (target instanceof ReplaceEdit ? ((ReplaceEdit)target).getText() : "");
        Document document = new Document(text);
        source.apply((IDocument)document, 0);
        text = document.get();
        if (target.getLength() == 0) {
            return new InsertEdit(target.getOffset(), text);
        }
        return new ReplaceEdit(target.getOffset(), target.getLength(), text);
    }

    private static int endOffset(TextEdit edit) {
        return edit.getOffset() + edit.getLength();
    }

    private static int endOffset(IRegion region) {
        return region.getOffset() + region.getLength();
    }
}

