/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.memory.provisional;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.IPersistableDebugElement;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStatusMonitor;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractVirtualContentTableModel;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncCopyTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncPrintTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingCellModifier;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingViewer;
import org.eclipse.debug.internal.ui.views.memory.renderings.CopyTableRenderingToClipboardAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.FormatTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.FormatTableRenderingDialog;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressComposite;
import org.eclipse.debug.internal.ui.views.memory.renderings.IPresentationErrorListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.IVirtualContentListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.internal.ui.views.memory.renderings.PendingPropertyChanges;
import org.eclipse.debug.internal.ui.views.memory.renderings.PrintTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.ReformatAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.ResetToBaseAddressAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryBlockTablePresentation;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractAsyncTableRendering
extends AbstractBaseTableRendering
implements IPropertyChangeListener,
IResettableMemoryRendering {
    public static final String PROPERTY_SELECTED_ADDRESS = "selectedAddress";
    public static final String PROPERTY_COL_SIZE = "columnSize";
    public static final String PROPERTY_TOP_ADDRESS = "topAddress";
    private static final String ID_ASYNC_TABLE_RENDERING_CONTEXT = "org.eclipse.debug.ui.memory.abstractasynctablerendering";
    private static final String ID_GO_TO_ADDRESS_COMMAND = "org.eclipse.debug.ui.command.gotoaddress";
    private static final String ID_NEXT_PAGE_COMMAND = "org.eclipse.debug.ui.command.nextpage";
    private static final String ID_PREV_PAGE_COMMAND = "org.eclipse.debug.ui.command.prevpage";
    public static final String PROPERTY_ROW_SIZE = "rowSize";
    private static final int DEFAULT_BUFFER_THRESHOLD = 1;
    private boolean fActivated = false;
    private PageBook fPageBook;
    private AsyncTableRenderingViewer fTableViewer;
    private TextViewer fTextViewer;
    private Shell fToolTipShell;
    private MemoryViewPresentationContext fPresentationContext;
    private int fAddressableSize;
    private TableRenderingContentDescriptor fContentDescriptor;
    private int fBytePerLine;
    private int fColumnSize;
    private boolean fShowMessage = false;
    private String fLabel;
    private IWorkbenchAdapter fWorkbenchAdapter;
    private int fPageSize;
    private int fPreBufferSize = -1;
    private int fPostBufferSize = -1;
    private SashForm fSashForm;
    private GoToAddressComposite fGoToAddressComposite;
    private GoToAddressAction fGoToAddressAction;
    private PrintTableRenderingAction fPrintViewTabAction;
    private CopyTableRenderingToClipboardAction fCopyToClipboardAction;
    private FormatTableRenderingAction fFormatRenderingAction;
    private ReformatAction fReformatAction;
    private ToggleAddressColumnAction fToggleAddressColumnAction;
    private ResetToBaseAddressAction fResetMemoryBlockAction;
    private PropertyDialogAction fPropertiesDialogAction;
    private NextPageAction fNextAction;
    private PrevPageAction fPrevAction;
    private ArrayList<IContextActivation> fContext = new ArrayList();
    private AbstractHandler fGoToAddressHandler;
    private AbstractHandler fNextPageHandler;
    private AbstractHandler fPrevPageHandler;
    private boolean fIsCreated = false;
    private boolean fIsDisposed = false;
    private boolean fIsShowAddressColumn = true;
    private SwitchPageJob fSwitchPageJob = new SwitchPageJob();
    private boolean fError = false;
    private PendingPropertyChanges fPendingSyncProperties;
    private ArrayList<IMenuListener> fMenuListeners;
    private MenuManager fMenuMgr;
    private ISchedulingRule serialByRenderingRule = new SerialByObjectRule(this);
    public static final String EMPTY_MEMORY_GROUP = "popUpBegin";
    public static final String EMPTY_NAVIGATION_GROUP = "navigationGroup";
    public static final String EMPTY_NON_AUTO_LOAD_GROUP = "nonAutoLoadGroup";
    public static final String EMPTY_PROPERTY_GROUP = "propertyGroup";
    private ISelectionChangedListener fViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractAsyncTableRendering.this.updateSyncTopAddress(AbstractAsyncTableRendering.this.getTopVisibleAddress());
            AbstractAsyncTableRendering.this.updateSyncSelectedAddress(AbstractAsyncTableRendering.this.getSelectedAddress());
        }
    };
    private SelectionAdapter fScrollBarSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AbstractAsyncTableRendering.this.updateSyncTopAddress(AbstractAsyncTableRendering.this.getTopVisibleAddress());
        }
    };
    private IModelChangedListener fModelChangedListener = new IModelChangedListener(){

        @Override
        public void modelChanged(IModelDelta delta, IModelProxy proxy) {
            if (delta.getElement() == AbstractAsyncTableRendering.this.getMemoryBlock()) {
                AbstractAsyncTableRendering.this.showTable();
                AbstractAsyncTableRendering.this.updateRenderingLabel(AbstractAsyncTableRendering.this.isVisible());
            }
        }
    };
    private IVirtualContentListener fViewerListener = new IVirtualContentListener(){
        private int startThreshold;
        private int endThreshold;

        @Override
        public void handledAtBufferStart() {
            BigInteger address;
            if (AbstractAsyncTableRendering.this.getMemoryBlock() instanceof IMemoryBlockExtension && AbstractAsyncTableRendering.this.isDynamicLoad() && this.startThreshold != 0 && (address = AbstractAsyncTableRendering.this.getTopVisibleAddress()) != null && !AbstractAsyncTableRendering.this.isAtTopLimit()) {
                AbstractAsyncTableRendering.this.reloadTable(address);
            }
        }

        @Override
        public void handleAtBufferEnd() {
            BigInteger address;
            if (AbstractAsyncTableRendering.this.getMemoryBlock() instanceof IMemoryBlockExtension && AbstractAsyncTableRendering.this.isDynamicLoad() && this.endThreshold != 0 && (address = AbstractAsyncTableRendering.this.getTopVisibleAddress()) != null && !AbstractAsyncTableRendering.this.isAtBottomLimit()) {
                AbstractAsyncTableRendering.this.reloadTable(address);
            }
        }

        @Override
        public int getThreshold(int bufferEndOrStart) {
            int threshold = 1;
            if (bufferEndOrStart == 0) {
                if (threshold > AbstractAsyncTableRendering.this.getPreBufferSize()) {
                    threshold = AbstractAsyncTableRendering.this.getPreBufferSize();
                }
            } else if (threshold > AbstractAsyncTableRendering.this.getPostBufferSize()) {
                threshold = AbstractAsyncTableRendering.this.getPostBufferSize();
            }
            if (bufferEndOrStart == 0) {
                this.startThreshold = threshold;
            } else {
                this.endThreshold = threshold;
            }
            return threshold;
        }
    };
    private IPresentationErrorListener fPresentationErrorListener = new IPresentationErrorListener(){

        @Override
        public void handlePresentationFailure(IStatusMonitor monitor, IStatus status) {
            AbstractAsyncTableRendering.this.showMessage(status.getMessage());
        }
    };

    public AbstractAsyncTableRendering(String renderingId) {
        super(renderingId);
    }

    @Override
    public void resetRendering() throws DebugException {
        if (!this.fIsCreated) {
            return;
        }
        BigInteger baseAddress = this.fContentDescriptor.getContentBaseAddress();
        this.fTableViewer.setSelection(baseAddress);
        this.reloadTable(baseAddress);
        this.fTableViewer.setTopIndex(baseAddress);
        if (!this.isDynamicLoad()) {
            this.updateSyncPageStartAddress(baseAddress);
        }
        this.updateSyncSelectedAddress(baseAddress);
        this.updateSyncTopAddress(baseAddress);
    }

    @Override
    public Control createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.createMessagePage((Composite)this.fPageBook);
        this.createTableViewer((Composite)this.fPageBook);
        this.addListeners();
        return this.fPageBook;
    }

    private void createMessagePage(Composite parent) {
        if (this.fTextViewer == null) {
            this.fTextViewer = new TextViewer(parent, 64);
            this.fTextViewer.setDocument((IDocument)new Document());
            StyledText styleText = this.fTextViewer.getTextWidget();
            styleText.setEditable(false);
            styleText.setEnabled(false);
        }
    }

    private void createTableViewer(final Composite parent) {
        StringBuffer buffer = new StringBuffer();
        IMemoryRenderingType type = DebugUITools.getMemoryRenderingManager().getRenderingType(this.getRenderingId());
        buffer.append(type.getLabel());
        buffer.append(": ");
        buffer.append(DebugUIMessages.AbstractAsyncTableRendering_2);
        Job job = new Job(buffer.toString()){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractAsyncTableRendering.this.initAddressableSize();
                final BigInteger topVisibleAddress = AbstractAsyncTableRendering.this.getInitialTopVisibleAddress();
                BigInteger mbBaseAddress = null;
                try {
                    mbBaseAddress = AbstractAsyncTableRendering.this.getMemoryBlockBaseAddress();
                }
                catch (DebugException e) {
                    AbstractAsyncTableRendering.this.fError = true;
                    AbstractAsyncTableRendering.this.showMessage(e.getMessage());
                }
                if (monitor.isCanceled()) {
                    AbstractAsyncTableRendering.this.getMemoryRenderingContainer().removeMemoryRendering(AbstractAsyncTableRendering.this);
                    return Status.CANCEL_STATUS;
                }
                final BigInteger finalMbBaseAddress = mbBaseAddress;
                final BigInteger initialSelectedAddress = AbstractAsyncTableRendering.this.getInitialSelectedAddress();
                if (monitor.isCanceled()) {
                    AbstractAsyncTableRendering.this.getMemoryRenderingContainer().removeMemoryRendering(AbstractAsyncTableRendering.this);
                    return Status.CANCEL_STATUS;
                }
                AbstractAsyncTableRendering.this.createContentDescriptor(topVisibleAddress);
                if (monitor.isCanceled()) {
                    AbstractAsyncTableRendering.this.getMemoryRenderingContainer().removeMemoryRendering(AbstractAsyncTableRendering.this);
                    return Status.CANCEL_STATUS;
                }
                UIJob uiJob = new UIJob("Create Table Viewer UI Job"){

                    public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                        BigInteger baseAddress;
                        if (AbstractAsyncTableRendering.this.fPageBook.isDisposed()) {
                            return Status.OK_STATUS;
                        }
                        AbstractAsyncTableRendering.this.fSashForm = new SashForm(parent, 512);
                        AbstractAsyncTableRendering.this.fTableViewer = new AsyncTableRenderingViewer(AbstractAsyncTableRendering.this, (Composite)AbstractAsyncTableRendering.this.fSashForm, 268471044);
                        GridData data = new GridData(1808);
                        AbstractAsyncTableRendering.this.fTableViewer.getControl().setLayoutData((Object)data);
                        AbstractAsyncTableRendering.this.createGoToAddressComposite((Composite)AbstractAsyncTableRendering.this.fSashForm);
                        AbstractAsyncTableRendering.this.hideGotoAddressComposite();
                        IMemoryRenderingSite site = AbstractAsyncTableRendering.this.getMemoryRenderingContainer().getMemoryRenderingSite();
                        IMemoryRenderingContainer container = AbstractAsyncTableRendering.this.getMemoryRenderingContainer();
                        AbstractAsyncTableRendering.this.fPresentationContext = new MemoryViewPresentationContext(site, container, AbstractAsyncTableRendering.this);
                        AbstractAsyncTableRendering.this.fTableViewer.setContext(AbstractAsyncTableRendering.this.fPresentationContext);
                        AbstractAsyncTableRendering.this.getDynamicLoadFromPreference();
                        AbstractAsyncTableRendering.this.getPageSizeFromPreference();
                        int numberOfLines = AbstractAsyncTableRendering.this.getNumLinesToLoad();
                        AbstractAsyncTableRendering.this.fContentDescriptor.setNumLines(numberOfLines);
                        if (numberOfLines == 0) {
                            AbstractAsyncTableRendering.this.fTableViewer.getTable().addPaintListener(new PaintListener(){

                                public void paintControl(PaintEvent e) {
                                    AbstractAsyncTableRendering.this.fTableViewer.getTable().removePaintListener((PaintListener)this);
                                    AbstractAsyncTableRendering.this.fContentDescriptor.setNumLines(AbstractAsyncTableRendering.this.getNumLinesToLoad());
                                    AbstractAsyncTableRendering.this.refresh();
                                }
                            });
                        }
                        if ((baseAddress = finalMbBaseAddress) == null) {
                            baseAddress = BigInteger.ZERO;
                        }
                        if (!(AbstractAsyncTableRendering.this.getMemoryBlock() instanceof IMemoryBlockExtension) || !AbstractAsyncTableRendering.this.isDynamicLoad()) {
                            AbstractAsyncTableRendering.this.fContentDescriptor.setPreBuffer(0);
                            AbstractAsyncTableRendering.this.fContentDescriptor.setPostBuffer(0);
                        }
                        AbstractAsyncTableRendering.this.setupInitialFormat();
                        AbstractAsyncTableRendering.this.fTableViewer.setCellModifier(AbstractAsyncTableRendering.this.newInternalCellModifier());
                        AbstractAsyncTableRendering.this.fTableViewer.getTable().setHeaderVisible(true);
                        AbstractAsyncTableRendering.this.fTableViewer.getTable().setLinesVisible(true);
                        AbstractAsyncTableRendering.this.fTableViewer.addPresentationErrorListener(AbstractAsyncTableRendering.this.fPresentationErrorListener);
                        AbstractAsyncTableRendering.this.fTableViewer.setInput(AbstractAsyncTableRendering.this.getMemoryBlock());
                        AbstractAsyncTableRendering.this.fTableViewer.resizeColumnsToPreferredSize();
                        AbstractAsyncTableRendering.this.fTableViewer.setTopIndex(topVisibleAddress);
                        AbstractAsyncTableRendering.this.fTableViewer.setSelection(initialSelectedAddress);
                        AbstractAsyncTableRendering.this.fTableViewer.getTable().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
                        if (!AbstractAsyncTableRendering.this.fError) {
                            AbstractAsyncTableRendering.this.showTable();
                        }
                        AbstractAsyncTableRendering.this.fTableViewer.addVirtualContentListener(AbstractAsyncTableRendering.this.fViewerListener);
                        AbstractAsyncTableRendering.this.createActions();
                        IMenuListener menuListener = new IMenuListener(){

                            public void menuAboutToShow(IMenuManager mgr) {
                                AbstractAsyncTableRendering.this.fillContextMenu(mgr);
                            }
                        };
                        AbstractAsyncTableRendering.this.createPopupMenu(AbstractAsyncTableRendering.this.fTableViewer.getControl(), menuListener);
                        AbstractAsyncTableRendering.this.createPopupMenu((Control)AbstractAsyncTableRendering.this.fTableViewer.getCursor(), menuListener);
                        AbstractAsyncTableRendering.this.fTableViewer.addSelectionChangedListener(AbstractAsyncTableRendering.this.fViewerSelectionChangedListener);
                        AbstractAsyncTableRendering.this.fTableViewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)AbstractAsyncTableRendering.this.fScrollBarSelectionListener);
                        AbstractAsyncTableRendering.this.fTableViewer.getTable().addListener(11, new Listener(){

                            public void handleEvent(Event event) {
                                if (!AbstractAsyncTableRendering.this.fTableViewer.getTable().isDisposed()) {
                                    AbstractAsyncTableRendering.this.fContentDescriptor.setNumLines(AbstractAsyncTableRendering.this.getNumLinesToLoad());
                                }
                            }
                        });
                        AbstractAsyncTableRendering.this.createToolTip();
                        if (AbstractAsyncTableRendering.this.isActivated()) {
                            AbstractAsyncTableRendering.this.activatePageActions();
                        }
                        AbstractAsyncTableRendering.this.fIsCreated = true;
                        return Status.OK_STATUS;
                    }
                };
                uiJob.setSystem(true);
                uiJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void createPopupMenu(Control control, IMenuListener menuListener) {
        IMemoryRenderingContainer container = this.getMemoryRenderingContainer();
        if (this.fMenuMgr == null) {
            this.fMenuMgr = new MenuManager("#PopupMenu");
            this.fMenuMgr.setRemoveAllWhenShown(true);
            IMemoryRenderingSite site = container.getMemoryRenderingSite();
            String menuId = container.getId();
            ISelectionProvider selProvider = site.getSite().getSelectionProvider();
            this.addMenuListener(menuListener);
            site.getSite().registerContextMenu(menuId, this.fMenuMgr, selProvider);
        }
        this.addMenuListener(menuListener);
        Menu popupMenu = this.fMenuMgr.createContextMenu(control);
        control.setMenu(popupMenu);
    }

    private void addMenuListener(IMenuListener menuListener) {
        if (this.fMenuListeners == null) {
            this.fMenuListeners = new ArrayList();
        }
        if (!this.fMenuListeners.contains(menuListener)) {
            this.fMenuMgr.addMenuListener(menuListener);
            this.fMenuListeners.add(menuListener);
        }
    }

    private BigInteger getInitialSelectedAddress() {
        BigInteger selectedAddress = (BigInteger)this.getSynchronizedProperty(PROPERTY_SELECTED_ADDRESS);
        if (selectedAddress == null) {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                try {
                    selectedAddress = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
                }
                catch (DebugException debugException) {
                    selectedAddress = BigInteger.ZERO;
                }
                if (selectedAddress == null) {
                    selectedAddress = BigInteger.ZERO;
                }
            } else {
                long address = this.getMemoryBlock().getStartAddress();
                selectedAddress = BigInteger.valueOf(address);
            }
        }
        return selectedAddress;
    }

    private void addListeners() {
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.addRenderingToSyncService();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    private void removeListeners() {
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.removeRenderingFromSyncService();
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        if (this.fMenuListeners != null) {
            Iterator<IMenuListener> iter = this.fMenuListeners.iterator();
            while (iter.hasNext()) {
                this.fMenuMgr.removeMenuListener(iter.next());
            }
            this.fMenuListeners.clear();
        }
    }

    private void addRenderingToSyncService() {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return;
        }
        syncService.addPropertyChangeListener(this, null);
    }

    private void removeRenderingFromSyncService() {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return;
        }
        syncService.removePropertyChangeListener(this);
    }

    private void initAddressableSize() {
        this.fAddressableSize = -1;
        try {
            this.fAddressableSize = this.getMemoryBlock() instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.getMemoryBlock()).getAddressableSize() : 1;
        }
        catch (DebugException e1) {
            DebugUIPlugin.log(e1);
            this.fAddressableSize = 1;
            return;
        }
        if (this.fAddressableSize < 1) {
            DebugUIPlugin.logErrorMessage("Invalid addressable size");
            this.fAddressableSize = 1;
        }
    }

    private BigInteger getInitialTopVisibleAddress() {
        BigInteger topVisibleAddress = (BigInteger)this.getSynchronizedProperty(PROPERTY_TOP_ADDRESS);
        if (topVisibleAddress == null) {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                try {
                    topVisibleAddress = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
                }
                catch (DebugException debugException) {
                    topVisibleAddress = new BigInteger("0");
                }
            } else {
                topVisibleAddress = BigInteger.valueOf(this.getMemoryBlock().getStartAddress());
            }
        }
        return topVisibleAddress;
    }

    private void setupInitialFormat() {
        boolean validated = this.validateInitialFormat();
        if (!validated) {
            StringBuffer msgBuffer = new StringBuffer(DebugUIMessages.AbstractTableRendering_20);
            msgBuffer.append(" ");
            msgBuffer.append(this.getLabel());
            msgBuffer.append("\n\n");
            msgBuffer.append(DebugUIMessages.AbstractTableRendering_16);
            msgBuffer.append("\n");
            msgBuffer.append(DebugUIMessages.AbstractTableRendering_18);
            msgBuffer.append("\n\n");
            int bytePerLine = this.fBytePerLine;
            int columnSize = this.fColumnSize;
            this.fBytePerLine = this.getDefaultRowSize() / this.getAddressableSize();
            this.fColumnSize = this.getDefaultColumnSize() / this.getAddressableSize();
            FormatTableRenderingDialog dialog = new FormatTableRenderingDialog(this, DebugUIPlugin.getShell());
            dialog.openError(msgBuffer.toString());
            this.fBytePerLine = bytePerLine;
            this.fColumnSize = columnSize;
            bytePerLine = dialog.getRowSize() * this.getAddressableSize();
            columnSize = dialog.getColumnSize() * this.getAddressableSize();
            this.format(bytePerLine, columnSize);
        } else {
            int columnSize;
            int bytePerLine = this.getDefaultRowSize();
            boolean ok = this.format(bytePerLine, columnSize = this.getDefaultColumnSize());
            if (!ok) {
                this.format(bytePerLine, bytePerLine);
            }
        }
    }

    private boolean validateInitialFormat() {
        int columnSize;
        int rowSize = this.getDefaultRowSize();
        return rowSize >= (columnSize = this.getDefaultColumnSize()) && rowSize % columnSize == 0 && rowSize != 0 && columnSize != 0;
    }

    @Override
    public Control getControl() {
        return this.fPageBook;
    }

    public void propertyChange(PropertyChangeEvent event) {
        IMemoryRendering rendering;
        IMemoryBlock memoryBlock;
        if (!this.fIsCreated) {
            return;
        }
        if (event.getProperty().equals("org.eclipse.debug.ui.MemoryViewTableFont")) {
            if (!this.fIsDisposed) {
                Font memoryViewFont = JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont");
                this.setFont(memoryViewFont);
            }
            return;
        }
        Object evtSrc = event.getSource();
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize")) {
            this.getPageSizeFromPreference();
        }
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.preBufferSize")) {
            this.getPreBufferSizeFromPreference();
            this.fContentDescriptor.setPreBuffer(this.getPreBufferSize());
        }
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.postBufferSize")) {
            this.getPostBufferSizeFromPreference();
            this.fContentDescriptor.setPostBuffer(this.getPostBufferSize());
        }
        if (this.isDisplayingError() || !this.isVisible()) {
            this.handlePropertiesChangeWhenHidden(event);
            return;
        }
        if (event.getProperty().equals("org.eclipse.debug.ui.memory.paddedStr") || event.getProperty().equals("org.eclipse.debug.ui.changedDebugElement") || event.getProperty().equals("org.eclipse.debug.ui.MemoryHistoryKnownColor") || event.getProperty().equals("org.eclipse.debug.ui.MemoryHistoryUnknownColor")) {
            if (!this.fIsDisposed) {
                this.fTableViewer.refresh(false);
            }
            return;
        }
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.preBufferSize") || event.getProperty().equals("org.eclispe.debug.ui.memory.postBufferSize")) {
            if (!this.fIsDisposed) {
                this.fTableViewer.refresh(true);
            }
            return;
        }
        if (event.getProperty().equals("org.eclpise.debug.ui.memory.dynamicLoad")) {
            this.handleDyanicLoadChanged();
            return;
        }
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize")) {
            if (!this.isDynamicLoad()) {
                int pageSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.pageSize");
                this.handlePageSizeChanged(pageSize);
            }
            return;
        }
        if (evtSrc == this) {
            return;
        }
        if (evtSrc instanceof IMemoryRendering && (memoryBlock = (rendering = (IMemoryRendering)evtSrc).getMemoryBlock()) != this.getMemoryBlock()) {
            return;
        }
        String propertyName = event.getProperty();
        Object value = event.getNewValue();
        if (propertyName.equals(PROPERTY_SELECTED_ADDRESS) && value instanceof BigInteger) {
            this.selectedAddressChanged((BigInteger)value);
        } else if (propertyName.equals(PROPERTY_COL_SIZE) && value instanceof Integer) {
            this.columnSizeChanged((Integer)value);
        } else if (propertyName.equals(PROPERTY_ROW_SIZE) && value instanceof Integer) {
            this.rowSizeChanged((Integer)value);
        } else if (propertyName.equals(PROPERTY_TOP_ADDRESS) && value instanceof BigInteger) {
            this.topVisibleAddressChanged((BigInteger)value);
        } else if (propertyName.equals("pageStart") && value instanceof BigInteger) {
            this.handlePageStartAddressChanged((BigInteger)value);
        }
    }

    private void handlePageSizeChanged(int pageSize) {
        this.fPageSize = pageSize;
        this.fContentDescriptor.setNumLines(pageSize);
        this.refresh();
    }

    private void handlePropertiesChangeWhenHidden(PropertyChangeEvent event) {
        IMemoryRendering rendering;
        if (this.fPendingSyncProperties == null) {
            return;
        }
        String propertyName = event.getProperty();
        Object value = event.getNewValue();
        if (event.getSource() instanceof IMemoryRendering && ((rendering = (IMemoryRendering)event.getSource()) == this || rendering.getMemoryBlock() != this.getMemoryBlock())) {
            return;
        }
        if (propertyName.equals(PROPERTY_COL_SIZE) && value instanceof Integer) {
            this.fPendingSyncProperties.setColumnSize((Integer)value);
        } else if (propertyName.equals(PROPERTY_ROW_SIZE) && value instanceof Integer) {
            this.fPendingSyncProperties.setRowSize((Integer)value);
        } else if (propertyName.equals(PROPERTY_SELECTED_ADDRESS) && value instanceof BigInteger) {
            this.fPendingSyncProperties.setSelectedAddress((BigInteger)value);
        } else if (propertyName.equals(PROPERTY_TOP_ADDRESS) && value instanceof BigInteger) {
            this.fPendingSyncProperties.setTopVisibleAddress((BigInteger)value);
        } else if (propertyName.equals("pageStart") && value instanceof BigInteger) {
            this.fPendingSyncProperties.setPageStartAddress((BigInteger)value);
        } else if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize")) {
            int pageSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.pageSize");
            this.fPendingSyncProperties.setPageSize(pageSize);
        }
    }

    private void topVisibleAddressChanged(final BigInteger address) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (AbstractAsyncTableRendering.this.fTableViewer.getTable().isDisposed()) {
                    return;
                }
                AbstractAsyncTableRendering.this.doTopVisibleAddressChanged(address);
            }
        };
        this.runOnUIThread(runnable);
    }

    private void doTopVisibleAddressChanged(BigInteger address) {
        if (this.fIsDisposed) {
            return;
        }
        if (!this.isDynamicLoad()) {
            this.fTableViewer.setTopIndex(address);
            this.fTableViewer.topIndexChanged();
            return;
        }
        if (!this.isAtTopBuffer(address) && !this.isAtBottomBuffer(address)) {
            this.fTableViewer.setTopIndex(address);
            this.fTableViewer.topIndexChanged();
        } else {
            this.reloadTable(address);
        }
    }

    private boolean isAtBottomBuffer(BigInteger address) {
        int idx = this.fTableViewer.indexOf(address);
        if (idx < 0) {
            return true;
        }
        int bottomIdx = idx + this.getNumberOfVisibleLines();
        int elementsCnt = this.fTableViewer.getVirtualContentModel().getElements().length;
        int numLinesLeft = elementsCnt - bottomIdx;
        return numLinesLeft < this.fViewerListener.getThreshold(1);
    }

    private boolean isAtTopBuffer(BigInteger address) {
        int topIdx = this.fTableViewer.indexOf(address);
        return topIdx < this.fViewerListener.getThreshold(0);
    }

    private void runOnUIThread(final Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            UIJob job = new UIJob("Async Table Rendering UI Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    runnable.run();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void selectedAddressChanged(final BigInteger address) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean contained;
                if (AbstractAsyncTableRendering.this.fTableViewer.getTable().isDisposed()) {
                    return;
                }
                int i = AbstractAsyncTableRendering.this.fTableViewer.indexOf(address);
                if (i < 0 && !(contained = AbstractAsyncTableRendering.this.isAddressBufferred(address))) {
                    AbstractAsyncTableRendering.this.topVisibleAddressChanged(address);
                }
                AbstractAsyncTableRendering.this.fTableViewer.setSelection(address);
            }
        };
        this.runOnUIThread(runnable);
    }

    private boolean isAddressBufferred(BigInteger address) {
        BigInteger loadAddress = this.fContentDescriptor.getLoadAddress();
        loadAddress = MemoryViewUtil.alignToBoundary(loadAddress, this.getAddressableUnitPerLine());
        int unitPerLine = this.getAddressableUnitPerLine();
        loadAddress = loadAddress.subtract(BigInteger.valueOf(this.getPreBufferSize() * unitPerLine));
        int numLines = this.fContentDescriptor.getNumLines();
        BigInteger bufferEnd = loadAddress.add(BigInteger.valueOf(this.fContentDescriptor.getPostBuffer() * unitPerLine));
        bufferEnd = bufferEnd.add(BigInteger.valueOf(numLines * unitPerLine + unitPerLine));
        return address.compareTo(loadAddress) >= 0 && address.compareTo(bufferEnd) <= 0;
    }

    private void setFont(Font font) {
        this.fTableViewer.getTable().setFont(font);
        this.fTableViewer.getCursor().setFont(font);
    }

    private int getDefaultColumnSize() {
        IPreferenceStore prefStore = DebugUITools.getPreferenceStore();
        int columnSize = prefStore.getInt("org.eclipse.debug.ui.memory.columnSize");
        columnSize *= this.getAddressableSize();
        Integer colSize = (Integer)this.getSynchronizedProperty(PROPERTY_COL_SIZE);
        if (colSize != null) {
            int syncColSize = colSize;
            if (syncColSize > 0) {
                columnSize = syncColSize;
            }
        } else {
            IPersistableDebugElement elmt = (IPersistableDebugElement)this.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
            int defaultColSize = -1;
            if (elmt != null && elmt.supportsProperty(this, "org.eclipse.debug.ui.AbstractTableRendering.colSize")) {
                defaultColSize = this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.colSize");
            }
            if (defaultColSize <= 0) {
                defaultColSize = this.getDefaultColumnSizeByModel(this.getMemoryBlock().getModelIdentifier());
            }
            if (defaultColSize > 0) {
                columnSize = defaultColSize * this.getAddressableSize();
            }
        }
        return columnSize;
    }

    private int getDefaultRowSize() {
        int rowSize = DebugUITools.getPreferenceStore().getInt("org.eclipse.debug.ui.memory.rowSize");
        int bytePerLine = rowSize * this.getAddressableSize();
        Integer size = (Integer)this.getSynchronizedProperty(PROPERTY_ROW_SIZE);
        if (size != null) {
            int syncRowSize = size;
            if (syncRowSize > 0) {
                bytePerLine = syncRowSize;
            }
        } else {
            int defaultRowSize = -1;
            IPersistableDebugElement elmt = (IPersistableDebugElement)this.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
            if (elmt != null && elmt.supportsProperty(this, "org.eclipse.debug.ui.AbstractTableRendering.rowSize")) {
                defaultRowSize = this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.rowSize");
                return defaultRowSize * this.getAddressableSize();
            }
            if (defaultRowSize <= 0) {
                defaultRowSize = this.getDefaultRowSizeByModel(this.getMemoryBlock().getModelIdentifier());
            }
            if (defaultRowSize > 0) {
                bytePerLine = defaultRowSize * this.getAddressableSize();
            }
        }
        return bytePerLine;
    }

    @Override
    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    private Object getSynchronizedProperty(String propertyId) {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return null;
        }
        return syncService.getProperty(this.getMemoryBlock(), propertyId);
    }

    private int getDefaultFromPersistableElement(String propertyId) {
        int defaultValue = -1;
        IPersistableDebugElement elmt = (IPersistableDebugElement)this.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
        if (elmt != null) {
            try {
                Object valueMB = elmt.getProperty(this, propertyId);
                if (valueMB != null && !(valueMB instanceof Integer)) {
                    IStatus status = DebugUIPlugin.newErrorStatus("Model returned invalid type on " + propertyId, null);
                    DebugUIPlugin.log(status);
                }
                if (valueMB != null) {
                    Integer value = (Integer)valueMB;
                    defaultValue = value;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return defaultValue;
    }

    private int getDefaultRowSizeByModel(String modelId) {
        int row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        if (row == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getRowPrefId(modelId), 16);
        }
        row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        return row;
    }

    private int getDefaultColumnSizeByModel(String modelId) {
        int col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        if (col == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getColumnPrefId(modelId), 4);
        }
        col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        return col;
    }

    private String getRowPrefId(String modelId) {
        String rowPrefId = "org.eclipse.debug.ui.memory.rowSize:" + modelId;
        return rowPrefId;
    }

    private String getColumnPrefId(String modelId) {
        String colPrefId = "org.eclipse.debug.ui.memory.columnSize:" + modelId;
        return colPrefId;
    }

    @Override
    public boolean format(int bytesPerLine, int columnSize) {
        if (bytesPerLine % columnSize != 0) {
            return false;
        }
        if (bytesPerLine < columnSize) {
            return false;
        }
        if (this.fBytePerLine == bytesPerLine && this.fColumnSize == columnSize) {
            return false;
        }
        this.fBytePerLine = bytesPerLine;
        this.fColumnSize = columnSize;
        this.formatViewer();
        this.updateSyncRowSize();
        this.updateSyncColSize();
        return true;
    }

    @Override
    public int getAddressableUnitPerLine() {
        return this.fBytePerLine / this.getAddressableSize();
    }

    @Override
    public int getAddressableUnitPerColumn() {
        return this.fColumnSize / this.getAddressableSize();
    }

    private int getNumberOfVisibleLines() {
        int lineHeight;
        int scroll;
        if (this.fTableViewer == null) {
            return -1;
        }
        Table table = this.fTableViewer.getTable();
        int height = this.fTableViewer.getTable().getSize().y;
        if (height == 0) {
            height = this.fTableViewer.getTable().getParent().getSize().y;
        }
        if (height == 0) {
            return 0;
        }
        int border = this.fTableViewer.getTable().getHeaderHeight();
        int numberOfLines = (height = height - border - (scroll = this.fTableViewer.getTable().getHorizontalBar().getSize().y)) / (lineHeight = this.getMinTableItemHeight(table));
        if (numberOfLines <= 0) {
            return 0;
        }
        return numberOfLines;
    }

    private int getMinTableItemHeight(Table table) {
        if (MemoryViewUtil.isLinuxGTK()) {
            TableItem[] items = table.getItems();
            int minHeight = table.getItemHeight();
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() != null) {
                    minHeight = Math.min(items[i].getBounds((int)0).height, minHeight);
                }
                ++i;
            }
            return minHeight;
        }
        return table.getItemHeight();
    }

    private BigInteger getMemoryBlockBaseAddress() throws DebugException {
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            return ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
        }
        return BigInteger.valueOf(this.getMemoryBlock().getStartAddress());
    }

    protected void showMessage(String message) {
        this.fSwitchPageJob.setShowMessagePage(true);
        this.fSwitchPageJob.setMessage(message);
        this.fSwitchPageJob.schedule();
    }

    @Override
    public int getBytesPerColumn() {
        return this.fColumnSize;
    }

    @Override
    public int getBytesPerLine() {
        return this.fBytePerLine;
    }

    public boolean isDisplayingError() {
        return this.fShowMessage;
    }

    public void showTable() {
        this.fSwitchPageJob.setShowMessagePage(false);
        this.fSwitchPageJob.schedule();
    }

    private BigInteger getTopVisibleAddress() {
        MemorySegment topItem;
        if (this.fTableViewer == null) {
            return BigInteger.valueOf(0L);
        }
        Table table = this.fTableViewer.getTable();
        int topIndex = table.getTopIndex();
        if (topIndex < 0) {
            return null;
        }
        if (table.getItemCount() > topIndex && (topItem = (MemorySegment)((Object)table.getItem(topIndex).getData())) != null) {
            return topItem.getAddress();
        }
        return null;
    }

    private synchronized void reloadTable(BigInteger topAddress) {
        if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
            DebugUIPlugin.trace(this + " reload at: " + topAddress.toString(16));
        }
        this.fContentDescriptor.setLoadAddress(topAddress);
        this.fContentDescriptor.setNumLines(this.getNumLinesToLoad());
        this.fTableViewer.setTopIndex(topAddress);
        this.fTableViewer.refresh();
    }

    private boolean isAtTopLimit() {
        Object key;
        BigInteger startAddress = this.fContentDescriptor.getStartAddress();
        startAddress = MemoryViewUtil.alignToBoundary(startAddress, this.getAddressableUnitPerLine());
        AbstractVirtualContentTableModel model = this.fTableViewer.getVirtualContentModel();
        if (model != null && (key = model.getKey(0)) instanceof BigInteger) {
            BigInteger startBufferAddress = (BigInteger)key;
            if (startAddress.compareTo(startBufferAddress = MemoryViewUtil.alignToBoundary(startBufferAddress, this.getAddressableUnitPerLine())) == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isAtBottomLimit() {
        int numElements;
        Object key;
        BigInteger endAddress = this.fContentDescriptor.getEndAddress();
        endAddress = MemoryViewUtil.alignToBoundary(endAddress, this.getAddressableUnitPerLine());
        AbstractVirtualContentTableModel model = this.fTableViewer.getVirtualContentModel();
        if (model != null && (key = model.getKey((numElements = model.getElements().length) - 1)) instanceof BigInteger) {
            BigInteger endBufferAddress = (BigInteger)key;
            if (endAddress.compareTo(endBufferAddress = MemoryViewUtil.alignToBoundary(endBufferAddress, this.getAddressableUnitPerLine())) == 0) {
                return true;
            }
        }
        return false;
    }

    private void formatViewer() {
        this.fTableViewer.disposeColumns();
        this.fTableViewer.disposeCellEditors();
        this.doFormatTable();
        this.fTableViewer.setColumnHeaders(this.getColumnProperties());
        this.fTableViewer.showColumnHeader(true);
        Table table = this.fTableViewer.getTable();
        int colCnt = table.getColumnCount();
        CellEditor[] editors = new CellEditor[this.fTableViewer.getTable().getColumnCount()];
        int i = 0;
        while (i < colCnt) {
            editors[i] = this.createCellEditor((Composite)table, i);
            ++i;
        }
        this.fTableViewer.setCellEditors(editors);
        this.fTableViewer.formatViewer();
        UIJob job = new UIJob("resize to fit"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AbstractAsyncTableRendering.this.resizeColumnsToPreferredSize();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void doFormatTable() {
        int bytesPerLine = this.getBytesPerLine();
        int columnSize = this.getBytesPerColumn();
        int numColumns = bytesPerLine / columnSize;
        Table table = this.fTableViewer.getTable();
        TableColumn column0 = new TableColumn(table, 16384, 0);
        column0.setText(DebugUIMessages.AbstractTableRendering_2);
        TableColumn[] byteColumns = new TableColumn[numColumns];
        int i = 0;
        while (i < byteColumns.length) {
            TableColumn column;
            byteColumns[i] = column = new TableColumn(table, 16384, i + 1);
            ++i;
        }
        TableColumn emptyCol = new TableColumn(table, 16384, byteColumns.length + 1);
        emptyCol.setText(" ");
        emptyCol.setWidth(1);
        emptyCol.setResizable(false);
        table.setHeaderVisible(true);
        this.setColumnHeadings();
    }

    private String[] getColumnProperties() {
        int numColumns = this.getAddressableUnitPerLine() / this.getAddressableUnitPerColumn();
        String[] columnProperties = new String[numColumns + 2];
        columnProperties[0] = "address";
        int addressableUnit = this.getAddressableUnitPerColumn();
        int i = 1;
        while (i < columnProperties.length - 1) {
            columnProperties[i] = Integer.toHexString((i - 1) * addressableUnit);
            ++i;
        }
        columnProperties[columnProperties.length - 1] = " ";
        return columnProperties;
    }

    protected CellEditor createCellEditor(Composite composite, int column) {
        return new TextCellEditor(composite);
    }

    private ICellModifier newInternalCellModifier() {
        return new AsyncTableRenderingCellModifier(this, this.createCellModifier());
    }

    protected ICellModifier createCellModifier() {
        return null;
    }

    @Override
    public void dispose() {
        if (this.fIsDisposed) {
            return;
        }
        this.fIsDisposed = true;
        this.removeListeners();
        if (this.fMenuMgr != null) {
            this.fMenuMgr.removeAll();
            this.fMenuMgr.dispose();
            this.fMenuMgr = null;
        }
        if (this.fTableViewer != null) {
            if (this.fViewerListener != null) {
                this.fTableViewer.removeVirtualContentListener(this.fViewerListener);
            }
            if (this.fPresentationErrorListener != null) {
                this.fTableViewer.removePresentationErrorListener(this.fPresentationErrorListener);
            }
            this.fTableViewer.removeSelectionChangedListener(this.fViewerSelectionChangedListener);
            this.fTableViewer.getTable().getVerticalBar().removeSelectionListener((SelectionListener)this.fScrollBarSelectionListener);
            this.fTableViewer.dispose();
        }
        if (this.fPresentationContext != null) {
            this.fPresentationContext.dispose();
        }
        if (this.fToolTipShell != null && !this.fToolTipShell.isDisposed()) {
            this.fToolTipShell.dispose();
            this.fToolTipShell = null;
        }
        this.fIsDisposed = true;
        super.dispose();
    }

    protected void updateRenderingLabel(final boolean showAddress) {
        Job job = new Job("Update Rendering Label"){

            protected IStatus run(IProgressMonitor monitor) {
                if (AbstractAsyncTableRendering.this.fIsDisposed) {
                    return Status.OK_STATUS;
                }
                AbstractAsyncTableRendering.this.fLabel = AbstractAsyncTableRendering.this.buildLabel(showAddress);
                AbstractAsyncTableRendering.this.firePropertyChangedEvent(new PropertyChangeEvent((Object)AbstractAsyncTableRendering.this, "org.eclipse.jface.text", null, (Object)AbstractAsyncTableRendering.this.fLabel));
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.serialByRenderingRule);
        job.schedule();
    }

    private String buildLabel(boolean showAddress) {
        String preName;
        String label = "";
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            label = ((IMemoryBlockExtension)this.getMemoryBlock()).getExpression();
            if (label == null) {
                label = DebugUIMessages.AbstractTableRendering_8;
            }
            if (label.startsWith("&")) {
                label = "&" + label;
            }
            try {
                if (showAddress && ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress() != null) {
                    label = String.valueOf(label) + " : 0x";
                    label = String.valueOf(label) + ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress().toString(16).toUpperCase();
                }
            }
            catch (DebugException debugException) {}
        } else {
            long address = this.getMemoryBlock().getStartAddress();
            label = Long.toHexString(address).toUpperCase();
        }
        if ((preName = DebugUITools.getMemoryRenderingManager().getRenderingType(this.getRenderingId()).getLabel()) != null) {
            label = String.valueOf(label) + " <" + preName + ">";
        }
        return this.decorateLabel(label);
    }

    @Override
    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = DebugUIMessages.AbstractAsyncTableRendering_1;
            this.updateRenderingLabel(this.isVisible());
        }
        return this.fLabel;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IColorProvider.class) {
            return (T)this.getColorProviderAdapter();
        }
        if (adapter == ILabelProvider.class) {
            return (T)this.getLabelProviderAdapter();
        }
        if (adapter == IFontProvider.class) {
            return (T)this.getFontProviderAdapter();
        }
        if (adapter == IModelChangedListener.class) {
            return (T)this.fModelChangedListener;
        }
        if (adapter == IWorkbenchAdapter.class) {
            if (this.fWorkbenchAdapter == null) {
                this.fWorkbenchAdapter = new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return new Object[0];
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return null;
                    }

                    public String getLabel(Object o) {
                        return AbstractAsyncTableRendering.this.getLabel();
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            return (T)this.fWorkbenchAdapter;
        }
        if (adapter == TableRenderingContentDescriptor.class) {
            return (T)this.getContentDescriptor();
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public int getNumCharsPerByte() {
        return -1;
    }

    protected void createActions() {
        this.fCopyToClipboardAction = new AsyncCopyTableRenderingAction(this, this.fTableViewer);
        this.fGoToAddressAction = new RenderingGoToAddressAction(this.getMemoryRenderingContainer(), this);
        this.fResetMemoryBlockAction = new ResetToBaseAddressAction(this);
        this.fPrintViewTabAction = new AsyncPrintTableRenderingAction(this, this.fTableViewer);
        this.fFormatRenderingAction = new FormatTableRenderingAction(this);
        this.fReformatAction = new ReformatAction(this);
        this.fToggleAddressColumnAction = new ToggleAddressColumnAction();
        IMemoryRenderingSite site = this.getMemoryRenderingContainer().getMemoryRenderingSite();
        if (site.getSite().getSelectionProvider() != null) {
            this.fPropertiesDialogAction = new PropertyDialogAction((IShellProvider)site.getSite(), site.getSite().getSelectionProvider());
        }
        this.fNextAction = new NextPageAction();
        this.fPrevAction = new PrevPageAction();
    }

    @Override
    public BigInteger getSelectedAddress() {
        if (!this.fIsCreated) {
            return null;
        }
        Object key = this.fTableViewer.getSelectionKey();
        if (key != null && key instanceof BigInteger) {
            return (BigInteger)key;
        }
        return null;
    }

    @Override
    public MemoryByte[] getSelectedAsBytes() {
        if (this.getSelectedAddress() == null) {
            return new MemoryByte[0];
        }
        Object key = this.fTableViewer.getSelectionKey();
        AbstractVirtualContentTableModel model = this.fTableViewer.getVirtualContentModel();
        if (model != null) {
            int row;
            Object element;
            model = (AbstractVirtualContentTableModel)this.fTableViewer.getModel();
            int col = model.columnOf(element = model.getElement(row = model.indexOfKey(key)), key);
            if (col <= 0 || col > this.getBytesPerLine() / this.getBytesPerColumn()) {
                return new MemoryByte[0];
            }
            if (!(element instanceof MemorySegment)) {
                return new MemoryByte[0];
            }
            MemorySegment line = (MemorySegment)((Object)element);
            int offset = (col - 1) * (this.getAddressableUnitPerColumn() * this.getAddressableSize());
            MemoryByte[] bytes = line.getBytes(offset, this.getAddressableUnitPerColumn() * this.getAddressableSize());
            MemoryByte[] retBytes = new MemoryByte[bytes.length];
            System.arraycopy(bytes, 0, retBytes, 0, bytes.length);
            return retBytes;
        }
        return new MemoryByte[0];
    }

    @Override
    public String getSelectedAsString() {
        if (this.getSelectedAddress() == null) {
            return "";
        }
        MemoryByte[] bytes = this.getSelectedAsBytes();
        if (bytes.length > 0) {
            return this.getString(this.getRenderingId(), this.getSelectedAddress(), bytes);
        }
        return "";
    }

    @Override
    public void goToAddress(final BigInteger address) throws DebugException {
        if (!this.fIsCreated || this.fTableViewer.getVirtualContentModel() == null) {
            return;
        }
        final int keyIndex = this.fTableViewer.getVirtualContentModel().indexOfKey(address);
        if (keyIndex < 0) {
            if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
                Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5011, DebugUIMessages.AbstractTableRendering_11, null);
                DebugException e = new DebugException((IStatus)stat);
                throw e;
            }
            BigInteger startAdd = this.fContentDescriptor.getStartAddress();
            BigInteger endAdd = this.fContentDescriptor.getEndAddress();
            if (address.compareTo(startAdd) < 0 || address.compareTo(endAdd) > 0) {
                Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5011, DebugUIMessages.AbstractTableRendering_11, null);
                DebugException e = new DebugException((IStatus)stat);
                throw e;
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractAsyncTableRendering.this.showTable();
                if (keyIndex >= 0) {
                    AbstractAsyncTableRendering.this.fTableViewer.setSelection(address);
                    AbstractAsyncTableRendering.this.updateSyncTopAddress(AbstractAsyncTableRendering.this.getTopVisibleAddress());
                    AbstractAsyncTableRendering.this.updateSyncSelectedAddress(address);
                } else {
                    AbstractAsyncTableRendering.this.fTableViewer.setSelection(address);
                    AbstractAsyncTableRendering.this.reloadTable(address);
                    AbstractAsyncTableRendering.this.updateSyncSelectedAddress(address);
                    if (!AbstractAsyncTableRendering.this.isDynamicLoad()) {
                        AbstractAsyncTableRendering.this.updateSyncPageStartAddress(address);
                    }
                    AbstractAsyncTableRendering.this.updateSyncTopAddress(address);
                }
            }
        };
        this.runOnUIThread(runnable);
    }

    @Override
    public void refresh() {
        if (!this.fIsCreated) {
            return;
        }
        this.fTableViewer.refresh();
    }

    @Override
    public void resizeColumnsToPreferredSize() {
        if (!this.fIsCreated) {
            return;
        }
        this.fTableViewer.resizeColumnsToPreferredSize();
        if (!this.fIsShowAddressColumn) {
            final TableColumn column = this.fTableViewer.getTable().getColumn(0);
            column.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    column.removeControlListener((ControlListener)this);
                    column.setWidth(0);
                }
            });
        }
    }

    @Override
    public void updateLabels() {
        if (!this.fIsCreated) {
            return;
        }
        UIJob job = new UIJob("updateLabels"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (AbstractAsyncTableRendering.this.fPageBook.isDisposed()) {
                    return Status.OK_STATUS;
                }
                AbstractAsyncTableRendering.this.updateRenderingLabel(true);
                if (AbstractAsyncTableRendering.this.fTableViewer != null) {
                    AbstractAsyncTableRendering.this.setColumnHeadings();
                    AbstractAsyncTableRendering.this.fTableViewer.formatViewer();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(EMPTY_MEMORY_GROUP));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fResetMemoryBlockAction);
        menu.add((IAction)this.fGoToAddressAction);
        menu.add((IContributionItem)new Separator(EMPTY_NAVIGATION_GROUP));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fFormatRenderingAction);
        if (!this.isDynamicLoad() && this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fPrevAction);
            menu.add((IAction)this.fNextAction);
            menu.add((IContributionItem)new Separator(EMPTY_NON_AUTO_LOAD_GROUP));
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fReformatAction);
        menu.add((IAction)this.fToggleAddressColumnAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fCopyToClipboardAction);
        menu.add((IAction)this.fPrintViewTabAction);
        if (this.fPropertiesDialogAction != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fPropertiesDialogAction);
            menu.add((IContributionItem)new Separator(EMPTY_PROPERTY_GROUP));
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    private int getPageSizeInUnits() {
        return this.fPageSize * this.getAddressableUnitPerLine();
    }

    private void getPageSizeFromPreference() {
        this.fPageSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.pageSize");
    }

    private void getPreBufferSizeFromPreference() {
        this.fPreBufferSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.preBufferSize");
    }

    private void getPostBufferSizeFromPreference() {
        this.fPostBufferSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.postBufferSize");
    }

    private void updateDynamicLoadProperty() {
        boolean value = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        if (value != this.isDynamicLoad()) {
            this.setDynamicLoad(value);
            if (!this.fIsDisposed) {
                if (this.isDynamicLoad()) {
                    this.fContentDescriptor.setPostBuffer(this.getPostBufferSize());
                    this.fContentDescriptor.setPreBuffer(this.getPreBufferSize());
                    this.fContentDescriptor.setNumLines(this.getNumberOfVisibleLines());
                } else {
                    this.fContentDescriptor.setPostBuffer(0);
                    this.fContentDescriptor.setPreBuffer(0);
                    this.fContentDescriptor.setNumLines(this.fPageSize);
                }
            }
        }
    }

    private void getDynamicLoadFromPreference() {
        this.setDynamicLoad(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad"));
    }

    private boolean isDynamicLoad() {
        return this.fContentDescriptor.isDynamicLoad();
    }

    private int getPageSize() {
        return this.fPageSize;
    }

    private int getNumLinesToLoad() {
        int numberOfLines = -1;
        numberOfLines = this.isDynamicLoad() ? this.getNumberOfVisibleLines() : this.getPageSize();
        return numberOfLines;
    }

    private void setDynamicLoad(boolean load) {
        this.fContentDescriptor.setDynamicLoad(load);
    }

    private void handlePageStartAddressChanged(BigInteger address) {
        if (this.isDynamicLoad()) {
            return;
        }
        if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
            return;
        }
        if (this.isMemoryBlockBaseAddressChanged()) {
            return;
        }
        Object key = this.fTableViewer.getKey(0);
        if (key != null && key.equals(address)) {
            return;
        }
        BigInteger start = this.fContentDescriptor.getStartAddress();
        BigInteger end = this.fContentDescriptor.getEndAddress();
        if (address.compareTo(start) < 0) {
            if (this.isAtTopLimit()) {
                return;
            }
            address = start;
        }
        if (address.compareTo(end) > 0) {
            if (this.isAtBottomLimit()) {
                return;
            }
            address = end.subtract(BigInteger.valueOf(this.getPageSizeInUnits()));
        }
        this.fContentDescriptor.setLoadAddress(address);
        final BigInteger finaladdress = address;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (AbstractAsyncTableRendering.this.fTableViewer.getTable().isDisposed()) {
                    return;
                }
                AbstractAsyncTableRendering.this.fTableViewer.setTopIndex(finaladdress);
                AbstractAsyncTableRendering.this.refresh();
            }
        };
        this.runOnUIThread(runnable);
        this.updateSyncPageStartAddress(address);
        this.updateSyncTopAddress(address);
    }

    private void handleDyanicLoadChanged() {
        BigInteger pageStart = this.getTopVisibleAddress();
        this.updateSyncPageStartAddress(pageStart);
        this.updateDynamicLoadProperty();
        if (this.isDynamicLoad()) {
            this.refresh();
            this.fTableViewer.setTopIndex(pageStart);
        } else {
            this.handlePageStartAddressChanged(pageStart);
        }
    }

    @Override
    public void becomesHidden() {
        this.fPendingSyncProperties = new PendingPropertyChanges();
        super.becomesHidden();
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            this.updateRenderingLabel(false);
        }
    }

    @Override
    public void becomesVisible() {
        if (!this.fIsCreated) {
            this.updateRenderingLabel(true);
            super.becomesVisible();
            return;
        }
        if (this.isVisible()) {
            super.becomesVisible();
            return;
        }
        super.becomesVisible();
        if (this.fPendingSyncProperties != null) {
            BigInteger selectedAddress;
            boolean format = false;
            int rowSize = this.getBytesPerLine();
            if (this.fPendingSyncProperties.getRowSize() > 0) {
                format = true;
                rowSize = this.fPendingSyncProperties.getRowSize();
            }
            int colSize = this.getBytesPerColumn();
            if (this.fPendingSyncProperties.getColumnSize() > 0) {
                format = true;
                colSize = this.fPendingSyncProperties.getColumnSize();
            }
            if (format) {
                this.format(rowSize, colSize);
            }
            if ((selectedAddress = this.fPendingSyncProperties.getSelectedAddress()) != null) {
                this.fTableViewer.setSelection(selectedAddress);
            }
            this.updateDynamicLoadProperty();
            if (this.isDynamicLoad()) {
                BigInteger topVisibleAddress = this.fPendingSyncProperties.getTopVisibleAddress();
                if (topVisibleAddress != null) {
                    this.fContentDescriptor.setLoadAddress(topVisibleAddress);
                    this.fTableViewer.setTopIndex(topVisibleAddress);
                }
            } else if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
                BigInteger topVisibleAddress = this.fPendingSyncProperties.getTopVisibleAddress();
                if (topVisibleAddress != null) {
                    this.fTableViewer.setTopIndex(topVisibleAddress);
                }
            } else {
                BigInteger pageStartAddress;
                if (this.fPendingSyncProperties.getPageSize() > 0) {
                    this.fPageSize = this.fPendingSyncProperties.getPageSize();
                    this.fContentDescriptor.setNumLines(this.fPageSize);
                }
                if ((pageStartAddress = this.fPendingSyncProperties.getPageStartAddress()) != null) {
                    this.fContentDescriptor.setLoadAddress(pageStartAddress);
                }
                this.fTableViewer.setTopIndex(pageStartAddress);
            }
            this.showTable();
            this.refresh();
        }
        this.updateRenderingLabel(true);
        Job job = new Job("becomesVisible"){

            protected IStatus run(IProgressMonitor monitor) {
                if (AbstractAsyncTableRendering.this.fIsDisposed) {
                    return Status.OK_STATUS;
                }
                try {
                    AbstractAsyncTableRendering.this.fContentDescriptor.updateContentBaseAddress();
                }
                catch (DebugException e) {
                    AbstractAsyncTableRendering.this.showMessage(e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        this.fPendingSyncProperties = null;
    }

    private void columnSizeChanged(final int newColumnSize) {
        if (!this.isVisible()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int rowSize = AbstractAsyncTableRendering.this.getBytesPerLine();
                if (rowSize < newColumnSize) {
                    rowSize = newColumnSize;
                }
                AbstractAsyncTableRendering.this.format(rowSize, newColumnSize);
            }
        });
    }

    private void rowSizeChanged(final int newRowSize) {
        if (!this.isVisible()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int colSize = AbstractAsyncTableRendering.this.getBytesPerColumn();
                if (newRowSize < colSize) {
                    colSize = newRowSize;
                }
                AbstractAsyncTableRendering.this.format(newRowSize, colSize);
            }
        });
    }

    private void updateSyncSelectedAddress(BigInteger address) {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_SELECTED_ADDRESS, null, (Object)address);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncColSize() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_COL_SIZE, null, (Object)new Integer(this.fColumnSize));
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncRowSize() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_ROW_SIZE, null, (Object)new Integer(this.fBytePerLine));
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncTopAddress(BigInteger address) {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_TOP_ADDRESS, null, (Object)address);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncPageStartAddress(BigInteger address) {
        if (!this.fIsCreated) {
            return;
        }
        if (this.isMemoryBlockBaseAddressChanged()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "pageStart", null, (Object)address);
        this.firePropertyChangedEvent(event);
    }

    protected IColorProvider getColorProviderAdapter() {
        return (IColorProvider)this.getMemoryBlock().getAdapter(IColorProvider.class);
    }

    protected ILabelProvider getLabelProviderAdapter() {
        return (ILabelProvider)this.getMemoryBlock().getAdapter(ILabelProvider.class);
    }

    protected IFontProvider getFontProviderAdapter() {
        return (IFontProvider)this.getMemoryBlock().getAdapter(IFontProvider.class);
    }

    protected IMemoryBlockTablePresentation getTablePresentationAdapter() {
        return (IMemoryBlockTablePresentation)this.getMemoryBlock().getAdapter(IMemoryBlockTablePresentation.class);
    }

    private void createToolTip() {
        this.fToolTipShell = new Shell(DebugUIPlugin.getShell(), 16400);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        this.fToolTipShell.setLayout((Layout)gridLayout);
        this.fToolTipShell.setBackground(this.fTableViewer.getTable().getDisplay().getSystemColor(29));
        final Control toolTipControl = this.createToolTipControl((Composite)this.fToolTipShell);
        if (toolTipControl == null) {
            this.fToolTipShell.dispose();
            return;
        }
        MouseTrackAdapter listener = new MouseTrackAdapter(){
            private TableItem fTooltipItem = null;
            private int fCol = -1;

            public void mouseExit(MouseEvent e) {
                if (!AbstractAsyncTableRendering.this.fToolTipShell.isDisposed()) {
                    AbstractAsyncTableRendering.this.fToolTipShell.setVisible(false);
                }
                this.fTooltipItem = null;
            }

            public void mouseHover(MouseEvent e) {
                Point hoverPoint = new Point(e.x, e.y);
                Control control = null;
                if (e.widget instanceof Control) {
                    control = (Control)e.widget;
                }
                if (control == null) {
                    return;
                }
                hoverPoint = control.toDisplay(hoverPoint);
                TableItem item = AbstractAsyncTableRendering.this.getItem(hoverPoint);
                int column = AbstractAsyncTableRendering.this.getColumn(hoverPoint);
                if (this.fTooltipItem != item || this.fCol != column) {
                    this.fTooltipItem = item;
                    this.fCol = column;
                    if (item != null) {
                        AbstractAsyncTableRendering.this.toolTipAboutToShow(toolTipControl, this.fTooltipItem, column);
                        Rectangle shellBounds = AbstractAsyncTableRendering.this.fToolTipShell.getBounds();
                        shellBounds.x = hoverPoint.x;
                        shellBounds.y = hoverPoint.y + item.getBounds((int)0).height;
                        AbstractAsyncTableRendering.this.fToolTipShell.setBounds(shellBounds);
                        AbstractAsyncTableRendering.this.fToolTipShell.pack();
                        AbstractAsyncTableRendering.this.fToolTipShell.setVisible(true);
                    } else {
                        AbstractAsyncTableRendering.this.fToolTipShell.setVisible(false);
                    }
                }
            }
        };
        this.fTableViewer.getTable().addMouseTrackListener((MouseTrackListener)listener);
        this.fTableViewer.getCursor().addMouseTrackListener((MouseTrackListener)listener);
    }

    protected Control createToolTipControl(Composite composite) {
        Label fToolTipLabel = new Label(composite, 0);
        fToolTipLabel.setForeground(this.fTableViewer.getTable().getDisplay().getSystemColor(28));
        fToolTipLabel.setBackground(this.fTableViewer.getTable().getDisplay().getSystemColor(29));
        fToolTipLabel.setLayoutData((Object)new GridData(772));
        return fToolTipLabel;
    }

    private TableItem getItem(Point point) {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item.getData() != null) {
                Point start = new Point(item.getBounds((int)0).x, item.getBounds((int)0).y);
                start = this.fTableViewer.getTable().toDisplay(start);
                Point end = new Point(start.x + item.getBounds((int)0).width, start.y + item.getBounds((int)0).height);
                if (start.y < point.y && point.y < end.y) {
                    return item;
                }
            }
            ++i;
        }
        return null;
    }

    private int getColumn(Point point) {
        int colCnt = this.fTableViewer.getTable().getColumnCount();
        TableItem item = null;
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            item = this.fTableViewer.getTable().getItem(i);
            if (item.getData() != null) break;
            ++i;
        }
        if (item != null) {
            i = 0;
            while (i < colCnt) {
                Point start = new Point(item.getBounds((int)i).x, item.getBounds((int)i).y);
                start = this.fTableViewer.getTable().toDisplay(start);
                Point end = new Point(start.x + item.getBounds((int)i).width, start.y + item.getBounds((int)i).height);
                if (start.x < point.x && end.x > point.x) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void toolTipAboutToShow(Control toolTipControl, TableItem item, int col) {
        Object data;
        Object address;
        if (toolTipControl instanceof Label && (address = this.fTableViewer.getKey(this.fTableViewer.getTable().indexOf(item), col)) != null && address instanceof BigInteger && (data = item.getData()) instanceof MemorySegment) {
            MemorySegment line = (MemorySegment)((Object)data);
            if (col > 0) {
                int end;
                int start = (col - 1) * this.getBytesPerColumn();
                MemoryByte[] bytes = line.getBytes(start, end = start + this.getBytesPerColumn());
                String str = this.getToolTipText((BigInteger)address, bytes);
                if (str != null) {
                    ((Label)toolTipControl).setText(str);
                }
            } else {
                String str = this.getToolTipText((BigInteger)address, new MemoryByte[0]);
                if (str != null) {
                    ((Label)toolTipControl).setText(str);
                }
            }
        }
    }

    protected String getToolTipText(BigInteger address, MemoryByte[] bytes) {
        StringBuffer buf = new StringBuffer("0x");
        buf.append(address.toString(16).toUpperCase());
        return buf.toString();
    }

    private void setColumnHeadings() {
        String[] columnLabels = new String[]{};
        IMemoryBlockTablePresentation presentation = this.getTablePresentationAdapter();
        if (presentation != null) {
            columnLabels = presentation.getColumnLabels(this.getMemoryBlock(), this.getBytesPerLine(), this.getBytesPerLine() / this.getBytesPerColumn());
        }
        if (columnLabels == null) {
            columnLabels = new String[]{};
        }
        int numByteColumns = this.fBytePerLine / this.fColumnSize;
        TableColumn[] columns = this.fTableViewer.getTable().getColumns();
        int j = 0;
        int i = 1;
        while (i < columns.length - 1) {
            if (columnLabels.length == numByteColumns) {
                columns[i].setText(columnLabels[j]);
                ++j;
            } else {
                int addressableUnit = this.getAddressableUnitPerColumn();
                if (addressableUnit >= 4) {
                    columns[i].setText(String.valueOf(Integer.toHexString(j * addressableUnit).toUpperCase()) + " - " + Integer.toHexString(j * addressableUnit + addressableUnit - 1).toUpperCase());
                } else {
                    columns[i].setText(Integer.toHexString(j * addressableUnit).toUpperCase());
                }
                ++j;
            }
            ++i;
        }
    }

    public StructuredViewer getViewer() {
        return this.fTableViewer;
    }

    private boolean isMemoryBlockBaseAddressChanged() {
        try {
            BigInteger address = this.getMemoryBlockBaseAddress();
            BigInteger oldBaseAddress = this.fContentDescriptor.getContentBaseAddress();
            if (!oldBaseAddress.equals(address)) {
                return true;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    private void createContentDescriptor(BigInteger topVisibleAddress) {
        this.fContentDescriptor = new TableRenderingContentDescriptor(this);
        this.fContentDescriptor.setPostBuffer(this.getPostBufferSize());
        this.fContentDescriptor.setPreBuffer(this.getPreBufferSize());
        this.fContentDescriptor.setLoadAddress(topVisibleAddress);
        try {
            this.fContentDescriptor.updateContentBaseAddress();
        }
        catch (DebugException e) {
            this.fError = true;
            this.showMessage(e.getMessage());
        }
        this.fContentDescriptor.setAddressableSize(this.getAddressableSize());
        try {
            try {
                int addressSize = 4;
                if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                    IMemoryBlockExtension extMb = (IMemoryBlockExtension)this.getMemoryBlock();
                    addressSize = extMb.getAddressSize();
                    if (addressSize <= 0) {
                        DebugUIPlugin.logErrorMessage("Invalid address Size: " + addressSize);
                        addressSize = 4;
                    }
                    this.fContentDescriptor.setAddressSize(addressSize);
                }
                this.fContentDescriptor.setAddressSize(addressSize);
            }
            catch (DebugException e) {
                this.fError = true;
                this.showMessage(e.getMessage());
                if (this.fContentDescriptor.getAddressSize() <= 0) {
                    this.fContentDescriptor.setAddressSize(4);
                }
            }
        }
        finally {
            if (this.fContentDescriptor.getAddressSize() <= 0) {
                this.fContentDescriptor.setAddressSize(4);
            }
        }
    }

    private int getPreBufferSize() {
        if (this.fPreBufferSize < 0) {
            this.getPreBufferSizeFromPreference();
        }
        return this.fPreBufferSize;
    }

    private int getPostBufferSize() {
        if (this.fPostBufferSize < 0) {
            this.getPostBufferSizeFromPreference();
        }
        return this.fPostBufferSize;
    }

    private TableRenderingContentDescriptor getContentDescriptor() {
        return this.fContentDescriptor;
    }

    private void createGoToAddressComposite(Composite parent) {
        this.fGoToAddressComposite = new GoToAddressComposite();
        this.fGoToAddressComposite.createControl(parent);
        Button button = this.fGoToAddressComposite.getButton(0);
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractAsyncTableRendering.this.doGoToAddress();
                }
            });
            button = this.fGoToAddressComposite.getButton(1);
            if (button != null) {
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractAsyncTableRendering.this.hideGotoAddressComposite();
                    }
                });
            }
        }
        this.fGoToAddressComposite.getExpressionWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractAsyncTableRendering.this.doGoToAddress();
            }
        });
        this.fGoToAddressComposite.getExpressionWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    AbstractAsyncTableRendering.this.hideGotoAddressComposite();
                }
                super.keyPressed(e);
            }
        });
    }

    private void showGoToAddressComposite() {
        String selectedStr = this.getSelectedAsString();
        Text text = this.fGoToAddressComposite.getExpressionWidget();
        text.setText(selectedStr);
        text.setSelection(0, text.getCharCount());
        double height = this.fGoToAddressComposite.getHeight();
        double canvasHeight = this.fSashForm.getParent().getClientArea().height;
        double tableHeight = canvasHeight - height;
        double tableWeight = tableHeight / canvasHeight * 100.0;
        double textWeight = height / canvasHeight * 100.0;
        this.fSashForm.setWeights(new int[]{(int)tableWeight, (int)textWeight});
        this.fSashForm.setMaximizedControl(null);
        this.fGoToAddressComposite.getExpressionWidget().setFocus();
    }

    private void hideGotoAddressComposite() {
        this.fSashForm.setMaximizedControl(this.fTableViewer.getControl());
        if (this.isActivated()) {
            this.fTableViewer.getControl().setFocus();
        }
    }

    private void doGoToAddress() {
        try {
            BigInteger address = this.fGoToAddressComposite.getGoToAddress(this.fContentDescriptor.getContentBaseAddress(), this.getSelectedAddress());
            this.fGoToAddressAction.doGoToAddress(address.toString(16));
            this.hideGotoAddressComposite();
        }
        catch (DebugException e1) {
            MemoryViewUtil.openError(DebugUIMessages.GoToAddressAction_Go_to_address_failed, DebugUIMessages.GoToAddressAction_Go_to_address_failed, (Exception)((Object)e1));
        }
        catch (NumberFormatException e1) {
            MemoryViewUtil.openError(DebugUIMessages.GoToAddressAction_Go_to_address_failed, DebugUIMessages.GoToAddressAction_Address_is_invalid, e1);
        }
    }

    @Override
    public void activated() {
        super.activated();
        this.fActivated = true;
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        IContextService contextSupport = (IContextService)workbench.getAdapter(IContextService.class);
        if (commandSupport != null && contextSupport != null) {
            this.fContext.add(contextSupport.activateContext(ID_ASYNC_TABLE_RENDERING_CONTEXT));
            Command gotoCommand = commandSupport.getCommand(ID_GO_TO_ADDRESS_COMMAND);
            if (this.fGoToAddressHandler == null) {
                this.fGoToAddressHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent event) throws ExecutionException {
                        if (AbstractAsyncTableRendering.this.fSashForm.getMaximizedControl() != null) {
                            AbstractAsyncTableRendering.this.fGoToAddressAction.run();
                        } else {
                            AbstractAsyncTableRendering.this.hideGotoAddressComposite();
                        }
                        return null;
                    }
                };
            }
            gotoCommand.setHandler((IHandler)this.fGoToAddressHandler);
            if (this.fContentDescriptor != null && !this.isDynamicLoad()) {
                this.activatePageActions();
            }
        }
    }

    private void activatePageActions() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (commandSupport != null) {
            Command nextPage = commandSupport.getCommand(ID_NEXT_PAGE_COMMAND);
            if (this.fNextPageHandler == null) {
                this.fNextPageHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent arg0) throws ExecutionException {
                        AbstractAsyncTableRendering.this.fNextAction.run();
                        return null;
                    }
                };
            }
            nextPage.setHandler((IHandler)this.fNextPageHandler);
            Command prevPage = commandSupport.getCommand(ID_PREV_PAGE_COMMAND);
            if (this.fPrevPageHandler == null) {
                this.fPrevPageHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent arg0) throws ExecutionException {
                        AbstractAsyncTableRendering.this.fPrevAction.run();
                        return null;
                    }
                };
            }
            prevPage.setHandler((IHandler)this.fPrevPageHandler);
        }
    }

    @Override
    public void deactivated() {
        this.fActivated = false;
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        IContextService contextSupport = (IContextService)workbench.getAdapter(IContextService.class);
        if (commandSupport != null && contextSupport != null) {
            Command command = commandSupport.getCommand(ID_GO_TO_ADDRESS_COMMAND);
            command.setHandler(null);
            command = commandSupport.getCommand(ID_NEXT_PAGE_COMMAND);
            command.setHandler(null);
            command = commandSupport.getCommand(ID_PREV_PAGE_COMMAND);
            command.setHandler(null);
            if (this.fContext != null) {
                contextSupport.deactivateContexts(this.fContext);
            }
        }
        super.deactivated();
    }

    private boolean isActivated() {
        return this.fActivated;
    }

    @Override
    public abstract String getString(String var1, BigInteger var2, MemoryByte[] var3);

    @Override
    public abstract byte[] getBytes(String var1, BigInteger var2, MemoryByte[] var3, String var4);

    private class NextPageAction
    extends Action {
        private NextPageAction() {
            this.setText(DebugUIMessages.AbstractTableRendering_4);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.NextPageAction_context");
        }

        public void run() {
            BigInteger address = AbstractAsyncTableRendering.this.fContentDescriptor.getLoadAddress();
            address = address.add(BigInteger.valueOf(AbstractAsyncTableRendering.this.getPageSizeInUnits()));
            AbstractAsyncTableRendering.this.handlePageStartAddressChanged(address);
        }
    }

    private class PrevPageAction
    extends Action {
        private PrevPageAction() {
            this.setText(DebugUIMessages.AbstractTableRendering_6);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.PrevPageAction_context");
        }

        public void run() {
            BigInteger address = AbstractAsyncTableRendering.this.fContentDescriptor.getLoadAddress();
            address = address.subtract(BigInteger.valueOf(AbstractAsyncTableRendering.this.getPageSizeInUnits()));
            AbstractAsyncTableRendering.this.handlePageStartAddressChanged(address);
        }
    }

    private class RenderingGoToAddressAction
    extends GoToAddressAction {
        public RenderingGoToAddressAction(IMemoryRenderingContainer container, AbstractBaseTableRendering rendering) {
            super(container, rendering);
        }

        @Override
        public void run() {
            AbstractAsyncTableRendering.this.showGoToAddressComposite();
        }
    }

    private class SerialByObjectRule
    implements ISchedulingRule {
        private Object fObject = null;

        public SerialByObjectRule(Object lock) {
            this.fObject = lock;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof SerialByObjectRule) {
                SerialByObjectRule rRule = (SerialByObjectRule)rule;
                return this.fObject == rRule.fObject;
            }
            return false;
        }
    }

    private class SwitchPageJob
    extends UIJob {
        private Object fLock;
        private boolean fShowMessagePage;
        private String fMessage;

        private SwitchPageJob() {
            super("SwitchPageJob");
            this.fLock = new Object();
            this.fShowMessagePage = false;
            this.fMessage = "";
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setShowMessagePage(boolean showMsg) {
            Object object = this.fLock;
            synchronized (object) {
                this.fShowMessagePage = showMsg;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setMessage(String message) {
            Object object = this.fLock;
            synchronized (object) {
                this.fMessage = message;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (AbstractAsyncTableRendering.this.fPageBook.isDisposed()) {
                return Status.OK_STATUS;
            }
            String msgToShow = null;
            boolean showMsgPage = false;
            Object object = this.fLock;
            synchronized (object) {
                msgToShow = this.fMessage;
                showMsgPage = this.fShowMessagePage;
            }
            if (showMsgPage) {
                StyledText styleText = null;
                AbstractAsyncTableRendering.this.fShowMessage = true;
                styleText = AbstractAsyncTableRendering.this.fTextViewer.getTextWidget();
                if (styleText != null) {
                    styleText.setText(msgToShow);
                }
                AbstractAsyncTableRendering.this.fPageBook.showPage(AbstractAsyncTableRendering.this.fTextViewer.getControl());
            } else {
                AbstractAsyncTableRendering.this.fShowMessage = false;
                AbstractAsyncTableRendering.this.fPageBook.showPage((Control)AbstractAsyncTableRendering.this.fTableViewer.getControl().getParent());
            }
            return Status.OK_STATUS;
        }
    }

    private class ToggleAddressColumnAction
    extends Action {
        public ToggleAddressColumnAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.ShowAddressColumnAction_context");
            this.updateActionLabel();
        }

        public void run() {
            AbstractAsyncTableRendering.this.fIsShowAddressColumn = !AbstractAsyncTableRendering.this.fIsShowAddressColumn;
            if (!AbstractAsyncTableRendering.this.fIsShowAddressColumn) {
                AbstractAsyncTableRendering.this.fTableViewer.getTable().getColumn(0).setWidth(0);
            } else {
                AbstractAsyncTableRendering.this.fTableViewer.getTable().getColumn(0).pack();
            }
            this.updateActionLabel();
        }

        private void updateActionLabel() {
            if (AbstractAsyncTableRendering.this.fIsShowAddressColumn) {
                this.setText(DebugUIMessages.ShowAddressColumnAction_0);
            } else {
                this.setText(DebugUIMessages.ShowAddressColumnAction_1);
            }
        }
    }
}

