/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.io.InputStream;
import org.eclipse.e4.ui.css.core.util.resources.IResourcesLocatorManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSSWTImageHelper {
    private static final String DEFAULT_IMAGE = "defaultImage";
    private static final String DEFAULT_HOT_IMAGE = "defaultHotImage";
    private static final String DEFAULT_DISABLE_IMAGE = "defaultDisableImage";

    public static Image getImage(CSSValue value, IResourcesLocatorManager manager, Display display) throws Exception {
        if (value.getCssValueType() != 1) {
            return null;
        }
        CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value;
        switch (primitiveValue.getPrimitiveType()) {
            case 20: {
                String path = primitiveValue.getStringValue();
                return CSSSWTImageHelper.loadImageFromURL((Device)display, path, manager);
            }
        }
        return null;
    }

    private static Image loadImageFromURL(Device device, String path, IResourcesLocatorManager manager) throws Exception {
        Image result = null;
        try (InputStream in = null;){
            in = manager.getInputStream(path);
            if (in != null) {
                result = new Image(device, in);
            }
        }
        return result;
    }

    public static void storeDefaultImage(Shell shell) {
        CSSSWTImageHelper.storeDefaultImage((Widget)shell, DEFAULT_IMAGE, shell.getImage());
    }

    public static void storeDefaultImage(Item item) {
        CSSSWTImageHelper.storeDefaultImage((Widget)item, DEFAULT_IMAGE, item.getImage());
    }

    public static void storeDefaultImage(ToolItem item) {
        CSSSWTImageHelper.storeDefaultImage((Item)item);
        CSSSWTImageHelper.storeDefaultImage((Widget)item, DEFAULT_HOT_IMAGE, item.getHotImage());
        CSSSWTImageHelper.storeDefaultImage((Widget)item, DEFAULT_DISABLE_IMAGE, item.getDisabledImage());
    }

    public static void storeDefaultImage(Button button) {
        CSSSWTImageHelper.storeDefaultImage((Widget)button, DEFAULT_IMAGE, button.getImage());
    }

    public static void restoreDefaultImage(Shell shell) {
        Image defaultImage = (Image)shell.getData(DEFAULT_IMAGE);
        if (defaultImage != null) {
            shell.setImage(defaultImage.isDisposed() ? null : defaultImage);
        }
    }

    public static void restoreDefaultImage(Item item) {
        Image defaultImage = (Image)item.getData(DEFAULT_IMAGE);
        if (defaultImage != null) {
            item.setImage(defaultImage.isDisposed() ? null : defaultImage);
        }
    }

    public static void restoreDefaultImage(ToolItem item) {
        CSSSWTImageHelper.restoreDefaultImage((Item)item);
        Image defaultImage = (Image)item.getData(DEFAULT_HOT_IMAGE);
        if (defaultImage != null) {
            item.setHotImage(defaultImage.isDisposed() ? null : defaultImage);
        }
        if ((defaultImage = (Image)item.getData(DEFAULT_DISABLE_IMAGE)) != null) {
            item.setDisabledImage(defaultImage.isDisposed() ? null : defaultImage);
        }
    }

    public static void restoreDefaultImage(Button button) {
        Image defaultImage = (Image)button.getData(DEFAULT_IMAGE);
        if (defaultImage != null) {
            button.setImage(defaultImage.isDisposed() ? null : defaultImage);
        }
    }

    private static void storeDefaultImage(Widget widget, String imageName, Image image) {
        if (widget.getData(imageName) == null) {
            widget.setData(imageName, (Object)image);
        }
    }

    public static void setImage(Button button, Image image) {
        if (button.getImage() != image) {
            CSSSWTImageHelper.storeDefaultImage(button);
            button.setImage(image);
        }
    }

    public static void setBackgroundImage(Control control, Image image) {
        if (control instanceof Control && control.getBackgroundImage() != image) {
            control.setBackgroundImage(image);
        }
    }
}

