/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.parser.NavParser;
import org.eclipse.help.internal.webapp.servlet.NavServlet;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.eclipse.help.internal.webapp.utils.Utils;

public class NavService
extends NavServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean boolIsJSON;
        boolean boolIsHTML;
        req.setCharacterEncoding("UTF-8");
        String returnType = req.getParameter("returnType");
        boolean bl = boolIsHTML = returnType != null && returnType.equalsIgnoreCase("html");
        if (boolIsHTML) {
            this.processHTMLOutputRequest(req, resp);
            return;
        }
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setContentType("application/xml; charset=UTF-8");
        String response = this.processRequest(req, resp);
        boolean bl2 = boolIsJSON = returnType != null && returnType.equalsIgnoreCase("json");
        if (boolIsJSON) {
            resp.setContentType("text/plain");
            response = this.getJSONResponse(response);
        }
        resp.getWriter().write(response);
    }

    private void processHTMLOutputRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html; charset=UTF-8");
        String baseURL = req.getRequestURL().toString();
        String navURL = baseURL.replaceFirst("/vs/service", "");
        String query = req.getQueryString();
        if (query != null) {
            navURL = String.valueOf(navURL) + '?' + query;
        }
        URL url = new URL(navURL);
        String response = Utils.convertStreamToString(ProxyUtil.getStream((URL)url));
        response = Utils.updateResponse(response);
        ServletOutputStream out = resp.getOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        writer.write(response);
        writer.close();
    }

    protected String getJSONResponse(String response) throws IOException {
        NavParser navParser = new NavParser();
        InputStream is = null;
        try {
            if (response != null) {
                is = new ByteArrayInputStream(response.getBytes("UTF-8"));
                navParser.parse(is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (is != null) {
            is.close();
        }
        return navParser.toJSON();
    }

    private String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Locale locale = this.getLocale(req, resp);
        String path = req.getPathInfo().substring(1);
        int index = path.indexOf("service/nav/");
        if (index > -1) {
            path = path.substring(index + 12);
        }
        ITopic topic = this.getTopic(path, locale);
        AbstractHelpScope scope = RequestScope.getScope(req, resp, false);
        return this.writeContent(topic, path, locale, scope);
    }

    private String writeContent(ITopic topic, String path, Locale locale, AbstractHelpScope scope) {
        StringBuffer buff = new StringBuffer();
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buff.append("<nav\n      title=\"");
        buff.append(XMLGenerator.xmlEscape(topic.getLabel()));
        buff.append("\">");
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            if (ScopeUtils.showInTree((ITopic)subtopics[i], (AbstractHelpScope)scope)) {
                buff.append("\n        <topic\n          href=\"");
                String href = subtopics[i].getHref();
                href = href == null ? String.valueOf(path) + '_' + i : XMLGenerator.xmlEscape(UrlUtil.getHelpURL(href));
                buff.append(href);
                buff.append("\"\n          title=\"");
                buff.append(XMLGenerator.xmlEscape(subtopics[i].getLabel()));
                buff.append("\">\n        </topic>");
            }
            ++i;
        }
        buff.append("\n</nav>");
        return buff.toString();
    }
}

