/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Tree;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 1000;
    int scrollIndex = -1;
    long scrollBeginTime;
    int expandIndex = -1;
    long expandBeginTime;

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public void dragEnter(DropTargetEvent event) {
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragLeave(DropTargetEvent event) {
        Tree tree = (Tree)this.control;
        int handle = tree.handle;
        OS.gtk_tree_view_set_drag_dest_row(handle, 0, 0);
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
    }

    public void dragOver(DropTargetEvent event) {
        int indices;
        Tree tree = (Tree)this.control;
        int effect = this.checkEffect(event.feedback);
        int handle = tree.handle;
        Point coordinates = new Point(event.x, event.y);
        coordinates = tree.toControl(coordinates);
        int[] path = new int[1];
        OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
        int index = -1;
        if (path[0] != 0 && (indices = OS.gtk_tree_path_get_indices(path[0])) != 0) {
            int depth = OS.gtk_tree_path_get_depth(path[0]);
            int[] temp = new int[depth];
            OS.memmove(temp, indices, temp.length * 4);
            index = temp[temp.length - 1];
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (index != -1 && this.scrollIndex == index && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                GdkRectangle cellRect = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(handle, path[0], 0, cellRect);
                if (cellRect.y < cellRect.height) {
                    int[] tx = new int[1];
                    int[] ty = new int[1];
                    OS.gtk_tree_view_convert_bin_window_to_tree_coords(handle, cellRect.x, cellRect.y - cellRect.height, tx, ty);
                    OS.gtk_tree_view_scroll_to_point(handle, -1, ty[0]);
                } else {
                    OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y + cellRect.height, path, null, null, null);
                    if (path[0] != 0) {
                        OS.gtk_tree_view_scroll_to_cell(handle, path[0], 0, false, 0.0f, 0.0f);
                        OS.gtk_tree_path_free(path[0]);
                        path[0] = 0;
                    }
                    OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = index;
        }
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (index != -1 && this.expandIndex == index && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                OS.gtk_tree_view_expand_row(handle, path[0], false);
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandIndex = index;
        }
        if (path[0] != 0) {
            int position = -1;
            if ((effect & 1) != 0) {
                position = 2;
            }
            if ((effect & 2) != 0) {
                position = 0;
            }
            if ((effect & 4) != 0) {
                position = 1;
            }
            if (position != -1) {
                OS.gtk_tree_view_set_drag_dest_row(handle, path[0], position);
            } else {
                OS.gtk_tree_view_set_drag_dest_row(handle, 0, 0);
            }
        } else {
            OS.gtk_tree_view_set_drag_dest_row(handle, 0, 0);
        }
        if (path[0] != 0) {
            OS.gtk_tree_path_free(path[0]);
        }
    }
}

