/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.trace;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.tracecompass.btf.core.Messages;
import org.eclipse.tracecompass.btf.core.event.BtfEventType;

public final class BtfEventTypeFactory {
    private static final Map<String, BtfEventType> TYPES;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"STI", (Object)new BtfEventType(Messages.BtfTypeId_STIName, Messages.BtfTypeId_STIDescr));
        builder.put((Object)"T", (Object)new BtfEventType(Messages.BtfTypeId_TName, Messages.BtfTypeId_TDescr));
        builder.put((Object)"ISR", (Object)new BtfEventType(Messages.BtfTypeId_ISRName, Messages.BtfTypeId_ISRDescr));
        builder.put((Object)"R", (Object)new BtfEventType(Messages.BtfTypeId_RName, Messages.BtfTypeId_RDescr));
        builder.put((Object)"IB", (Object)new BtfEventType(Messages.BtfTypeId_IBName, Messages.BtfTypeId_IBDescr));
        builder.put((Object)"ECU", (Object)new BtfEventType(Messages.BtfTypeId_ECUName, Messages.BtfTypeId_ECUDescr));
        builder.put((Object)"P", (Object)new BtfEventType(Messages.BtfTypeId_PName, Messages.BtfTypeId_PDescr));
        builder.put((Object)"C", (Object)new BtfEventType(Messages.BtfTypeId_CName, Messages.BtfTypeId_CDescr));
        builder.put((Object)"SCHED", (Object)new BtfEventType(Messages.BtfTypeId_SCHEDName, Messages.BtfTypeId_SCHEDDescr));
        builder.put((Object)"SIG", (Object)new BtfEventType(Messages.BtfTypeId_SIGName, Messages.BtfTypeId_SIGDescr));
        builder.put((Object)"SEM", (Object)new BtfEventType(Messages.BtfTypeId_SEMName, Messages.BtfTypeId_SEMDescr));
        builder.put((Object)"SIM", (Object)new BtfEventType(Messages.BtfTypeId_SIMName, Messages.BtfTypeId_SIMDescr));
        TYPES = builder.build();
    }

    private BtfEventTypeFactory() {
    }

    public static BtfEventType parse(String typeName) {
        return TYPES.get(typeName);
    }
}

