/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.BundleContext;

public abstract class TraceCompassActivator
extends Plugin {
    private static final Map<String, TraceCompassActivator> ACTIVATORS = new HashMap<String, TraceCompassActivator>();
    private final String fPluginId;

    public TraceCompassActivator(String pluginID) {
        this.fPluginId = pluginID;
    }

    public String getPluginId() {
        return this.fPluginId;
    }

    protected static TraceCompassActivator getInstance(String id) {
        TraceCompassActivator ret = ACTIVATORS.get(id);
        if (ret == null) {
            throw new IllegalStateException();
        }
        return ret;
    }

    protected abstract void startActions();

    protected abstract void stopActions();

    public final void start(@Nullable BundleContext context) throws Exception {
        super.start(context);
        String id = this.getPluginId();
        if (ACTIVATORS.containsKey(id)) {
            this.logError("Duplicate Activator ID : " + id);
        }
        ACTIVATORS.put(id, this);
        this.startActions();
    }

    public final void stop(@Nullable BundleContext context) throws Exception {
        this.stopActions();
        ACTIVATORS.remove(this.getPluginId());
        super.stop(context);
    }

    public void logInfo(String message) {
        this.getLog().log((IStatus)new Status(1, this.fPluginId, message));
    }

    public void logInfo(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(1, this.fPluginId, message, exception));
    }

    public void logWarning(String message) {
        this.getLog().log((IStatus)new Status(2, this.fPluginId, message));
    }

    public void logWarning(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(2, this.fPluginId, message, exception));
    }

    public void logError(String message) {
        this.getLog().log((IStatus)new Status(4, this.fPluginId, message));
    }

    public void logError(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(4, this.fPluginId, message, exception));
    }
}

