/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;

public class StructDeclaration
extends Declaration {
    @NonNull
    private final Map<String, IDeclaration> fFieldMap = new LinkedHashMap<String, IDeclaration>();
    private long fMaxAlign;
    private static final Pattern EVENT_HEADER = Pattern.compile(String.valueOf(ILexicalScope.EVENT_HEADER.getPath().replaceAll("\\.", "\\\\.")) + "\\.");

    public StructDeclaration(long align) {
        this.fMaxAlign = Math.max(align, 1L);
    }

    public long getMaxAlign() {
        return this.fMaxAlign;
    }

    public boolean hasField(String name) {
        return this.fFieldMap.containsKey(name);
    }

    public Map<String, IDeclaration> getFields() {
        return this.fFieldMap;
    }

    @Nullable
    public IDeclaration getField(String fieldName) {
        return this.fFieldMap.get(fieldName);
    }

    public Iterable<String> getFieldsList() {
        return this.fFieldMap.keySet();
    }

    @Override
    public long getAlignment() {
        return this.fMaxAlign;
    }

    @Override
    public int getMaximumSize() {
        int maxSize = 0;
        for (IDeclaration field : this.fFieldMap.values()) {
            maxSize += field.getMaximumSize();
        }
        return Math.min(maxSize, Integer.MAX_VALUE);
    }

    @Override
    public StructDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        Definition[] myFields = new Definition[this.fFieldMap.size()];
        StructDefinition structDefinition = null;
        if (definitionScope == null) {
            InternalDef localDefinitionScope = new InternalDef(null, null);
            structDefinition = new StructDefinition(this, (IDefinitionScope)localDefinitionScope, fieldName, myFields);
            localDefinitionScope.setDefinition(structDefinition);
        } else {
            structDefinition = new StructDefinition(this, definitionScope, fieldName, myFields);
        }
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public StructDefinition createDefinition(IDefinitionScope definitionScope, ILexicalScope fieldScope, @NonNull BitBuffer input) throws CTFException {
        this.alignRead(input);
        Definition[] myFields = new Definition[this.fFieldMap.size()];
        StructDefinition structDefinition = new StructDefinition(this, definitionScope, fieldScope, fieldScope.getName(), (Iterable)NonNullUtils.checkNotNull(this.fFieldMap.keySet()), myFields);
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public void addField(String name, IDeclaration declaration) {
        this.fFieldMap.put(name, declaration);
        this.fMaxAlign = Math.max(this.fMaxAlign, declaration.getAlignment());
    }

    private void fillStruct(@NonNull BitBuffer input, Definition[] myFields, StructDefinition structDefinition) throws CTFException {
        Iterator<Map.Entry<String, IDeclaration>> iter = this.fFieldMap.entrySet().iterator();
        int i = 0;
        while (i < this.fFieldMap.size()) {
            Map.Entry<String, IDeclaration> entry = iter.next();
            String key = (String)NonNullUtils.checkNotNull((Object)entry.getKey());
            myFields[i] = entry.getValue().createDefinition(structDefinition, key, input);
            ++i;
        }
    }

    public StructDefinition createFieldDefinition(ICompositeDefinition eventHeaderDef, IDefinitionScope definitionScope, ILexicalScope fields, @NonNull BitBuffer input) throws CTFException {
        this.alignRead(input);
        Definition[] myFields = new Definition[this.fFieldMap.size()];
        IDefinitionScope merged = definitionScope;
        if (eventHeaderDef != null) {
            merged = new InternalDef(definitionScope, eventHeaderDef);
        }
        StructDefinition structDefinition = new StructDefinition(this, merged, fields, fields.getName(), (Iterable)NonNullUtils.checkNotNull(this.fFieldMap.keySet()), myFields);
        if (merged instanceof InternalDef) {
            InternalDef internalDef = (InternalDef)merged;
            internalDef.setDefinition(structDefinition);
        }
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] struct[");
        for (Map.Entry<String, IDeclaration> field : this.fFieldMap.entrySet()) {
            sb.append(field.getKey()).append(':').append(field.getValue());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (Map.Entry<String, IDeclaration> field : this.fFieldMap.entrySet()) {
            result = 31 * result + field.getKey().hashCode();
            result = 31 * result + field.getValue().hashCode();
        }
        result = 31 * result + (int)(this.fMaxAlign ^ this.fMaxAlign >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration other = (StructDeclaration)obj;
        if (this.fFieldMap.size() != other.fFieldMap.size()) {
            return false;
        }
        ArrayList<String> localFieldNames = new ArrayList<String>();
        localFieldNames.addAll(this.fFieldMap.keySet());
        ArrayList<IDeclaration> localDecs = new ArrayList<IDeclaration>();
        localDecs.addAll(this.fFieldMap.values());
        ArrayList<String> otherFieldNames = new ArrayList<String>();
        otherFieldNames.addAll(other.fFieldMap.keySet());
        ArrayList<IDeclaration> otherDecs = new ArrayList<IDeclaration>();
        otherDecs.addAll(other.fFieldMap.values());
        int i = 0;
        while (i < this.fFieldMap.size()) {
            if (!((String)localFieldNames.get(i)).equals(otherFieldNames.get(i)) || !((IDeclaration)otherDecs.get(i)).equals(localDecs.get(i))) {
                return false;
            }
            ++i;
        }
        return this.fMaxAlign == other.fMaxAlign;
    }

    @Override
    public boolean isBinaryEquivalent(IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration other = (StructDeclaration)obj;
        if (this.fFieldMap.size() != other.fFieldMap.size()) {
            return false;
        }
        ArrayList<IDeclaration> localDecs = new ArrayList<IDeclaration>();
        localDecs.addAll(this.fFieldMap.values());
        ArrayList<IDeclaration> otherDecs = new ArrayList<IDeclaration>();
        otherDecs.addAll(other.fFieldMap.values());
        int i = 0;
        while (i < this.fFieldMap.size()) {
            if (!((IDeclaration)otherDecs.get(i)).isBinaryEquivalent((IDeclaration)localDecs.get(i))) {
                return false;
            }
            ++i;
        }
        return this.fMaxAlign == other.fMaxAlign;
    }

    static class InternalDef
    implements IDefinitionScope {
        private final ICompositeDefinition fEventHeaderDef;
        private final IDefinitionScope fTraceDef;
        private StructDefinition fDefinition;

        public InternalDef(IDefinitionScope definitionScope, ICompositeDefinition eventHeaderDef) {
            this.fTraceDef = definitionScope;
            this.fEventHeaderDef = eventHeaderDef;
        }

        @Override
        public ILexicalScope getScopePath() {
            return ILexicalScope.EVENT;
        }

        @Override
        public IDefinition lookupDefinition(String lookupPath) {
            IDefinition lookupDefinition = null;
            if (this.fTraceDef != null) {
                lookupDefinition = this.fTraceDef.lookupDefinition(lookupPath);
            }
            if (lookupDefinition == null && this.fEventHeaderDef != null) {
                String[] paths = EVENT_HEADER.split(lookupPath);
                if (paths.length > 1) {
                    String[] childLookup = paths[1].split("\\.");
                    return this.getRecursiveDef(this.fEventHeaderDef.getDefinition(childLookup[0]), childLookup, 1);
                }
                if (this.fDefinition != null) {
                    return this.fDefinition.lookupDefinition(lookupPath);
                }
            }
            return lookupDefinition;
        }

        public IDefinition lookupDefinitionBreakLoop(String lookupPath) {
            String[] paths;
            IDefinition lookupDefinition = null;
            if (this.fTraceDef != null) {
                lookupDefinition = this.fTraceDef.lookupDefinition(lookupPath);
            }
            if (lookupDefinition == null && this.fEventHeaderDef != null && (paths = EVENT_HEADER.split(lookupPath)).length > 1) {
                String[] childLookup = paths[1].split("\\.");
                return this.getRecursiveDef(this.fEventHeaderDef.getDefinition(childLookup[0]), childLookup, 1);
            }
            return lookupDefinition;
        }

        private IDefinition getRecursiveDef(Definition definition, String[] childLookup, int i) {
            if (i == childLookup.length) {
                return definition;
            }
            if (definition instanceof ICompositeDefinition) {
                ICompositeDefinition compositeDefinition = (ICompositeDefinition)((Object)definition);
                return this.getRecursiveDef(compositeDefinition.getDefinition(childLookup[i]), childLookup, i + 1);
            }
            return null;
        }

        public void setDefinition(StructDefinition definition) {
            this.fDefinition = definition;
        }
    }
}

