/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model;

public class VirtualMachine {
    private final long fVmUid;
    private final String fHostId;
    private final MachineType fType;

    public static VirtualMachine newHostMachine(String hostId) {
        return new VirtualMachine(MachineType.HOST, hostId, -1L);
    }

    public static VirtualMachine newGuestMachine(long uid, String hostId) {
        return new VirtualMachine(MachineType.GUEST, hostId, uid);
    }

    private VirtualMachine(MachineType type, String hostId, long uid) {
        this.fType = type;
        this.fVmUid = uid;
        this.fHostId = hostId;
    }

    public boolean isGuest() {
        return this.fType == MachineType.GUEST;
    }

    public long getVmUid() {
        return this.fVmUid;
    }

    public String getHostId() {
        return this.fHostId;
    }

    public String toString() {
        return "VirtualMachine: " + this.fHostId;
    }

    private static enum MachineType {
        HOST,
        GUEST;

    }
}

