/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlStateAttribute
implements ITmfXmlStateAttribute {
    private final StateAttributeType fType;
    @Nullable
    private final String fName;
    private final List<ITmfXmlStateAttribute> fQueryList = new LinkedList<ITmfXmlStateAttribute>();
    private final IXmlStateSystemContainer fContainer;

    protected TmfXmlStateAttribute(ITmfXmlModelFactory modelFactory, Element attribute, IXmlStateSystemContainer container) {
        this.fContainer = container;
        switch (attribute.getAttribute("type")) {
            case "constant": {
                this.fType = StateAttributeType.CONSTANT;
                this.fName = this.fContainer.getAttributeValue(attribute.getAttribute("value"));
                break;
            }
            case "eventField": {
                this.fType = StateAttributeType.EVENTFIELD;
                this.fName = this.fContainer.getAttributeValue(attribute.getAttribute("value"));
                break;
            }
            case "location": {
                this.fType = StateAttributeType.LOCATION;
                this.fName = this.fContainer.getAttributeValue(attribute.getAttribute("value"));
                break;
            }
            case "query": {
                List<Element> childElements = XmlUtils.getChildElements(attribute);
                for (Element subAttributeNode : childElements) {
                    if (subAttributeNode == null) continue;
                    ITmfXmlStateAttribute subAttribute = modelFactory.createStateAttribute(subAttributeNode, this.fContainer);
                    this.fQueryList.add(subAttribute);
                }
                this.fType = StateAttributeType.QUERY;
                this.fName = null;
                break;
            }
            case "eventName": {
                this.fType = StateAttributeType.EVENTNAME;
                this.fName = this.fContainer.getAttributeValue(attribute.getAttribute("value"));
                break;
            }
            case "": {
                this.fType = StateAttributeType.NONE;
                this.fName = null;
                break;
            }
            case "self": {
                this.fType = StateAttributeType.SELF;
                this.fName = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("TmfXmlStateAttribute constructor: The XML element is not of the right type");
            }
        }
    }

    @Override
    public int getAttributeQuark(int startQuark) {
        return this.getAttributeQuark(null, startQuark);
    }

    protected abstract int getQuarkAbsoluteAndAdd(String ... var1) throws AttributeNotFoundException;

    protected abstract int getQuarkRelativeAndAdd(int var1, String ... var2) throws AttributeNotFoundException;

    @Nullable
    protected ITmfStateSystem getStateSystem() {
        return this.fContainer.getStateSystem();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getAttributeQuark(@Nullable ITmfEvent event, int startQuark) {
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            throw new IllegalStateException("The state system hasn't been initialized yet");
        }
        try {
            switch (this.fType) {
                case CONSTANT: {
                    if (startQuark == -1) {
                        return this.getQuarkAbsoluteAndAdd(this.fName);
                    }
                    return this.getQuarkRelativeAndAdd(startQuark, this.fName);
                }
                case EVENTFIELD: {
                    int quark = -1;
                    if (event == null) {
                        Activator.logWarning("XML State attribute: looking for an event field, but event is null");
                        return quark;
                    }
                    String name = this.fName;
                    if (name == null) {
                        throw new IllegalStateException();
                    }
                    if (name.equals("cpu")) {
                        Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                        if (cpuObj == null) return quark;
                        Integer cpu = (Integer)cpuObj;
                        return this.getQuarkRelativeAndAdd(startQuark, cpu.toString());
                    }
                    ITmfEventField content = event.getContent();
                    if (content.getField(new String[]{this.fName}) == null) {
                        return -1;
                    }
                    Object field = content.getField(new String[]{this.fName}).getValue();
                    if (field instanceof String) {
                        String fieldString = (String)field;
                        return this.getQuarkRelativeAndAdd(startQuark, fieldString);
                    }
                    if (field instanceof Long) {
                        Long fieldLong = (Long)field;
                        return this.getQuarkRelativeAndAdd(startQuark, fieldLong.toString());
                    }
                    if (!(field instanceof Integer)) return quark;
                    Integer fieldInterger = (Integer)field;
                    return this.getQuarkRelativeAndAdd(startQuark, fieldInterger.toString());
                }
                case QUERY: {
                    ITmfXmlStateAttribute attrib;
                    TmfStateValue value = TmfStateValue.nullValue();
                    int quarkQuery = -1;
                    Iterator<ITmfXmlStateAttribute> iterator = this.fQueryList.iterator();
                    while (iterator.hasNext() && (quarkQuery = (attrib = iterator.next()).getAttributeQuark(event, quarkQuery)) != -1) {
                    }
                    if (quarkQuery != -1) {
                        value = ss.queryOngoingState(quarkQuery);
                    }
                    switch (value.getType()) {
                        case INTEGER: {
                            int result = value.unboxInt();
                            return this.getQuarkRelativeAndAdd(startQuark, String.valueOf(result));
                        }
                        case LONG: {
                            long result = value.unboxLong();
                            return this.getQuarkRelativeAndAdd(startQuark, String.valueOf(result));
                        }
                        case STRING: {
                            String result = value.unboxStr();
                            return this.getQuarkRelativeAndAdd(startQuark, result);
                        }
                    }
                    return -1;
                }
                case LOCATION: {
                    TmfXmlLocation location;
                    int quark = startQuark;
                    String idLocation = this.fName;
                    Iterator<TmfXmlLocation> iterator = this.fContainer.getLocations().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return quark;
                    } while (!(location = iterator.next()).getId().equals(idLocation) || (quark = location.getLocationQuark(event, quark)) != -1);
                    return quark;
                }
                case EVENTNAME: {
                    int quark = -1;
                    if (event == null) {
                        Activator.logWarning("XML State attribute: looking for an eventname, but event is null");
                        return quark;
                    }
                    return this.getQuarkRelativeAndAdd(startQuark, event.getName());
                }
                case SELF: {
                    return startQuark;
                }
            }
            return startQuark;
        }
        catch (AttributeNotFoundException ae) {
            return -1;
        }
        catch (StateValueTypeException e) {
            Activator.logError("StateValueTypeException", e);
            return -1;
        }
    }

    public String toString() {
        return "TmfXmlStateAttribute " + (Object)((Object)this.fType) + ": " + this.fName;
    }

    private static enum StateAttributeType {
        NONE,
        CONSTANT,
        EVENTFIELD,
        QUERY,
        LOCATION,
        SELF,
        EVENTNAME;

    }
}

