/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.TmfXmlCondition;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TmfXmlStateChange {
    private final IXmlStateChange fChange;
    private final IXmlStateSystemContainer fContainer;

    public TmfXmlStateChange(ITmfXmlModelFactory modelFactory, Element statechange, IXmlStateSystemContainer container) {
        this.fContainer = container;
        Node ifNode = statechange.getElementsByTagName("if").item(0);
        this.fChange = ifNode != null ? new XmlConditionalChange(modelFactory, statechange) : new XmlStateValueChange(modelFactory, statechange);
    }

    public void handleEvent(ITmfEvent event) throws AttributeNotFoundException, StateValueTypeException, TimeRangeException {
        this.fChange.handleEvent(event);
    }

    public String toString() {
        return "TmfXmlStateChange: " + this.fChange;
    }

    private static interface IXmlStateChange {
        public void handleEvent(ITmfEvent var1) throws AttributeNotFoundException, StateValueTypeException, TimeRangeException;
    }

    private class XmlConditionalChange
    implements IXmlStateChange {
        private final TmfXmlCondition fCondition;
        private final TmfXmlStateChange fThenChange;
        @Nullable
        private final TmfXmlStateChange fElseChange;

        public XmlConditionalChange(ITmfXmlModelFactory modelFactory, Element statechange) {
            Node ifNode = statechange.getElementsByTagName("if").item(0);
            if (ifNode == null) {
                throw new IllegalArgumentException();
            }
            this.fCondition = modelFactory.createCondition((Element)ifNode, TmfXmlStateChange.this.fContainer);
            Node thenNode = statechange.getElementsByTagName("then").item(0);
            if (thenNode == null) {
                throw new IllegalArgumentException("Conditional state change: there should be a then clause.");
            }
            this.fThenChange = modelFactory.createStateChange((Element)thenNode, TmfXmlStateChange.this.fContainer);
            Node elseNode = statechange.getElementsByTagName("else").item(0);
            this.fElseChange = elseNode != null ? modelFactory.createStateChange((Element)elseNode, TmfXmlStateChange.this.fContainer) : null;
        }

        @Override
        public void handleEvent(@NonNull ITmfEvent event) throws AttributeNotFoundException, StateValueTypeException, TimeRangeException {
            TmfXmlStateChange toExecute = this.fThenChange;
            try {
                if (!this.fCondition.testForEvent(event)) {
                    toExecute = this.fElseChange;
                }
            }
            catch (AttributeNotFoundException e) {
                return;
            }
            if (toExecute == null) {
                return;
            }
            toExecute.handleEvent(event);
        }

        public String toString() {
            return "Condition: " + this.fCondition;
        }
    }

    private class XmlStateValueChange
    implements IXmlStateChange {
        private final ITmfXmlStateValue fValue;

        public XmlStateValueChange(ITmfXmlModelFactory modelFactory, Element statechange) {
            List<Element> childElements = XmlUtils.getChildElements(statechange);
            Element stateValueElement = childElements.remove(childElements.size() - 1);
            if (stateValueElement == null) {
                throw new IllegalStateException();
            }
            ArrayList<ITmfXmlStateAttribute> attributes = new ArrayList<ITmfXmlStateAttribute>();
            for (Element element : childElements) {
                if (!element.getNodeName().equals("stateAttribute")) {
                    throw new IllegalArgumentException("TmfXmlStateChange: a state change must have only TmfXmlStateAttribute elements before the state value");
                }
                ITmfXmlStateAttribute attribute = modelFactory.createStateAttribute(element, TmfXmlStateChange.this.fContainer);
                attributes.add(attribute);
            }
            if (attributes.isEmpty()) {
                throw new IllegalArgumentException("TmfXmlStateChange: a state change must have at least one TmfXmlStateAttribute element before the state value");
            }
            this.fValue = modelFactory.createStateValue(stateValueElement, TmfXmlStateChange.this.fContainer, attributes);
        }

        @Override
        public void handleEvent(@NonNull ITmfEvent event) throws AttributeNotFoundException, StateValueTypeException, TimeRangeException {
            this.fValue.handleEvent(event);
        }

        public String toString() {
            return "Value: " + this.fValue;
        }
    }
}

