/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class TmfEventField
implements ITmfEventField {
    @NonNull
    private final String fName;
    @Nullable
    private final Object fValue;
    @NonNull
    private final Map<String, ITmfEventField> fFields;

    public TmfEventField(String name, @Nullable Object value, @Nullable ITmfEventField[] fields) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.fName = name;
        this.fValue = value;
        if (fields == null) {
            this.fFields = (Map)NonNullUtils.checkNotNull((Object)ImmutableMap.of());
        } else {
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            ITmfEventField[] iTmfEventFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfEventField field = iTmfEventFieldArray[n2];
                String curName = field.getName();
                mapBuilder.put((Object)curName, (Object)field);
                ++n2;
            }
            this.fFields = (Map)NonNullUtils.checkNotNull((Object)mapBuilder.build());
        }
    }

    public TmfEventField(TmfEventField field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.fName = field.fName;
        this.fValue = field.fValue;
        this.fFields = field.fFields;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Object getValue() {
        return this.fValue;
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fFields.keySet();
    }

    public Collection<ITmfEventField> getFields() {
        return this.fFields.values();
    }

    @Override
    public ITmfEventField getField(String ... path) {
        if (path.length == 1) {
            return this.fFields.get(path[0]);
        }
        ITmfEventField field = this;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if ((field = field.getField(name)) == null) {
                return null;
            }
            ++n2;
        }
        return field;
    }

    public static final ITmfEventField makeRoot(String[] labels) {
        ITmfEventField[] fields = new ITmfEventField[labels.length];
        int i = 0;
        while (i < labels.length) {
            fields[i] = new TmfEventField(labels[i], null, null);
            ++i;
        }
        return new TmfEventField(":root:", null, fields);
    }

    public int hashCode() {
        Object value = this.fValue;
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fName.hashCode();
        result = 31 * result + (value == null ? 0 : value.hashCode());
        result = 31 * result + this.fFields.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventField)) {
            return false;
        }
        TmfEventField other = (TmfEventField)obj;
        if (!this.fName.equals(other.fName)) {
            return false;
        }
        Object value = this.fValue;
        if (value == null ? other.fValue != null : !value.equals(other.fValue)) {
            return false;
        }
        return this.fFields.equals(other.fFields);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.fName.equals(":root:")) {
            this.appendSubFields(ret);
        } else {
            ret.append(this.fName);
            ret.append('=');
            ret.append(this.fValue);
            if (!this.fFields.isEmpty()) {
                ret.append(" [");
                this.appendSubFields(ret);
                ret.append(']');
            }
        }
        return ret.toString();
    }

    private void appendSubFields(StringBuilder sb) {
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        sb.append(joiner.join(this.getFields()));
    }

    @Override
    public String getFormattedValue() {
        return this.getValue().toString();
    }
}

